/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.agent.plugin.core.context;

import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.agent.plugin.core.holder.ShardingSphereDataSourceContextHolder;
import org.apache.shardingsphere.infra.config.props.ConfigurationPropertyKey;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;

public final class PluginContext {
    private static final PluginContext INSTANCE = new PluginContext();
    private ContextManager contextManager;
    private boolean isEnhancedForProxy;

    public static PluginContext getInstance() {
        return INSTANCE;
    }

    public boolean isPluginEnabled() {
        if (null == this.contextManager) {
            this.contextManager = this.getContextManager().orElse(null);
        }
        return null == this.contextManager || (Boolean)this.contextManager.getMetaDataContexts().getMetaData().getProps().getValue((Enum)ConfigurationPropertyKey.AGENT_PLUGINS_ENABLED) != false;
    }

    private Optional<ContextManager> getContextManager() {
        if (this.isEnhancedForProxy) {
            return Optional.ofNullable(ProxyContext.getInstance().getContextManager());
        }
        return ShardingSphereDataSourceContextHolder.getShardingSphereDataSourceContexts().isEmpty() ? Optional.empty() : Optional.of(ShardingSphereDataSourceContextHolder.getShardingSphereDataSourceContexts().values().iterator().next().getContextManager());
    }

    @Generated
    private PluginContext() {
    }

    @Generated
    public void setContextManager(ContextManager contextManager) {
        this.contextManager = contextManager;
    }

    @Generated
    public void setEnhancedForProxy(boolean isEnhancedForProxy) {
        this.isEnhancedForProxy = isEnhancedForProxy;
    }
}

