/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.engine.sqlserver.visitor.statement.type;

import java.util.Collections;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.sql.parser.api.ASTNode;
import org.apache.shardingsphere.sql.parser.api.visitor.statement.type.DALStatementVisitor;
import org.apache.shardingsphere.sql.parser.autogen.SQLServerStatementParser;
import org.apache.shardingsphere.sql.parser.engine.sqlserver.visitor.statement.SQLServerStatementVisitor;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dal.VariableAssignSegment;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dal.VariableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dal.ExplainStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dal.SetStatement;

public final class SQLServerDALStatementVisitor
extends SQLServerStatementVisitor
implements DALStatementVisitor {
    public SQLServerDALStatementVisitor(DatabaseType databaseType) {
        super(databaseType);
    }

    @Override
    public ASTNode visitExplain(SQLServerStatementParser.ExplainContext ctx) {
        return new ExplainStatement(this.getDatabaseType(), (SQLStatement)this.visit((ParseTree)ctx.explainableStatement()));
    }

    @Override
    public ASTNode visitSet(SQLServerStatementParser.SetContext ctx) {
        return new SetStatement(this.getDatabaseType(), Collections.singletonList((VariableAssignSegment)this.visit((ParseTree)ctx.setParameter())));
    }

    @Override
    public ASTNode visitSetParameter(SQLServerStatementParser.SetParameterContext ctx) {
        int startIndex = ctx.start.getStartIndex();
        int stopIndex = ctx.stop.getStopIndex();
        if (null != ctx.QUOTED_IDENTIFIER()) {
            VariableSegment variable = new VariableSegment(ctx.QUOTED_IDENTIFIER().getSymbol().getStartIndex(), ctx.QUOTED_IDENTIFIER().getSymbol().getStopIndex(), "QUOTED_IDENTIFIER");
            return new VariableAssignSegment(startIndex, stopIndex, variable, null == ctx.ON() ? "OFF" : "ON");
        }
        VariableSegment variable = new VariableSegment(ctx.TEXTSIZE().getSymbol().getStartIndex(), ctx.TEXTSIZE().getSymbol().getStopIndex(), "TEXTSIZE");
        return new VariableAssignSegment(startIndex, stopIndex, variable, ctx.numberLiterals().getText());
    }

    @Override
    public ASTNode visitExplainableStatement(SQLServerStatementParser.ExplainableStatementContext ctx) {
        if (null != ctx.select()) {
            return (ASTNode)this.visit((ParseTree)ctx.select());
        }
        if (null != ctx.insert()) {
            return (ASTNode)this.visit((ParseTree)ctx.insert());
        }
        if (null != ctx.update()) {
            return (ASTNode)this.visit((ParseTree)ctx.update());
        }
        if (null != ctx.delete()) {
            return (ASTNode)this.visit((ParseTree)ctx.delete());
        }
        return (ASTNode)this.visit((ParseTree)ctx.createTableAsSelectClause());
    }
}

