/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.executor.sql.log;

import java.util.Collection;
import java.util.HashSet;
import lombok.Generated;
import org.apache.shardingsphere.infra.executor.sql.context.ExecutionContext;
import org.apache.shardingsphere.infra.executor.sql.context.ExecutionUnit;
import org.apache.shardingsphere.infra.session.query.QueryContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SQLLogger {
    @Generated
    private static final Logger log = LoggerFactory.getLogger((String)"org.apache.shardingsphere.sql");

    public static void logSQL(QueryContext queryContext, boolean showSimple, ExecutionContext executionContext) {
        SQLLogger.log("Logic SQL: {}", queryContext.getSql());
        if (showSimple) {
            SQLLogger.logSimpleMode(executionContext.getExecutionUnits());
        } else {
            SQLLogger.logNormalMode(executionContext.getExecutionUnits());
        }
    }

    private static void logSimpleMode(Collection<ExecutionUnit> executionUnits) {
        HashSet<String> dataSourceNames = new HashSet<String>(executionUnits.size(), 1.0f);
        for (ExecutionUnit each : executionUnits) {
            dataSourceNames.add(each.getDataSourceName());
        }
        SQLLogger.log("Actual SQL(simple): {} ::: {}", dataSourceNames, executionUnits.size());
    }

    private static void logNormalMode(Collection<ExecutionUnit> executionUnits) {
        for (ExecutionUnit each : executionUnits) {
            if (each.getSqlUnit().getParameters().isEmpty()) {
                SQLLogger.log("Actual SQL: {} ::: {}", each.getDataSourceName(), each.getSqlUnit().getSql());
                continue;
            }
            SQLLogger.log("Actual SQL: {} ::: {} ::: {}", each.getDataSourceName(), each.getSqlUnit().getSql(), each.getSqlUnit().getParameters());
        }
    }

    private static void log(String pattern, Object ... args) {
        log.info(pattern, args);
    }

    @Generated
    private SQLLogger() {
    }
}

