/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster;

import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Properties;
import org.apache.shardingsphere.infra.config.mode.ModeConfiguration;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.instance.ComputeNodeInstance;
import org.apache.shardingsphere.infra.instance.ComputeNodeInstanceContext;
import org.apache.shardingsphere.infra.instance.metadata.jdbc.JDBCInstanceMetaData;
import org.apache.shardingsphere.infra.instance.workerid.WorkerIdGenerator;
import org.apache.shardingsphere.infra.spi.ShardingSphereServiceLoader;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;
import org.apache.shardingsphere.infra.util.eventbus.EventBusContext;
import org.apache.shardingsphere.mode.deliver.DeliverEventSubscriber;
import org.apache.shardingsphere.mode.deliver.DeliverEventSubscriberRegistry;
import org.apache.shardingsphere.mode.exclusive.ExclusiveOperatorContext;
import org.apache.shardingsphere.mode.exclusive.ExclusiveOperatorEngine;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.mode.manager.builder.ContextManagerBuilder;
import org.apache.shardingsphere.mode.manager.builder.ContextManagerBuilderParameter;
import org.apache.shardingsphere.mode.manager.cluster.dispatch.listener.DataChangedEventListenerRegistry;
import org.apache.shardingsphere.mode.manager.cluster.exception.MissingRequiredClusterRepositoryConfigurationException;
import org.apache.shardingsphere.mode.manager.cluster.exclusive.ClusterExclusiveOperatorContext;
import org.apache.shardingsphere.mode.manager.cluster.persist.facade.ClusterPersistServiceFacade;
import org.apache.shardingsphere.mode.manager.cluster.workerid.ClusterWorkerIdGenerator;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.mode.metadata.factory.MetaDataContextsFactory;
import org.apache.shardingsphere.mode.metadata.persist.MetaDataPersistFacade;
import org.apache.shardingsphere.mode.repository.cluster.ClusterPersistRepository;
import org.apache.shardingsphere.mode.repository.cluster.ClusterPersistRepositoryConfiguration;
import org.apache.shardingsphere.mode.spi.repository.PersistRepository;

public final class ClusterContextManagerBuilder
implements ContextManagerBuilder {
    public ContextManager build(ContextManagerBuilderParameter param, EventBusContext eventBusContext) throws SQLException {
        ModeConfiguration modeConfig = param.getModeConfiguration();
        ClusterPersistRepositoryConfiguration config = (ClusterPersistRepositoryConfiguration)modeConfig.getRepository();
        ComputeNodeInstanceContext computeNodeInstanceContext = new ComputeNodeInstanceContext(new ComputeNodeInstance(param.getInstanceMetaData(), param.getLabels()), modeConfig, eventBusContext);
        ClusterPersistRepository repository = this.getClusterPersistRepository(config, computeNodeInstanceContext);
        computeNodeInstanceContext.init((WorkerIdGenerator)new ClusterWorkerIdGenerator(repository, param.getInstanceMetaData().getId()));
        ExclusiveOperatorEngine exclusiveOperatorEngine = new ExclusiveOperatorEngine((ExclusiveOperatorContext)new ClusterExclusiveOperatorContext(repository));
        MetaDataContexts metaDataContexts = new MetaDataContextsFactory(new MetaDataPersistFacade((PersistRepository)repository), computeNodeInstanceContext).create(param);
        ContextManager result = new ContextManager(metaDataContexts, computeNodeInstanceContext, exclusiveOperatorEngine, (PersistRepository)repository);
        this.registerOnline(computeNodeInstanceContext, param, result);
        new DeliverEventSubscriberRegistry(result.getComputeNodeInstanceContext().getEventBusContext()).register(this.createDeliverEventSubscribers((PersistRepository)repository));
        return result;
    }

    private ClusterPersistRepository getClusterPersistRepository(ClusterPersistRepositoryConfiguration config, ComputeNodeInstanceContext computeNodeInstanceContext) {
        ShardingSpherePreconditions.checkNotNull((Object)config, MissingRequiredClusterRepositoryConfigurationException::new);
        ClusterPersistRepository result = (ClusterPersistRepository)TypedSPILoader.getService(ClusterPersistRepository.class, (Object)config.getType(), (Properties)config.getProps());
        result.init(config, computeNodeInstanceContext);
        return result;
    }

    private void registerOnline(ComputeNodeInstanceContext computeNodeInstanceContext, ContextManagerBuilderParameter param, ContextManager contextManager) {
        ClusterPersistServiceFacade clusterPersistServiceFacade = (ClusterPersistServiceFacade)contextManager.getPersistServiceFacade().getModeFacade();
        clusterPersistServiceFacade.getComputeNodeService().registerOnline(computeNodeInstanceContext.getInstance());
        contextManager.getComputeNodeInstanceContext().getClusterInstanceRegistry().getAllClusterInstances().addAll(clusterPersistServiceFacade.getComputeNodeService().loadAllInstances());
        new DataChangedEventListenerRegistry(contextManager, this.getDatabaseNames(param, contextManager.getPersistServiceFacade().getMetaDataFacade())).register();
    }

    private Collection<String> getDatabaseNames(ContextManagerBuilderParameter param, MetaDataPersistFacade metaDataPersistFacade) {
        return param.getInstanceMetaData() instanceof JDBCInstanceMetaData ? param.getDatabaseConfigs().keySet() : metaDataPersistFacade.getDatabaseMetaDataFacade().getDatabase().loadAllDatabaseNames();
    }

    private Collection<DeliverEventSubscriber> createDeliverEventSubscribers(PersistRepository repository) {
        LinkedList<DeliverEventSubscriber> result = new LinkedList<DeliverEventSubscriber>();
        for (DeliverEventSubscriber each : ShardingSphereServiceLoader.getServiceInstances(DeliverEventSubscriber.class)) {
            each.setRepository(repository);
            result.add(each);
        }
        return result;
    }

    public String getType() {
        return "Cluster";
    }
}

