/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.core.exception.param.PipelineInvalidParameterException;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.rule.attribute.datanode.DataNodeRuleAttribute;

public final class PipelineDataNodeUtils {
    public static Map<String, List<DataNode>> buildTableAndDataNodesMap(ShardingSphereDatabase database, Collection<String> tableNames) {
        ShardingSpherePreconditions.checkNotEmpty(tableNames, () -> new PipelineInvalidParameterException("Table names are empty."));
        HashMap<String, List<DataNode>> result = new HashMap<String, List<DataNode>>(tableNames.size(), 1.0f);
        Collection attributes = database.getRuleMetaData().getAttributes(DataNodeRuleAttribute.class);
        for (String each : tableNames) {
            Collection<DataNode> dataNodes = PipelineDataNodeUtils.findDataNodes(each, attributes);
            ShardingSpherePreconditions.checkNotEmpty(dataNodes, () -> new PipelineInvalidParameterException(String.format("Not find actual data nodes of `%s`", each)));
            result.put(each, new ArrayList<DataNode>(dataNodes));
        }
        return result;
    }

    private static Collection<DataNode> findDataNodes(String tableName, Collection<DataNodeRuleAttribute> attributes) {
        for (DataNodeRuleAttribute each : attributes) {
            Set<DataNode> dataNodes = each.getDataNodesByTableName(tableName);
            if (dataNodes.isEmpty()) continue;
            return each.isReplicaBasedDistribution() ? Collections.singleton((DataNode)dataNodes.iterator().next()) : dataNodes;
        }
        return Collections.emptyList();
    }

    @Generated
    private PipelineDataNodeUtils() {
    }
}

