/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.sqlbuilder.sql;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.inventory.query.Range;
import org.apache.shardingsphere.data.pipeline.core.sqlbuilder.dialect.DialectPipelineSQLBuilder;
import org.apache.shardingsphere.data.pipeline.core.sqlbuilder.segment.PipelineSQLSegmentBuilder;
import org.apache.shardingsphere.database.connector.core.spi.DatabaseTypedSPILoader;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.infra.metadata.database.schema.QualifiedTable;

public final class PipelineInventoryCalculateSQLBuilder {
    private final DialectPipelineSQLBuilder dialectSQLBuilder;
    private final PipelineSQLSegmentBuilder sqlSegmentBuilder;

    public PipelineInventoryCalculateSQLBuilder(DatabaseType databaseType) {
        this.dialectSQLBuilder = (DialectPipelineSQLBuilder)DatabaseTypedSPILoader.getService(DialectPipelineSQLBuilder.class, (DatabaseType)databaseType);
        this.sqlSegmentBuilder = new PipelineSQLSegmentBuilder(databaseType);
    }

    public String buildRangeQueryOrderingSQL(QualifiedTable qualifiedTable, Collection<String> columnNames, List<String> uniqueKeys, Range<?> range, boolean pageQuery, List<String> shardingColumnsNames) {
        String result = this.buildRangeQueryOrderingSQL0(qualifiedTable, columnNames, uniqueKeys, range, shardingColumnsNames);
        return pageQuery ? this.dialectSQLBuilder.wrapWithPageQuery(result) : result;
    }

    private String buildRangeQueryOrderingSQL0(QualifiedTable qualifiedTable, Collection<String> columnNames, List<String> uniqueKeys, Range<?> range, List<String> shardingColumnsNames) {
        String qualifiedTableName = this.sqlSegmentBuilder.getQualifiedTableName(qualifiedTable);
        String queryColumns = columnNames.stream().map(this.sqlSegmentBuilder::getEscapedIdentifier).collect(Collectors.joining(","));
        String firstUniqueKey = uniqueKeys.get(0);
        String orderByColumns = this.joinColumns(uniqueKeys, shardingColumnsNames).stream().map(each -> this.sqlSegmentBuilder.getEscapedIdentifier((String)each) + " ASC").collect(Collectors.joining(", "));
        if (null != range.getLowerBound() && null != range.getUpperBound()) {
            return String.format("SELECT %s FROM %s WHERE %s AND %s ORDER BY %s", queryColumns, qualifiedTableName, this.buildRangeQueryLowerCondition(range.isLowerInclusive(), firstUniqueKey), this.buildRangeQueryUpperCondition(firstUniqueKey), orderByColumns);
        }
        if (null != range.getLowerBound()) {
            return String.format("SELECT %s FROM %s WHERE %s ORDER BY %s", queryColumns, qualifiedTableName, this.buildRangeQueryLowerCondition(range.isLowerInclusive(), firstUniqueKey), orderByColumns);
        }
        if (null != range.getUpperBound()) {
            return String.format("SELECT %s FROM %s WHERE %s ORDER BY %s", queryColumns, qualifiedTableName, this.buildRangeQueryUpperCondition(firstUniqueKey), orderByColumns);
        }
        return String.format("SELECT %s FROM %s ORDER BY %s", queryColumns, qualifiedTableName, orderByColumns);
    }

    private String buildRangeQueryLowerCondition(boolean inclusive, String firstUniqueKey) {
        String delimiter = inclusive ? ">=?" : ">?";
        return this.sqlSegmentBuilder.getEscapedIdentifier(firstUniqueKey) + delimiter;
    }

    private String buildRangeQueryUpperCondition(String firstUniqueKey) {
        return this.sqlSegmentBuilder.getEscapedIdentifier(firstUniqueKey) + "<=?";
    }

    public String buildPointQuerySQL(QualifiedTable qualifiedTable, Collection<String> columnNames, List<String> uniqueKeys, List<String> shardingColumnsNames) {
        String qualifiedTableName = this.sqlSegmentBuilder.getQualifiedTableName(qualifiedTable);
        String queryColumns = columnNames.stream().map(this.sqlSegmentBuilder::getEscapedIdentifier).collect(Collectors.joining(","));
        String equalsConditions = this.joinColumns(uniqueKeys, shardingColumnsNames).stream().map(each -> this.sqlSegmentBuilder.getEscapedIdentifier((String)each) + "=?").collect(Collectors.joining(" AND "));
        return String.format("SELECT %s FROM %s WHERE %s", queryColumns, qualifiedTableName, equalsConditions);
    }

    private List<String> joinColumns(List<String> uniqueKeys, List<String> shardingColumnsNames) {
        if (shardingColumnsNames.isEmpty()) {
            return uniqueKeys;
        }
        ArrayList<String> result = new ArrayList<String>(uniqueKeys.size() + shardingColumnsNames.size());
        result.addAll(uniqueKeys);
        result.addAll(shardingColumnsNames);
        return result;
    }
}

