/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.metadata.node.event.handler.impl;

import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.core.job.id.PipelineJobIdUtils;
import org.apache.shardingsphere.data.pipeline.core.metadata.node.PipelineMetaDataNode;
import org.apache.shardingsphere.data.pipeline.core.metadata.node.config.processor.JobConfigurationChangedProcessEngine;
import org.apache.shardingsphere.data.pipeline.core.metadata.node.config.processor.JobConfigurationChangedProcessor;
import org.apache.shardingsphere.data.pipeline.core.metadata.node.event.handler.PipelineMetaDataChangedEventHandler;
import org.apache.shardingsphere.elasticjob.api.JobConfiguration;
import org.apache.shardingsphere.elasticjob.infra.pojo.JobConfigurationPOJO;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.mode.event.DataChangedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfigMetaDataChangedEventHandler
implements PipelineMetaDataChangedEventHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConfigMetaDataChangedEventHandler.class);

    @Override
    public Pattern getKeyPattern() {
        return PipelineMetaDataNode.CONFIG_PATTERN;
    }

    @Override
    public void handle(String jobId, DataChangedEvent event) {
        JobConfiguration jobConfig;
        try {
            jobConfig = ((JobConfigurationPOJO)YamlEngine.unmarshal((String)event.getValue(), JobConfigurationPOJO.class, (boolean)true)).toJobConfiguration();
        }
        catch (RuntimeException ex) {
            log.error("unmarshal job configuration pojo failed.", (Throwable)ex);
            return;
        }
        log.info("{} job configuration: {}, disabled={}", new Object[]{event.getType(), event.getKey(), jobConfig.isDisabled()});
        String jobType = PipelineJobIdUtils.parseJobType(jobConfig.getJobName()).getType();
        TypedSPILoader.findService(JobConfigurationChangedProcessor.class, (Object)jobType).ifPresent(optional -> new JobConfigurationChangedProcessEngine().process(event.getType(), jobConfig, optional));
    }
}

