/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.consistencycheck;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicLong;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.core.consistencycheck.position.TableCheckRangePosition;
import org.apache.shardingsphere.data.pipeline.core.job.progress.listener.PipelineJobProgressListener;
import org.apache.shardingsphere.data.pipeline.core.job.progress.listener.PipelineJobUpdateProgress;
import org.apache.shardingsphere.data.pipeline.core.job.progress.persist.PipelineJobProgressPersistService;

public final class ConsistencyCheckJobItemProgressContext
implements PipelineJobProgressListener {
    private final String jobId;
    private final int shardingItem;
    private final Collection<String> tableNames = new CopyOnWriteArraySet<String>();
    private final Collection<String> ignoredTableNames = new CopyOnWriteArraySet<String>();
    private volatile long recordsCount;
    private final AtomicLong checkedRecordsCount = new AtomicLong(0L);
    private final long checkBeginTimeMillis = System.currentTimeMillis();
    private volatile Long checkEndTimeMillis;
    private final List<TableCheckRangePosition> tableCheckRangePositions = new ArrayList<TableCheckRangePosition>();
    private final String sourceDatabaseType;

    @Override
    public void onProgressUpdated(PipelineJobUpdateProgress updateProgress) {
        this.checkedRecordsCount.addAndGet(updateProgress.getProcessedRecordsCount());
        PipelineJobProgressPersistService.notifyPersist(this.jobId, this.shardingItem);
    }

    @Generated
    public ConsistencyCheckJobItemProgressContext(String jobId, int shardingItem, String sourceDatabaseType) {
        this.jobId = jobId;
        this.shardingItem = shardingItem;
        this.sourceDatabaseType = sourceDatabaseType;
    }

    @Generated
    public String getJobId() {
        return this.jobId;
    }

    @Generated
    public int getShardingItem() {
        return this.shardingItem;
    }

    @Generated
    public Collection<String> getTableNames() {
        return this.tableNames;
    }

    @Generated
    public Collection<String> getIgnoredTableNames() {
        return this.ignoredTableNames;
    }

    @Generated
    public long getRecordsCount() {
        return this.recordsCount;
    }

    @Generated
    public AtomicLong getCheckedRecordsCount() {
        return this.checkedRecordsCount;
    }

    @Generated
    public long getCheckBeginTimeMillis() {
        return this.checkBeginTimeMillis;
    }

    @Generated
    public Long getCheckEndTimeMillis() {
        return this.checkEndTimeMillis;
    }

    @Generated
    public List<TableCheckRangePosition> getTableCheckRangePositions() {
        return this.tableCheckRangePositions;
    }

    @Generated
    public String getSourceDatabaseType() {
        return this.sourceDatabaseType;
    }

    @Generated
    public void setRecordsCount(long recordsCount) {
        this.recordsCount = recordsCount;
    }

    @Generated
    public void setCheckEndTimeMillis(Long checkEndTimeMillis) {
        this.checkEndTimeMillis = checkEndTimeMillis;
    }
}

