/*
 * Decompiled with CFR 0.152.
 */
package org.twak.camp;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.twak.camp.Corner;
import org.twak.camp.Machine;
import org.twak.camp.Tag;
import org.twak.camp.ui.Bar;
import org.twak.utils.Cache;
import org.twak.utils.Line;
import org.twak.utils.Pair;
import org.twak.utils.collections.ConsecutivePairs;
import org.twak.utils.collections.Loop;
import org.twak.utils.collections.LoopL;
import org.twak.utils.collections.Loopable;
import org.twak.utils.geom.Line3d;
import org.twak.utils.geom.LinearForm3D;
import org.twak.utils.geom.Ray3d;

public class Edge {
    private static final double COLLINEAR_THRESHOLD = 0.01;
    private static final double COS_THRESHOLD = Math.cos(1.0E-4);
    public Corner start;
    public Corner end;
    private double angle = 0.7853981633974483;
    public Vector3d uphill;
    public LinearForm3D linearForm;
    public List<Corner> currentCorners = new ArrayList<Corner>();
    public Machine machine;
    public Set<Tag> profileFeatures = new LinkedHashSet<Tag>();

    public Edge(Corner start, Corner end, double angle) {
        this(start, end);
        this.angle = angle;
        this.calculateLinearForm();
    }

    public Edge(Corner start, Corner end) {
        this.start = start;
        this.end = end;
    }

    public Edge(Point3d start, Point3d end, double angle) {
        this(new Corner((Tuple3d)start), new Corner((Tuple3d)end), angle);
    }

    private void calculateUphill() {
        double dx = this.end.x - this.start.x;
        double dy = this.end.y - this.start.y;
        double normInv = 1.0 / Math.sqrt(dx * dx + dy * dy);
        double sinA = Math.sin(this.angle);
        double cosA = Math.cos(this.angle);
        this.uphill = new Vector3d(-dy * sinA * normInv, dx * sinA * normInv, cosA);
    }

    public double[] getBBox() {
        double minX = Math.min(this.start.x, this.end.x);
        double minY = Math.min(this.start.y, this.end.y);
        double maxX = Math.max(this.start.x, this.end.x);
        double maxY = Math.max(this.start.y, this.end.y);
        return new double[]{minX, minY, maxX, maxY};
    }

    public void calculateLinearForm() {
        this.calculateUphill();
        Vector3d norm = this.getPlaneNormal();
        this.linearForm = new LinearForm3D(norm, new Vector3d(this.start.x, this.start.y, this.start.z));
    }

    public Vector3d getPlaneNormal() {
        Vector3d a = this.direction();
        a.normalize();
        a.cross(a, this.uphill);
        return a;
    }

    public double length() {
        return this.start.distance(this.end);
    }

    public Vector3d direction() {
        return new Vector3d(this.end.x - this.start.x, this.end.y - this.start.y, 0.0);
    }

    public Line projectDown() {
        return new Line(this.start.x, this.start.y, this.end.x, this.end.y);
    }

    public String toString() {
        return "[" + String.valueOf(this.start) + "," + String.valueOf(this.end) + "]";
    }

    public double distance(Point3d ept) {
        Vector3d e = new Vector3d(this.end);
        e.sub(this.start);
        Point3d p = new Ray3d(this.start, e).projectSegment(ept);
        if (p == null) {
            return Double.MAX_VALUE;
        }
        return p.distance(ept);
    }

    public boolean isCollisionNearHoriz(Edge other) {
        Ray3d r = this.collide(other.linearForm);
        if (r == null) {
            return false;
        }
        return Math.abs(r.direction.z) < 0.001;
    }

    private Ray3d collide(LinearForm3D other) {
        double n1y = this.linearForm.B;
        double n2z = other.C;
        double n1z = this.linearForm.C;
        double n2y = other.B;
        double rx = n1y * n2z - n1z * n2y;
        double n2x = other.A;
        double n1x = this.linearForm.A;
        double ry = n1z * n2x - n1x * n2z;
        double rz = n1x * n2y - n1y * n2x;
        double rnormSq = rx * rx + ry * ry + rz * rz;
        if (rnormSq == 0.0) {
            return null;
        }
        double d1 = -this.linearForm.D;
        double d2 = -other.D;
        double wx = d1 * n2x - d2 * n1x;
        double wy = d1 * n2y - d2 * n1y;
        double wz = d1 * n2z - d2 * n1z;
        double px = wy * rz - wz * ry;
        double py = wz * rx - wx * rz;
        double pz = wx * ry - wy * rx;
        double invRnormSq = 1.0 / rnormSq;
        Point3d point = new Point3d(px *= invRnormSq, py *= invRnormSq, pz *= invRnormSq);
        Vector3d direction = new Vector3d(rx, ry, rz);
        return new Ray3d(point, direction);
    }

    public boolean isParallel(Edge other) {
        return Edge.isAligned(this.uphill, other.uphill) && Edge.isAligned(this.direction(), other.direction());
    }

    private static boolean isAligned(Vector3d v1, Vector3d v2) {
        double threshold;
        double lenSq1 = v1.lengthSquared();
        double lenSq2 = v2.lengthSquared();
        if (lenSq1 == 0.0 || lenSq2 == 0.0) {
            return false;
        }
        double dotProduct = v1.dot(v2);
        double squaredDot = dotProduct * dotProduct;
        return squaredDot >= (threshold = COS_THRESHOLD * COS_THRESHOLD * lenSq1 * lenSq2);
    }

    public boolean sameDirectedLine(Edge nextL) {
        return nextL.direction().angle(this.direction()) < 0.01 && Math.abs(this.getAngle() - nextL.getAngle()) < 0.01;
    }

    public static void reverse(LoopL<Edge> loopl) {
        for (Edge edge : loopl.eIterator()) {
            Corner tmp = edge.start;
            edge.start = edge.end;
            edge.end = tmp;
            tmp = edge.start.nextC;
            edge.start.nextC = edge.start.prevC;
            edge.start.prevC = tmp;
            Edge et = edge.start.nextL;
            edge.start.nextL = edge.start.prevL;
            edge.start.prevL = et;
        }
        for (Loop loop : loopl) {
            loop.reverse();
        }
    }

    public int hashCode() {
        return super.hashCode();
    }

    public static Loop<Edge> fromPoints(List<Point2d> ribbon) {
        Loop<Edge> loop = new Loop<Edge>();
        Cache<Point2d, Corner> cache = new Cache<Point2d, Corner>(){

            @Override
            public Corner create(Point2d i) {
                return new Corner(i.x, i.y);
            }
        };
        for (Pair<Point2d, Point2d> pair : new ConsecutivePairs<Point2d>(ribbon, true)) {
            loop.append((Edge[])new Edge[]{new Edge((Corner)cache.get(pair.first()), (Corner)cache.get(pair.second()))});
        }
        return loop;
    }

    public static LoopL<Edge> fromPoints2d(LoopL<Point2d> ribbon) {
        LoopL<Edge> loopl = new LoopL<Edge>();
        Cache<Point2d, Corner> cache = new Cache<Point2d, Corner>(){

            @Override
            public Corner create(Point2d i) {
                return new Corner(i.x, i.y);
            }
        };
        for (Loop loop : ribbon) {
            Loop<Edge> loop2 = new Loop<Edge>();
            loopl.add((Edge)((Object)loop2));
            for (Loopable pair : loop.loopableIterator()) {
                loop2.append(new Edge((Corner)cache.get((Point2d)pair.get()), (Corner)cache.get((Point2d)pair.getNext().get())));
            }
        }
        return loopl;
    }

    public static LoopL<Edge> dupe(LoopL<Edge> ribbon) {
        LoopL<Edge> loopl = new LoopL<Edge>();
        Cache<Corner, Corner> cache = new Cache<Corner, Corner>(){

            @Override
            public Corner create(Corner i) {
                return new Corner(i.x, i.y);
            }
        };
        for (Loop loop : ribbon) {
            Loop<Edge> loop2 = new Loop<Edge>();
            loopl.add((Edge)((Object)loop2));
            for (Edge bar : loop) {
                loop2.append(new Edge((Corner)cache.get(bar.start), (Corner)cache.get(bar.end)));
            }
        }
        return loopl;
    }

    public static LoopL<Edge> fromBar(LoopL<Bar> ribbon) {
        LoopL<Edge> loopl = new LoopL<Edge>();
        Cache<Point2d, Corner> cache = new Cache<Point2d, Corner>(){

            @Override
            public Corner create(Point2d i) {
                return new Corner(i.x, i.y);
            }
        };
        for (Loop loop : ribbon) {
            Loop<Edge> loop2 = new Loop<Edge>();
            loopl.add((Edge)((Object)loop2));
            for (Bar bar : loop) {
                loop2.append(new Edge((Corner)cache.get(bar.start), (Corner)cache.get(bar.end)));
            }
        }
        return loopl;
    }

    public double getAngle() {
        return this.angle;
    }

    public void setAngle(double angle) {
        this.angle = angle;
        this.calculateLinearForm();
    }

    public static Iterable<Edge> uniqueEdges(LoopL<Corner> corners) {
        HashSet<Edge> cs = new HashSet<Edge>();
        for (Corner c : corners.eIterator()) {
            cs.add(c.nextL);
        }
        return cs;
    }

    public static Tuple3d collide(Corner a, double height) {
        LinearForm3D ceiling = new LinearForm3D(0.0, 0.0, 1.0, -height);
        try {
            return ceiling.collide(a.prevL.linearForm, a.nextL.linearForm);
        }
        catch (RuntimeException e) {
            assert (a.prevL.sameDirectedLine(a.nextL));
            Vector3d dir = new Vector3d(a.prevL.uphill);
            dir.normalize();
            dir.scale(height - a.z);
            dir.add(a);
            return new Point3d(dir.x, dir.y, height);
        }
    }

    static Tuple3d collide(Corner a, Edge edge) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public Set<Corner> findLeadingCorners() {
        HashSet<Corner> out = new HashSet<Corner>();
        for (Corner c : this.currentCorners) {
            if (c.nextL != this) continue;
            out.add(c);
        }
        return out;
    }

    public Line3d line() {
        return new Line3d(this.start, this.end);
    }
}

