/*
 * Decompiled with CFR 0.152.
 */
package org.tinspin.index;

import java.util.function.Predicate;
import org.tinspin.index.BoxDistance;
import org.tinspin.index.Index;
import org.tinspin.index.array.RectArray;
import org.tinspin.index.qthypercube.QuadTreeRKD;
import org.tinspin.index.qtplain.QuadTreeRKD0;
import org.tinspin.index.rtree.RTree;
import org.tinspin.index.rtree.RTreeEntry;

public interface BoxMultimap<T>
extends Index {
    public void insert(double[] var1, double[] var2, T var3);

    public boolean remove(double[] var1, double[] var2, T var3);

    public boolean removeIf(double[] var1, double[] var2, Predicate<Index.BoxEntry<T>> var3);

    public boolean update(double[] var1, double[] var2, double[] var3, double[] var4, T var5);

    public boolean contains(double[] var1, double[] var2, T var3);

    public Index.BoxIterator<T> queryExactBox(double[] var1, double[] var2);

    public Index.BoxIterator<T> iterator();

    public Index.BoxIterator<T> queryIntersect(double[] var1, double[] var2);

    default public Index.BoxEntryKnn<T> query1nn(double[] center) {
        Index.BoxIteratorKnn<T> it = this.queryKnn(center, 1);
        return it.hasNext() ? (Index.BoxEntryKnn)it.next() : null;
    }

    public Index.BoxIteratorKnn<T> queryKnn(double[] var1, int var2);

    public Index.BoxIteratorKnn<T> queryKnn(double[] var1, int var2, BoxDistance var3);

    public static interface Factory {
        public static <T> BoxMultimap<T> createArray(int dims, int size) {
            return new RectArray(dims, size);
        }

        public static <T> BoxMultimap<T> createQuadtree(int dims) {
            return QuadTreeRKD0.create(dims);
        }

        public static <T> BoxMultimap<T> createQuadtree(int dims, int maxNodeCapacity, double[] min2, double[] max) {
            return QuadTreeRKD0.create(dims, maxNodeCapacity, min2, max);
        }

        public static <T> BoxMultimap<T> createQuadtreeHC(int dims) {
            return QuadTreeRKD.create(dims);
        }

        public static <T> BoxMultimap<T> createQuadtreeHC(int dims, int maxNodeCapacity, double[] min2, double[] max) {
            return QuadTreeRKD.create(dims, maxNodeCapacity, min2, max);
        }

        public static <T> BoxMultimap<T> createRStarTree(int dims) {
            return RTree.createRStar(dims);
        }

        public static <T> BoxMultimap<T> createAndLoadStrRTree(int dims, RTreeEntry<T>[] entries) {
            RTree<T> tree = RTree.createRStar(dims);
            tree.load(entries);
            return tree;
        }
    }
}

