/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.sedona_sql.strategy.join;

import org.apache.sedona.common.FunctionsGeoTools;
import org.apache.sedona.common.utils.CachedCRSTransformFinder;
import org.apache.sedona.common.utils.GeomUtils;
import org.geotools.api.geometry.BoundingBox;
import org.geotools.api.geometry.Bounds;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.crs.GeographicCRS;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.geometry.GeneralBounds;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultEngineeringCRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Polygon;

public final class JoinedGeometryRaster$ {
    public static final JoinedGeometryRaster$ MODULE$ = new JoinedGeometryRaster$();

    public Geometry rasterToWGS84Envelope(GridCoverage2D raster) {
        CoordinateReferenceSystem crs = raster.getCoordinateReferenceSystem();
        ReferencedEnvelope envelope = raster.getEnvelope2D();
        if (crs == null || crs instanceof DefaultEngineeringCRS) {
            return JTS.toGeometry((BoundingBox)envelope);
        }
        return this.transformToWGS84Envelope(envelope, crs);
    }

    public Geometry geometryToWGS84Envelope(Geometry geom) {
        int srid = geom.getSRID();
        if (srid <= 0 || srid == 4326) {
            return geom;
        }
        Envelope env = geom.getEnvelopeInternal();
        CoordinateReferenceSystem crs = FunctionsGeoTools.sridToCRS((int)srid);
        ReferencedEnvelope envelope = new ReferencedEnvelope(env.getMinX(), env.getMaxX(), env.getMinY(), env.getMaxY(), null);
        return this.transformToWGS84Envelope(envelope, crs);
    }

    private Geometry transformToWGS84Envelope(ReferencedEnvelope envelope, CoordinateReferenceSystem crs) {
        MathTransform transform = CachedCRSTransformFinder.findTransform((CoordinateReferenceSystem)crs, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        GeneralBounds transformedEnvelope = CRS.transform((MathTransform)transform, (Bounds)envelope);
        double minX = transformedEnvelope.getMinimum(0);
        double maxX = transformedEnvelope.getMaximum(0);
        double minY = transformedEnvelope.getMinimum(1);
        double maxY = transformedEnvelope.getMaximum(1);
        Envelope jtsEnvelope = new Envelope(minX, maxX, minY, maxY);
        jtsEnvelope.expandBy(jtsEnvelope.getWidth() * 0.1, jtsEnvelope.getHeight() * 0.1);
        Polygon geom = JTS.toGeometry((Envelope)jtsEnvelope);
        if (crs instanceof GeographicCRS) {
            return geom;
        }
        return GeomUtils.antiMeridianSafeGeom((Geometry)geom);
    }

    private JoinedGeometryRaster$() {
    }
}

