/*
 * Decompiled with CFR 0.152.
 */
package org.twak.utils.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.twak.utils.Mathz;
import org.twak.utils.collections.Arrayz;

public class ListEditor<E>
extends JPanel {
    public List<E> list = new ArrayList();
    public boolean fireSelection = true;
    private JButton add;
    private JButton down;
    private JList jList;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JButton remove;
    private JButton up;

    public ListEditor() {
        this.initComponents();
        this.setEnabled(false);
    }

    public ListEditor(List<E> list) {
        this.initComponents();
        this.setEnabled(false);
        this.list = list;
        this.initComponents();
        this.init();
        this.jList.setSelectionMode(0);
    }

    public void init() {
        Object[] vals = this.jList.getSelectedValues();
        DefaultListModel<E> dlm = new DefaultListModel<E>();
        if (this.list != null) {
            for (E l : this.list) {
                dlm.addElement(l);
            }
        }
        this.fireSelection = false;
        this.jList.setModel(dlm);
        for (Object o : vals) {
            this.jList.setSelectedValue(o, true);
        }
        this.fireSelection = true;
    }

    public void selected(E e) {
    }

    public void add(MouseEvent evt, List<E> list) {
    }

    public void changed(List<E> list) {
    }

    public void rightClick(E e, MouseEvent evt, List<E> list) {
    }

    public void doubleClick(E e, List<E> list) {
    }

    private void moveSelected(E o, int i) {
        if (o != null) {
            int index = this.list.indexOf(o);
            this.list.remove(o);
            this.list.add(Mathz.clamp(index + i, 0, this.list.size()), o);
        }
        this.fireSelection = false;
        this.jList.setSelectedValue(o, true);
        this.fireSelection = true;
        this.init();
        this.changed(this.list);
    }

    public void setSelected(E e) {
        if (this.jList.getSelectedValue() == e) {
            return;
        }
        this.jList.setSelectedValue(e, true);
    }

    public void setList(List<E> nList) {
        if (this.list == nList) {
            return;
        }
        this.setEnabled(nList != null);
        if (nList == null) {
            nList = new ArrayList();
        }
        this.list = nList;
        this.init();
    }

    @Override
    public void setEnabled(boolean enabled) {
        for (Component c : this.jPanel1.getComponents()) {
            c.setEnabled(enabled);
        }
    }

    public E getSelected() {
        return this.jList.getSelectedValue();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jList = new JList();
        this.jPanel1 = new JPanel();
        this.add = new JButton();
        this.remove = new JButton();
        this.up = new JButton();
        this.down = new JButton();
        this.setLayout(new BorderLayout());
        this.jList.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ListEditor.this.jListMouseClicked(evt);
            }
        });
        this.jList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                ListEditor.this.jListValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jList);
        this.add((Component)this.jScrollPane1, "Center");
        this.jPanel1.setLayout(new GridLayout(0, 1));
        this.add.setText("+");
        this.add.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ListEditor.this.addMouseClicked(evt);
            }
        });
        this.jPanel1.add(this.add);
        this.remove.setText("-");
        this.remove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ListEditor.this.removeActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.remove);
        this.up.setText("^");
        this.up.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ListEditor.this.upActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.up);
        this.down.setText("V");
        this.down.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ListEditor.this.downActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.down);
        this.add((Component)this.jPanel1, "East");
    }

    private void jListValueChanged(ListSelectionEvent evt) {
        if (this.fireSelection && !evt.getValueIsAdjusting()) {
            this.selected(this.jList.getSelectedValue());
        }
    }

    private void addMouseClicked(MouseEvent evt) {
        Object[] original = this.jList.getSelectedValues();
        this.add(evt, this.list);
        List<Object> neu = Arrayz.newElements(original, this.jList.getSelectedValues());
        this.changed(this.list);
        this.init();
        if (!neu.isEmpty()) {
            this.jList.setSelectedValue(neu.get(0), true);
        }
    }

    private void removeActionPerformed(ActionEvent evt) {
        int index = this.jList.getSelectedIndex();
        for (Object o : this.jList.getSelectedValues()) {
            this.list.remove(o);
        }
        this.changed(this.list);
        this.init();
        this.jList.setSelectedIndex(Math.min(this.list.size() - 1, index));
    }

    private void upActionPerformed(ActionEvent evt) {
        for (Object o : this.jList.getSelectedValues()) {
            this.moveSelected(o, -1);
        }
    }

    private void downActionPerformed(ActionEvent evt) {
        for (Object o : Arrayz.reverse(this.jList.getSelectedValues())) {
            this.moveSelected(o, 1);
        }
    }

    private void jListMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            this.doubleClick(this.jList.getSelectedValue(), this.list);
            this.init();
        } else if (evt.getButton() == 3) {
            this.rightClick(this.jList.getSelectedValue(), evt, this.list);
            this.init();
        }
    }
}

