/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.geom.Rectangle2D;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.batik.bridge.AbstractSVGFilterPrimitiveElementBridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.ext.awt.image.renderable.Filter;
import org.apache.batik.ext.awt.image.renderable.TurbulenceRable8Bit;
import org.apache.batik.gvt.GraphicsNode;
import org.w3c.dom.Element;

public class SVGFeTurbulenceElementBridge
extends AbstractSVGFilterPrimitiveElementBridge {
    @Override
    public String getLocalName() {
        return "feTurbulence";
    }

    @Override
    public Filter createFilter(BridgeContext ctx, Element filterElement, Element filteredElement, GraphicsNode filteredNode, Filter inputFilter, Rectangle2D filterRegion, Map filterMap) {
        Filter in = SVGFeTurbulenceElementBridge.getIn(filterElement, filteredElement, filteredNode, inputFilter, filterMap, ctx);
        if (in == null) {
            return null;
        }
        Rectangle2D defaultRegion = filterRegion;
        Rectangle2D primitiveRegion = SVGUtilities.convertFilterPrimitiveRegion(filterElement, filteredElement, filteredNode, defaultRegion, filterRegion, ctx);
        float[] baseFrequency = SVGFeTurbulenceElementBridge.convertBaseFrenquency(filterElement, ctx);
        int numOctaves = SVGFeTurbulenceElementBridge.convertInteger(filterElement, "numOctaves", 1, ctx);
        int seed = SVGFeTurbulenceElementBridge.convertInteger(filterElement, "seed", 0, ctx);
        boolean stitchTiles = SVGFeTurbulenceElementBridge.convertStitchTiles(filterElement, ctx);
        boolean isFractalNoise = SVGFeTurbulenceElementBridge.convertType(filterElement, ctx);
        TurbulenceRable8Bit turbulenceRable = new TurbulenceRable8Bit(primitiveRegion);
        turbulenceRable.setBaseFrequencyX(baseFrequency[0]);
        turbulenceRable.setBaseFrequencyY(baseFrequency[1]);
        turbulenceRable.setNumOctaves(numOctaves);
        turbulenceRable.setSeed(seed);
        turbulenceRable.setStitched(stitchTiles);
        turbulenceRable.setFractalNoise(isFractalNoise);
        SVGFeTurbulenceElementBridge.handleColorInterpolationFilters(turbulenceRable, filterElement);
        SVGFeTurbulenceElementBridge.updateFilterMap(filterElement, turbulenceRable, filterMap);
        return turbulenceRable;
    }

    protected static float[] convertBaseFrenquency(Element e, BridgeContext ctx) {
        String s2 = e.getAttributeNS(null, "baseFrequency");
        if (s2.length() == 0) {
            return new float[]{0.001f, 0.001f};
        }
        float[] v = new float[2];
        StringTokenizer tokens = new StringTokenizer(s2, " ,");
        try {
            v[0] = SVGUtilities.convertSVGNumber(tokens.nextToken());
            v[1] = tokens.hasMoreTokens() ? SVGUtilities.convertSVGNumber(tokens.nextToken()) : v[0];
            if (tokens.hasMoreTokens()) {
                throw new BridgeException(ctx, e, "attribute.malformed", new Object[]{"baseFrequency", s2});
            }
        }
        catch (NumberFormatException nfEx) {
            throw new BridgeException(ctx, e, nfEx, "attribute.malformed", new Object[]{"baseFrequency", s2});
        }
        if (v[0] < 0.0f || v[1] < 0.0f) {
            throw new BridgeException(ctx, e, "attribute.malformed", new Object[]{"baseFrequency", s2});
        }
        return v;
    }

    protected static boolean convertStitchTiles(Element e, BridgeContext ctx) {
        String s2 = e.getAttributeNS(null, "stitchTiles");
        if (s2.length() == 0) {
            return false;
        }
        if ("stitch".equals(s2)) {
            return true;
        }
        if ("noStitch".equals(s2)) {
            return false;
        }
        throw new BridgeException(ctx, e, "attribute.malformed", new Object[]{"stitchTiles", s2});
    }

    protected static boolean convertType(Element e, BridgeContext ctx) {
        String s2 = e.getAttributeNS(null, "type");
        if (s2.length() == 0) {
            return false;
        }
        if ("fractalNoise".equals(s2)) {
            return true;
        }
        if ("turbulence".equals(s2)) {
            return false;
        }
        throw new BridgeException(ctx, e, "attribute.malformed", new Object[]{"type", s2});
    }
}

