/*
 * Decompiled with CFR 0.152.
 */
package org.twak.utils;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector2d;
import org.twak.utils.Line;
import org.twak.utils.PanMouseAdaptor;
import org.twak.utils.collections.Loop;
import org.twak.utils.collections.LoopL;
import org.twak.utils.collections.Loopable;
import org.twak.utils.collections.MultiMap;
import org.twak.utils.geom.DRectangle;
import org.twak.utils.geom.Graph2D;
import org.twak.utils.geom.HalfMesh2;
import org.twak.utils.ui.Colourz;
import org.twak.utils.ui.Rainbow;

public class PaintThing {
    public static Map<Class, ICanPaintU> lookup = new HashMap<Class, ICanPaintU>();
    public static Map<Class, Class> editLookup = new HashMap<Class, Class>();
    public static MultiMap<Object, Object> debug = new MultiMap();
    static int stringCount = 0;
    private static DRectangle drawBounds = new DRectangle();

    public static void paint(Object o, Graphics2D g2, PanMouseAdaptor ma) {
        if (o == null) {
            return;
        }
        if (o instanceof ICanPaint) {
            ((ICanPaint)o).paint(g2, ma);
        } else if (lookup.containsKey(o.getClass())) {
            lookup.get(o.getClass()).paint(o, g2, ma);
        } else if (o instanceof LoopL) {
            PaintThing.p((LoopL)o, g2, ma);
        } else if (o instanceof Loop) {
            PaintThing.p((Loop)o, g2, ma);
        } else if (o instanceof Graph2D) {
            PaintThing.p((Graph2D)o, g2, ma);
        } else if (o instanceof Point2d) {
            PaintThing.p((Point2d)o, g2, ma);
        } else if (o instanceof Point3d) {
            PaintThing.p((Point3d)o, g2, ma);
        } else if (o instanceof Line) {
            PaintThing.p((Line)o, g2, ma);
        } else if (o instanceof HalfMesh2) {
            PaintThing.p((HalfMesh2)o, g2, ma);
        } else if (o instanceof String) {
            PaintThing.p((String)o, g2, ma);
        } else if (o instanceof StringLoc) {
            PaintThing.p((StringLoc)o, g2, ma);
        } else if (o instanceof Rectangle2D) {
            PaintThing.p((Rectangle2D)o, g2, ma);
        } else if (o instanceof DRectangle) {
            PaintThing.p((DRectangle)o, g2, ma);
        } else if (o instanceof ImLoc) {
            PaintThing.p((ImLoc)o, g2, ma);
        } else if (o instanceof Iterable) {
            for (Object o2 : (Iterable)o) {
                PaintThing.paint(o2, g2, ma);
            }
        } else {
            throw new Error("can't paint " + String.valueOf(o.getClass()));
        }
    }

    private static void p(Rectangle2D o, Graphics2D g2, PanMouseAdaptor ma) {
        Rectangle2D r = o;
        g2.drawRect(ma.toX(r.getX()), ma.toY(r.getY()), ma.toZoom(r.getWidth()), ma.toZoom(r.getHeight()));
        PaintThing.setBounds(new Point2d(o.getX(), o.getY()));
    }

    private static void p(DRectangle o, Graphics2D g2, PanMouseAdaptor ma) {
        DRectangle r = o;
        g2.drawRect(ma.toX(r.x), ma.toY(r.y), ma.toZoom(r.width), ma.toZoom(r.height));
        PaintThing.setBounds(o);
    }

    private static void p(HalfMesh2 o, Graphics2D g2, PanMouseAdaptor ma) {
        g2.setStroke(new BasicStroke(1.0f));
        double scatterRadius = 0.0;
        int fc = 0;
        for (HalfMesh2.HalfFace f : o.faces) {
            Polygon pwt = new Polygon();
            for (HalfMesh2.HalfEdge e : f.edges()) {
                pwt.addPoint(ma.toX(e.start.x + Math.random() * scatterRadius), ma.toY(e.start.y + Math.random() * scatterRadius));
                PaintThing.setBounds(e.start);
            }
            Color c = Rainbow.getColour(fc++);
            g2.setColor(new Color(c.getRed(), c.getGreen(), c.getBlue(), 50));
            g2.fill(pwt);
            g2.setColor(c);
            g2.draw(pwt);
            for (HalfMesh2.HalfEdge e : f.edges()) {
                PaintThing.drawArrow(g2, ma, e.line(), e.length() < 0.001 ? 16 : 4);
            }
        }
        for (HalfMesh2.HalfFace f : o.faces) {
            for (HalfMesh2.HalfEdge e : f.edges()) {
                if (e.over != null) continue;
                g2.setColor(Color.red);
                g2.setStroke(new BasicStroke(4.0f));
            }
        }
        g2.setStroke(new BasicStroke(1.0f));
    }

    private static void p(LoopL<? extends Point2d> o, Graphics2D g2, PanMouseAdaptor ma) {
        int cc = 0;
        for (Loop loop : o) {
            PaintThing.p2(loop, g2, ma, cc);
        }
    }

    public static void p(Loop<? extends Point2d> ll, Graphics2D g2, PanMouseAdaptor ma) {
        PaintThing.p2(ll, g2, ma, 0);
    }

    public static void p2(Loop<? extends Point2d> ll, Graphics2D g2, PanMouseAdaptor ma, int cc) {
        Color c = g2.getColor();
        g2.setColor(Colourz.transparent(c, 100));
        Polygon p = new Polygon();
        for (Point2d point2d : ll) {
            p.addPoint(ma.toX(point2d.x), ma.toY(point2d.y));
        }
        g2.fill(p);
        g2.setColor(c.darker());
        g2.draw(p);
        g2.setStroke(new BasicStroke(3.0f));
        for (Loopable loopable : ll.loopableIterator()) {
            PaintThing.drawArrow(g2, ma, new Line(new Point2d(((Point2d)loopable.get()).x, ((Point2d)loopable.get()).y), new Point2d(((Point2d)loopable.getNext().get()).x, ((Point2d)loopable.getNext().get()).y)), 9);
        }
        g2.setStroke(new BasicStroke(1.0f));
    }

    private static void p(Graph2D o, Graphics2D g2, PanMouseAdaptor ma) {
        double scatterRadius = 0.0;
        Color c = g2.getColor();
        for (Line l : o.allLines()) {
            if (l.length() < 0.001) {
                g2.setColor(Color.red);
            }
            PaintThing.setBounds(l.start);
            g2.drawLine(ma.toX(l.start.x + Math.random() * scatterRadius), ma.toY(l.start.y + Math.random() * scatterRadius), ma.toX(l.end.x + Math.random() * scatterRadius), ma.toY(l.end.y + Math.random() * scatterRadius));
            PaintThing.drawArrow(g2, ma, l, 5);
            g2.setColor(Color.red);
            g2.setColor(c);
        }
    }

    public static void drawArrow(Graphics2D g2, PanMouseAdaptor ma, Line l, int size) {
        Vector2d dir = l.dir();
        Point2d mid = l.fromPPram(0.5);
        AffineTransform old = g2.getTransform();
        g2.translate(ma.toX(mid.x), ma.toY(mid.y));
        g2.rotate(-Math.atan2(dir.x, dir.y));
        g2.drawLine(-size, -size, 0, 0);
        g2.drawLine(size, -size, 0, 0);
        g2.setTransform(old);
    }

    private static void p(Point3d o, Graphics2D g2, PanMouseAdaptor ma) {
        Point3d s2 = o;
        g2.fillOval(ma.toX(s2.x) - 2, ma.toY(s2.z) - 2, 4, 4);
    }

    private static void p(Point2d o, Graphics2D g2, PanMouseAdaptor ma) {
        Point2d s2 = o;
        g2.fillOval(ma.toX(s2.x) - 4, ma.toY(s2.y) - 4, 8, 8);
    }

    public static void p(Line o, Graphics2D g2, PanMouseAdaptor ma) {
        Line l = o;
        g2.drawLine(ma.toX(l.start.x), ma.toY(l.start.y), ma.toX(l.end.x), ma.toY(l.end.y));
        PaintThing.setBounds(o.start);
        PaintThing.setBounds(o.end);
    }

    private static void p(String o, Graphics2D g2, PanMouseAdaptor ma) {
        g2.setColor(Color.black);
        g2.drawString(o, 10, 30 * stringCount);
        ++stringCount;
    }

    private static void p(StringLoc o, Graphics2D g2, PanMouseAdaptor ma) {
        g2.drawString(o.string, ma.toX(o.loc.x), ma.toY(o.loc.y));
    }

    public static void paintDebug(Graphics2D g2, PanMouseAdaptor ma) {
        int count = 0;
        for (Object k : debug.keySet()) {
            g2.setColor(Rainbow.getColour(count++));
            if (k instanceof Style) {
                ((Style)k).activate(g2);
            }
            for (Object o : debug.get(k)) {
                PaintThing.paint(o, g2, ma);
            }
        }
    }

    public static void debug(Color c, float f, Object clean) {
        debug.put(new Style(c, f), clean);
    }

    public static void debug(Object o) {
        debug.put(new Style(Rainbow.next(Random.class), 1.0f), o);
    }

    public static DRectangle getBounds() {
        return drawBounds;
    }

    public static void resetBounds() {
        stringCount = 1;
        drawBounds = null;
    }

    public static void setBounds(DRectangle p) {
        drawBounds = drawBounds == null ? new DRectangle(p) : drawBounds.union(p);
    }

    public static void setBounds(Point2d p) {
        if (drawBounds == null) {
            drawBounds = new DRectangle(p);
        } else {
            drawBounds.envelop(p);
        }
    }

    private static void p(ImLoc o, Graphics2D g2, PanMouseAdaptor ma) {
        g2.drawImage(o.im, ma.toX(o.x), ma.toY(o.y), ma.toZoom(o.w), ma.toZoom(o.h), null);
    }

    public static class ImLoc {
        BufferedImage im;
        int x;
        int y;
        int w;
        int h;

        public ImLoc(BufferedImage im, int x, int y, int w, int h2) {
            this.im = im;
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h2;
        }
    }

    public static class StringLoc {
        String string;
        Point2d loc;

        public StringLoc(String string, Point2d loc) {
            this.string = string;
            this.loc = loc;
        }

        public StringLoc(String string, double x, double y) {
            this(string, new Point2d(x, y));
        }
    }

    private static class Style {
        Color color;
        float width;

        public Style(Color color, float width) {
            this.color = color;
            this.width = width;
        }

        public void activate(Graphics2D g2) {
            g2.setColor(this.color);
            g2.setStroke(new BasicStroke(this.width));
        }
    }

    public static interface ICanPaintU {
        public void paint(Object var1, Graphics2D var2, PanMouseAdaptor var3);
    }

    public static interface ICanPaint {
        public void paint(Graphics2D var1, PanMouseAdaptor var2);
    }
}

