/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.globis.phtree.pre;

import ch.ethz.globis.phtree.pre.ExponentPP;
import java.util.Arrays;

public class ExponentPPAnalyzer {
    public static ExponentPP analyze(double[][] data) {
        int N = data.length;
        int dims = data[0].length;
        double[] min2 = new double[dims];
        double[] max = new double[dims];
        Arrays.fill(min2, Double.MAX_VALUE);
        Arrays.fill(max, -1.7976931348623157E308);
        for (int i = 0; i < N; ++i) {
            double[] da = data[i];
            for (int d = 0; d < dims; ++d) {
                min2[d] = da[d] < min2[d] ? da[d] : min2[d];
                max[d] = da[d] > max[d] ? da[d] : max[d];
            }
        }
        double[] shifts = new double[dims];
        for (int d = 0; d < dims; ++d) {
            shifts[d] = ExponentPPAnalyzer.getDisplacement(min2[d], max[d]);
        }
        return new ExponentPP(shifts);
    }

    public static ExponentPP analyze(double[] data, int dims) {
        int N = data.length / dims;
        double[] min2 = new double[dims];
        double[] max = new double[dims];
        Arrays.fill(min2, Double.MAX_VALUE);
        Arrays.fill(max, -1.7976931348623157E308);
        for (int i = 0; i < N; ++i) {
            int offs = i * dims;
            for (int d = 0; d < dims; ++d) {
                min2[d] = data[d + offs] < min2[d] ? data[d + offs] : min2[d];
                max[d] = data[d + offs] > max[d] ? data[d + offs] : max[d];
            }
        }
        double[] shifts = new double[dims];
        for (int d = 0; d < dims; ++d) {
            shifts[d] = ExponentPPAnalyzer.getDisplacement(min2[d], max[d]);
        }
        return new ExponentPP(shifts);
    }

    private static double getDisplacement(double d1, double d2) {
        double MARGIN = 1.0001;
        double range = (d2 *= d2 > 0.0 ? MARGIN : 1.0 / MARGIN) - (d1 *= d1 > 0.0 ? 1.0 / MARGIN : MARGIN);
        if (d1 > 0.0 && range < d1) {
            range = d1;
        } else if (d2 < 0.0 && d2 < -range) {
            range = -d2;
        }
        if (range == 0.0) {
            return 0.0;
        }
        double log2 = Math.abs(range - 1.0) < 1.0E-4 ? Math.log1p(range - 1.0) / Math.log(2.0) : Math.log(range) / Math.log(2.0);
        log2 = Math.ceil(log2);
        double pos = Math.pow(2.0, log2);
        if (d2 <= 0.0) {
            return -pos - d2;
        }
        if (pos < d1) {
            // empty if block
        }
        return pos - d1;
    }
}

