/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.shaded.s2;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.CheckReturnValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.function.Predicate;
import java.util.logging.Logger;
import org.apache.sedona.shaded.fastutil.ints.IntArraySet;
import org.apache.sedona.shaded.guava.base.Preconditions;
import org.apache.sedona.shaded.s2.DistanceCollector;
import org.apache.sedona.shaded.s2.Platform;
import org.apache.sedona.shaded.s2.S1ChordAngle;
import org.apache.sedona.shaded.s2.S1Distance;
import org.apache.sedona.shaded.s2.S2;
import org.apache.sedona.shaded.s2.S2BestDistanceTarget;
import org.apache.sedona.shaded.s2.S2Cap;
import org.apache.sedona.shaded.s2.S2Cell;
import org.apache.sedona.shaded.s2.S2CellId;
import org.apache.sedona.shaded.s2.S2CellUnion;
import org.apache.sedona.shaded.s2.S2ContainsPointQuery;
import org.apache.sedona.shaded.s2.S2Iterator;
import org.apache.sedona.shaded.s2.S2Point;
import org.apache.sedona.shaded.s2.S2RegionCoverer;
import org.apache.sedona.shaded.s2.S2Shape;
import org.apache.sedona.shaded.s2.S2ShapeIndex;
import org.apache.sedona.shaded.s2.S2ShapeUtil;
import org.jspecify.annotations.Nullable;

@CheckReturnValue
public abstract class S2BestEdgesQueryBase<D extends S1Distance<D>> {
    private static final Logger log = Platform.getLoggerForClass(S2BestEdgesQueryBase.class);
    private static final int PRIORITY_QUEUE_INITIAL_SIZE = 16;
    private static final int MIN_EDGES_TO_ENQUEUE = 10;
    private final Comparator<Result<D>> resultDistanceComparator = (result1, result2) -> this.distanceComparator().compare(result1.distance, result2.distance);
    private final Comparator<Result<D>> resultDistanceComparatorReversed = (result1, result2) -> this.distanceComparator().compare(result2.distance, result1.distance);
    private final Comparator<Result<D>> resultShapeEdgeComparator = (result1, result2) -> {
        int diff = Integer.compare(result1.shapeId, result2.shapeId);
        return diff != 0 ? diff : Integer.compare(result1.edgeId, result2.edgeId);
    };
    private final Comparator<Result<D>> resultDistanceStableComparator = (result1, result2) -> {
        int compareByDistance = this.resultDistanceComparator.compare((Result<D>)result1, (Result<D>)result2);
        if (compareByDistance != 0) {
            return compareByDistance;
        }
        return this.resultShapeEdgeComparator.compare((Result<D>)result1, (Result<D>)result2);
    };
    private final Comparator<QueueEntry<D>> queueComparator = new Comparator<QueueEntry<D>>(){

        @Override
        public int compare(QueueEntry<D> qe1, QueueEntry<D> qe2) {
            return S2BestEdgesQueryBase.this.distanceComparator().compare(qe1.distance, qe2.distance);
        }
    };
    private final PriorityQueue<QueueEntry<D>> queue = new PriorityQueue<QueueEntry<D>>(16, this.queueComparator);
    private final ArrayList<S2CellId> initialCells = new ArrayList();
    private final Comparator<D> distanceComparator = this.distanceComparator();
    protected final Options<D> options;
    protected S2ShapeIndex index;
    protected S2BestDistanceTarget<D> target;
    protected @Nullable ShapeFilter shapeFilter;
    private final IntArraySet shapeInteriors = new IntArraySet();
    protected int maxResults = Integer.MAX_VALUE;
    protected D maxError;
    private boolean useConservativeCellDistance;
    private final ArrayList<S2CellId> indexCovering = new ArrayList(6);
    private final ArrayList<S2ShapeIndex.Cell> indexCells = new ArrayList(6);
    private int indexNumEdges;
    private int indexNumEdgesLimit;
    protected D distanceLimit;
    protected final PriorityQueue<Result<D>> resultQueue = new PriorityQueue<Result<D>>(16, this.resultDistanceComparatorReversed);
    protected Result<D> bestResult;
    private final DistanceCollector<D> bestResultCollector = this.newDistanceCollector();
    private boolean usingBruteForce;
    private final HashSet<ShapeEdgeId> testedEdges = new HashSet();
    private final List<Result<D>> resultPool = new ArrayList<Result<D>>();
    private final S2Shape.MutableEdge edge = new S2Shape.MutableEdge();
    private final DistanceCollector<D> collector = this.newDistanceCollector();

    protected abstract DistanceCollector<D> newDistanceCollector();

    protected abstract boolean atBestLimit(DistanceCollector<D> var1);

    protected abstract D zeroDistance();

    protected abstract D bestDistance();

    protected abstract D worstDistance();

    protected abstract D beyondWorstDistance();

    protected abstract S1ChordAngle searchCapRadius(S1ChordAngle var1, D var2);

    protected abstract Comparator<D> distanceComparator();

    protected abstract D errorBoundedDistance(D var1);

    @CanIgnoreReturnValue
    protected abstract boolean visitBestDistanceContainingShapes(S2BestDistanceTarget<D> var1, S2ContainsPointQuery.ShapeVisitor var2);

    S2BestEdgesQueryBase(Options<D> options) {
        this.options = options;
    }

    public void init(S2ShapeIndex index) {
        this.index = index;
        this.reInit();
    }

    public void reInit() {
        this.indexNumEdges = 0;
        this.indexNumEdgesLimit = 0;
        this.indexCells.clear();
    }

    public S2ShapeIndex index() {
        return this.index;
    }

    public Options<D> options() {
        return this.options;
    }

    protected boolean distanceAtLimit(D distance) {
        return this.distanceComparator.compare(distance, this.distanceLimit) >= 0;
    }

    public Optional<Result<D>> findBestEdge(S2BestDistanceTarget<D> target) {
        return this.findBestEdge(target, null);
    }

    public Optional<Result<D>> findBestEdge(S2BestDistanceTarget<D> target, @Nullable ShapeFilter shapeFilter) {
        this.distanceLimit = this.options.distanceLimit();
        this.maxResults = 1;
        this.maxError = this.options.maxError;
        this.shapeFilter = shapeFilter;
        this.findBestEdgesInternal(target);
        this.shapeFilter = null;
        return Optional.ofNullable(this.bestResult);
    }

    public void getEdge(Result<?> result, S2Shape.MutableEdge edge) {
        this.index.getShapes().get(result.shapeId()).getEdge(result.edgeId(), edge);
    }

    public boolean updateBestDistance(S2BestDistanceTarget<D> target, DistanceCollector<D> collector) {
        return this.updateBestDistance(target, null, collector);
    }

    public boolean updateBestDistance(S2BestDistanceTarget<D> target, @Nullable ShapeFilter shapeFilter, DistanceCollector<D> collector) {
        this.maxResults = 1;
        this.maxError = this.options.maxError;
        this.distanceLimit = collector.distance();
        this.shapeFilter = shapeFilter;
        this.findBestEdgesInternal(target);
        this.shapeFilter = null;
        if (this.bestResult == null) {
            return false;
        }
        this.resultPool.add(this.bestResult);
        return collector.update(this.bestResult.distance());
    }

    public List<Result<D>> findBestEdges(S2BestDistanceTarget<D> target) {
        return this.findBestEdges(target, (ShapeFilter)null);
    }

    public List<Result<D>> findBestEdges(S2BestDistanceTarget<D> target, @Nullable ShapeFilter shapeFilter) {
        this.distanceLimit = this.options.distanceLimit();
        this.maxResults = this.options.maxResults();
        this.maxError = this.options.maxError;
        this.shapeFilter = shapeFilter;
        this.findBestEdgesInternal(target);
        this.shapeFilter = null;
        if (this.maxResults > 1) {
            ArrayList<Result<D>> results = new ArrayList<Result<D>>(this.resultQueue);
            Collections.sort(results, this.resultDistanceStableComparator);
            this.resultQueue.clear();
            return results;
        }
        ArrayList<Result<D>> results = new ArrayList<Result<D>>();
        if (this.bestResult != null) {
            results.add(this.bestResult);
        }
        this.bestResult = null;
        return results;
    }

    public void findBestEdges(S2BestDistanceTarget<D> target, ResultVisitor<D> visitor) {
        this.findBestEdges(target, null, visitor);
    }

    public void findBestEdges(S2BestDistanceTarget<D> target, @Nullable ShapeFilter shapeFilter, ResultVisitor<D> visitor) {
        this.distanceLimit = this.options.distanceLimit();
        this.maxResults = this.options.maxResults();
        this.maxError = this.options.maxError;
        this.shapeFilter = shapeFilter;
        this.findBestEdgesInternal(target);
        this.shapeFilter = null;
        if (this.maxResults > 1) {
            ArrayList<Result<D>> results = new ArrayList<Result<D>>(this.resultQueue);
            Collections.sort(results, this.resultDistanceStableComparator);
            this.resultQueue.clear();
            for (Result result : results) {
                if (visitor.accept(result.distance, result.shapeId, result.edgeId)) continue;
                break;
            }
            this.resultPool.addAll(results);
            return;
        }
        if (this.bestResult != null) {
            boolean unused2 = visitor.accept(this.bestResult.distance, this.bestResult.shapeId, this.bestResult.edgeId);
            this.resultPool.add(this.bestResult);
            this.bestResult = null;
        }
    }

    protected void findBestEdgesInternal(S2BestDistanceTarget<D> target) {
        assert (this.resultQueue.isEmpty());
        assert (target.maxBruteForceIndexSize() >= 0);
        this.target = target;
        this.testedEdges.clear();
        this.bestResult = null;
        if (this.distanceLimit.equals(this.bestDistance())) {
            log.fine("No possible results, cannot be better than the best possible distance.");
            return;
        }
        if (this.maxResults == Integer.MAX_VALUE && this.distanceLimit.equals(this.beyondWorstDistance())) {
            log.fine("Returning all edges! maxResults and distanceLimit set no limits.");
        }
        if (this.options.includeInteriors()) {
            this.shapeInteriors.clear();
            this.visitBestDistanceContainingShapes(target, shapeId -> {
                if (!this.shapeInteriors.add(shapeId)) {
                    return true;
                }
                if (this.shapeFilter == null || this.shapeFilter.test(shapeId)) {
                    this.addResult(this.bestDistance(), shapeId, -1);
                }
                return !this.distanceLimit.equals(this.bestDistance());
            });
        }
        boolean targetUsesMaxError = !this.maxError.isZero() && target.setMaxError(this.maxError);
        boolean bl = this.useConservativeCellDistance = targetUsesMaxError && (this.distanceLimit.equals(this.beyondWorstDistance()) || this.maxError.lessThan(this.distanceLimit));
        if (this.options.useBruteForce()) {
            this.findBestEdgesBruteForce();
            return;
        }
        int minOptimizedEdges = target.maxBruteForceIndexSize() + 1;
        if (minOptimizedEdges > this.indexNumEdgesLimit && this.indexNumEdges >= this.indexNumEdgesLimit) {
            this.indexNumEdges = S2ShapeUtil.countEdgesUpTo(this.index, minOptimizedEdges);
            this.indexNumEdgesLimit = minOptimizedEdges;
        }
        if (this.indexNumEdges >= minOptimizedEdges) {
            this.findBestEdgesOptimized();
            return;
        }
        minOptimizedEdges = (int)Math.sqrt(0.5 * (double)target.maxBruteForceIndexSize() * (double)this.index.options().getMaxEdgesPerCell());
        if (this.index.isFresh() && this.indexNumEdges >= minOptimizedEdges) {
            this.findBestEdgesOptimized();
            return;
        }
        this.findBestEdgesBruteForce();
    }

    private void findBestEdgesBruteForce() {
        this.usingBruteForce = true;
        List<S2Shape> shapes = this.index.getShapes();
        for (int shapeId = 0; shapeId < shapes.size(); ++shapeId) {
            S2Shape shape;
            if (this.shapeFilter != null && !this.shapeFilter.test(shapeId) || (shape = shapes.get(shapeId)) == null) continue;
            int numEdges = shape.numEdges();
            for (int e = 0; e < numEdges; ++e) {
                this.maybeAddResult(shapeId, e);
            }
        }
    }

    private void findBestEdgesOptimized() {
        this.usingBruteForce = false;
        S2Iterator<S2ShapeIndex.Cell> iter = this.initQueue();
        while (!this.queue.isEmpty()) {
            QueueEntry<D> entry = this.queue.poll();
            if (this.distanceAtLimit(entry.distance)) {
                this.queue.clear();
                break;
            }
            if (entry.indexCell != null) {
                this.processEdges(entry.indexCell);
                continue;
            }
            S2CellId id = entry.id;
            iter.seek(id.child(1).rangeMin());
            if (!iter.done() && iter.id().lessOrEquals(id.child(1).rangeMax())) {
                this.processOrEnqueueChild(id.child(1), iter);
            }
            if (iter.prev() && iter.id().greaterOrEquals(id.rangeMin())) {
                this.processOrEnqueueChild(id.child(0), iter);
            }
            iter.seek(id.child(3).rangeMin());
            if (!iter.done() && iter.id().lessOrEquals(id.child(3).rangeMax())) {
                this.processOrEnqueueChild(id.child(3), iter);
            }
            if (!iter.prev() || !iter.id().greaterOrEquals(id.child(2).rangeMin())) continue;
            this.processOrEnqueueChild(id.child(2), iter);
        }
    }

    private void processOrEnqueueChild(S2CellId id, S2Iterator<S2ShapeIndex.Cell> iter) {
        assert (id.contains(iter.id()));
        if (iter.id().equals(id)) {
            this.processOrEnqueue(id, iter.entry());
        } else {
            this.processOrEnqueue(id, null);
        }
    }

    private S2Iterator<S2ShapeIndex.Cell> initQueue() {
        assert (this.queue.isEmpty());
        S2Iterator.ListIterator<S2ShapeIndex.Cell> iter = this.index.iterator();
        S2Cap targetCap = this.target.getCapBound();
        if (targetCap.isEmpty()) {
            return iter;
        }
        if (this.maxResults == 1 && iter.locate(targetCap.axis())) {
            this.processEdges((S2ShapeIndex.Cell)iter.entry());
            if (this.distanceLimit.equals(this.bestDistance())) {
                return iter;
            }
        }
        if (this.indexCovering.isEmpty()) {
            this.initCovering();
        }
        if (this.distanceLimit == this.beyondWorstDistance()) {
            for (int i = 0; i < this.indexCovering.size(); ++i) {
                this.processOrEnqueue(this.indexCovering.get(i), this.indexCells.get(i));
            }
        } else {
            ArrayList<S2CellId> searchCapCovering = new ArrayList<S2CellId>();
            this.initialCells.clear();
            S1ChordAngle radius = this.searchCapRadius(targetCap.radius(), this.distanceLimit);
            S2Cap searchCap = S2Cap.fromAxisChord(targetCap.axis(), radius);
            S2RegionCoverer coverer = S2RegionCoverer.builder().setMaxCells(4).build();
            coverer.getFastCovering(searchCap, searchCapCovering);
            S2CellUnion.getIntersection(this.indexCovering, searchCapCovering, this.initialCells);
            int i = 0;
            int j = 0;
            while (i < this.initialCells.size()) {
                S2CellId initialCellId = this.initialCells.get(i);
                while (this.indexCovering.get(j).rangeMax().lessThan(initialCellId)) {
                    ++j;
                }
                S2CellId coveringCellId = this.indexCovering.get(j);
                if (initialCellId.equals(coveringCellId)) {
                    this.processOrEnqueue(coveringCellId, this.indexCells.get(j));
                    ++i;
                    ++j;
                    continue;
                }
                S2ShapeIndex.CellRelation r = iter.locate(initialCellId);
                if (r == S2ShapeIndex.CellRelation.INDEXED) {
                    this.processOrEnqueue(iter.id(), (S2ShapeIndex.Cell)iter.entry());
                    S2CellId lastId = iter.id().rangeMax();
                    while (++i < this.initialCells.size() && this.initialCells.get(i).lessOrEquals(lastId)) {
                    }
                    continue;
                }
                if (r == S2ShapeIndex.CellRelation.SUBDIVIDED) {
                    this.processOrEnqueue(initialCellId, null);
                }
                ++i;
            }
        }
        return iter;
    }

    private void initCovering() {
        this.indexCovering.clear();
        this.indexCells.clear();
        S2Iterator.ListIterator<S2ShapeIndex.Cell> next = this.index.iterator();
        if (next.done()) {
            return;
        }
        S2Iterator.ListIterator<S2ShapeIndex.Cell> last = this.index.iterator();
        last.finish();
        last.prev();
        if (!next.id().equals(last.id())) {
            int level = next.id().getCommonAncestorLevel(last.id()) + 1;
            S2CellId lastId = last.id().parent(level);
            S2CellId id = next.id().parent(level);
            while (!id.equals(lastId)) {
                if (!id.rangeMax().lessThan(next.id())) {
                    S2Iterator<S2ShapeIndex.Cell> cellFirst = next.copy();
                    next.seek(id.rangeMax().next());
                    S2Iterator<S2ShapeIndex.Cell> cellLast = next.copy();
                    cellLast.prev();
                    this.addInitialRange(cellFirst, cellLast);
                }
                id = id.next();
            }
        }
        this.addInitialRange(next, last);
    }

    private void addInitialRange(S2Iterator<S2ShapeIndex.Cell> first, S2Iterator<S2ShapeIndex.Cell> last) {
        if (first.id().equals(last.id())) {
            this.indexCovering.add(first.id());
            this.indexCells.add(first.entry());
        } else {
            int level = first.id().getCommonAncestorLevel(last.id());
            assert (level >= 0);
            this.indexCovering.add(first.id().parent(level));
            this.indexCells.add(null);
        }
    }

    private void maybeAddResult(int shapeId, int edgeId) {
        if (!this.usingBruteForce && !this.testedEdges.add(new ShapeEdgeId(shapeId, edgeId))) {
            return;
        }
        this.collector.set(this.distanceLimit);
        S2Shape shape = this.index.getShapes().get(shapeId);
        shape.getEdge(edgeId, this.edge);
        if (shape.dimension() == 0) {
            if (this.target.updateBestDistance(this.edge.a, this.collector)) {
                this.addResult(this.collector.distance(), shapeId, edgeId);
            }
        } else if (this.target.updateBestDistance(this.edge.a, this.edge.b, this.collector)) {
            this.addResult(this.collector.distance(), shapeId, edgeId);
        }
    }

    protected void addResult(D distance, int shapeId, int edgeId) {
        if (this.maxResults == 1) {
            this.updateBestResult(distance, shapeId, edgeId);
        } else {
            this.updateBestResults(distance, shapeId, edgeId);
        }
    }

    private void updateBestResult(D distance, int shapeId, int edgeId) {
        if (this.bestResult == null) {
            if (this.resultPool.isEmpty()) {
                this.bestResult = new Result<D>(distance, shapeId, edgeId);
            } else {
                this.bestResult = this.resultPool.remove(this.resultPool.size() - 1);
                this.bestResult.set(distance, shapeId, edgeId);
            }
            this.bestResultCollector.set(distance);
            this.distanceLimit = this.errorBoundedDistance(distance);
            return;
        }
        if (this.bestResultCollector.update(distance)) {
            this.bestResult.set(distance, shapeId, edgeId);
            this.distanceLimit = this.errorBoundedDistance(this.bestResult.distance());
        }
    }

    private void updateBestResults(D distance, int shapeId, int edgeId) {
        Result<D> result;
        if (this.resultPool.isEmpty()) {
            result = new Result<D>(distance, shapeId, edgeId);
        } else {
            result = this.resultPool.remove(this.resultPool.size() - 1);
            result.set(distance, shapeId, edgeId);
        }
        this.resultQueue.add(result);
        int size = this.resultQueue.size();
        if (size >= this.maxResults) {
            if (size > this.maxResults) {
                this.resultPool.add(this.resultQueue.poll());
            }
            this.distanceLimit = this.errorBoundedDistance(this.resultQueue.peek().distance());
        }
    }

    private static int countEdges(S2ShapeIndex.Cell cell) {
        int count = 0;
        for (int s2 = 0; s2 < cell.numShapes(); ++s2) {
            count += cell.clipped(s2).numEdges();
        }
        return count;
    }

    private void processEdges(S2ShapeIndex.Cell shapeIndexCell) {
        for (int s2 = 0; s2 < shapeIndexCell.numShapes(); ++s2) {
            S2ShapeIndex.S2ClippedShape clipped = shapeIndexCell.clipped(s2);
            int shapeId = clipped.shapeId();
            if (this.shapeFilter != null && !this.shapeFilter.test(shapeId)) continue;
            for (int j = 0; j < clipped.numEdges(); ++j) {
                this.maybeAddResult(shapeId, clipped.edge(j));
            }
        }
    }

    private void processOrEnqueue(S2CellId id, @Nullable S2ShapeIndex.Cell indexCell) {
        if (indexCell != null) {
            int numEdges = S2BestEdgesQueryBase.countEdges(indexCell);
            if (numEdges == 0) {
                return;
            }
            if (numEdges < 10) {
                this.processEdges(indexCell);
                return;
            }
            if (this.shapeFilter != null) {
                boolean skipCell = true;
                for (int s2 = 0; s2 < indexCell.numShapes(); ++s2) {
                    S2ShapeIndex.S2ClippedShape clipped = indexCell.clipped(s2);
                    if (!this.shapeFilter.test(clipped.shapeId())) continue;
                    skipCell = false;
                    break;
                }
                if (skipCell) {
                    return;
                }
            }
        }
        S2Cell cell = new S2Cell(id);
        DistanceCollector<D> collector = this.newDistanceCollector();
        collector.set(this.distanceLimit);
        if (!this.target.updateBestDistance(cell, collector)) {
            return;
        }
        D distance = this.useConservativeCellDistance ? this.errorBoundedDistance(collector.distance()) : collector.distance();
        this.queue.add(new QueueEntry<D>(distance, id, indexCell));
    }

    private static class ShapeEdgeId {
        private final int shapeId;
        private final int edgeId;

        public ShapeEdgeId(int shapeId, int edgeId) {
            this.shapeId = shapeId;
            this.edgeId = edgeId;
        }

        public int hashCode() {
            return this.shapeId + 17 * this.edgeId;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof ShapeEdgeId)) {
                return false;
            }
            ShapeEdgeId ids = (ShapeEdgeId)obj;
            return this.shapeId == ids.shapeId && this.edgeId == ids.edgeId;
        }
    }

    protected static class QueueEntry<D extends S1Distance<D>> {
        final D distance;
        final S2CellId id;
        final S2ShapeIndex.Cell indexCell;

        QueueEntry(D distance, S2CellId id, S2ShapeIndex.Cell indexCell) {
            Preconditions.checkNotNull(distance);
            this.distance = distance;
            this.id = id;
            this.indexCell = indexCell;
        }
    }

    protected static abstract class ShapeIndexTarget<D extends S1Distance<D>>
    implements S2BestDistanceTarget<D> {
        protected final S2ShapeIndex index;
        protected final Builder<D> queryBuilder;
        protected S2BestEdgesQueryBase<D> bestDistanceQuery = null;

        public ShapeIndexTarget(S2ShapeIndex index, Builder<D> queryBuilder) {
            this.index = index;
            this.queryBuilder = queryBuilder;
        }

        @Override
        public boolean setMaxError(D maxError) {
            this.queryBuilder.setMaxError(maxError);
            this.bestDistanceQuery = null;
            return true;
        }

        @Override
        public void setIncludeInteriors(boolean includeInteriors) {
            this.queryBuilder.setIncludeInteriors(includeInteriors);
            this.bestDistanceQuery = null;
        }

        @Override
        public boolean includeInteriors() {
            return this.queryBuilder.includeInteriors();
        }

        protected boolean updateBestDistance(S2BestDistanceTarget<D> target, DistanceCollector<D> collector) {
            if (this.bestDistanceQuery == null) {
                this.bestDistanceQuery = this.queryBuilder.build(this.index);
            }
            if (this.bestDistanceQuery.atBestLimit(collector)) {
                return false;
            }
            return this.bestDistanceQuery.updateBestDistance(target, collector);
        }

        @Override
        @CanIgnoreReturnValue
        public boolean visitConnectedComponentPoints(S2ShapeUtil.PointVisitor visitor) {
            for (S2Shape shape : this.index.getShapes()) {
                S2Shape.ReferencePoint ref;
                if (shape == null) continue;
                boolean testedPoint = false;
                for (int chain = 0; chain < shape.numChains(); ++chain) {
                    if (shape.getChainLength(chain) == 0) continue;
                    testedPoint = true;
                    if (visitor.apply(shape.getChainVertex(chain, 0))) continue;
                    return false;
                }
                if (testedPoint || !(ref = shape.getReferencePoint()).contained() || visitor.apply(ref.point())) continue;
                return false;
            }
            return true;
        }
    }

    protected static abstract class CellTarget<D extends S1Distance<D>>
    implements S2BestDistanceTarget<D> {
        protected final S2Cell cell;

        public CellTarget(S2Cell cell) {
            this.cell = cell;
        }

        @Override
        @CanIgnoreReturnValue
        public boolean updateBestDistance(S2Point p, DistanceCollector<D> collector) {
            return collector.update(p, this.cell);
        }

        @Override
        @CanIgnoreReturnValue
        public boolean updateBestDistance(S2Point v0, S2Point v1, DistanceCollector<D> collector) {
            return collector.update(v0, v1, this.cell);
        }

        @Override
        @CanIgnoreReturnValue
        public boolean updateBestDistance(S2Cell c, DistanceCollector<D> collector) {
            return collector.update(this.cell, c);
        }

        @Override
        @CanIgnoreReturnValue
        public boolean visitConnectedComponentPoints(S2ShapeUtil.PointVisitor visitor) {
            return visitor.apply(this.cell.getCenter());
        }
    }

    protected static abstract class EdgeTarget<D extends S1Distance<D>>
    implements S2BestDistanceTarget<D> {
        protected final S2Point a;
        protected final S2Point b;

        public EdgeTarget(S2Point a, S2Point b) {
            assert (S2.isUnitLength(a));
            assert (S2.isUnitLength(b));
            this.a = a;
            this.b = b;
        }

        @Override
        @CanIgnoreReturnValue
        public boolean updateBestDistance(S2Point p, DistanceCollector<D> collector) {
            return collector.update(p, this.a, this.b);
        }

        @Override
        @CanIgnoreReturnValue
        public boolean updateBestDistance(S2Point v0, S2Point v1, DistanceCollector<D> collector) {
            return collector.update(v0, v1, this.a, this.b);
        }

        @Override
        @CanIgnoreReturnValue
        public boolean updateBestDistance(S2Cell cell, DistanceCollector<D> collector) {
            return collector.update(this.a, this.b, cell);
        }

        protected double getHalfEdgeLength2() {
            double d2 = new S1ChordAngle(this.a, this.b).getLength2();
            return 0.5 * d2 / (1.0 + Math.sqrt(1.0 - 0.25 * d2));
        }

        @Override
        @CanIgnoreReturnValue
        public boolean visitConnectedComponentPoints(S2ShapeUtil.PointVisitor visitor) {
            S2Point edgeCenter = this.a.add(this.b).normalize();
            return visitor.apply(edgeCenter);
        }
    }

    protected static abstract class PointTarget<D extends S1Distance<D>>
    implements S2BestDistanceTarget<D> {
        protected final S2Point point;

        public PointTarget(S2Point point) {
            this.point = point;
        }

        @Override
        @CanIgnoreReturnValue
        public boolean updateBestDistance(S2Point p, DistanceCollector<D> collector) {
            return collector.update(this.point, p);
        }

        @Override
        @CanIgnoreReturnValue
        public boolean updateBestDistance(S2Point v0, S2Point v1, DistanceCollector<D> collector) {
            return collector.update(this.point, v0, v1);
        }

        @Override
        @CanIgnoreReturnValue
        public boolean updateBestDistance(S2Cell cell, DistanceCollector<D> collector) {
            return collector.update(this.point, cell);
        }

        @Override
        @CanIgnoreReturnValue
        public boolean visitConnectedComponentPoints(S2ShapeUtil.PointVisitor visitor) {
            return visitor.apply(this.point);
        }
    }

    public static final class Options<D extends S1Distance<D>> {
        final int maxResults;
        final D distanceLimit;
        final D maxError;
        final boolean includeInteriors;
        final boolean useBruteForce;

        Options(Builder<D> b) {
            this.maxResults = b.maxResults();
            this.distanceLimit = b.distanceLimit();
            this.maxError = b.maxError();
            this.includeInteriors = b.includeInteriors();
            this.useBruteForce = b.useBruteForce();
        }

        public int maxResults() {
            return this.maxResults;
        }

        public D distanceLimit() {
            return this.distanceLimit;
        }

        public D maxError() {
            return this.maxError;
        }

        public boolean includeInteriors() {
            return this.includeInteriors;
        }

        public boolean useBruteForce() {
            return this.useBruteForce;
        }
    }

    public static abstract class Builder<D extends S1Distance<D>> {
        protected int maxResults;
        protected D distanceLimit;
        protected D maxError;
        protected boolean includeInteriors;
        protected boolean useBruteForce;

        protected Builder(D defaultDistanceLimit, D zero) {
            this.distanceLimit = defaultDistanceLimit;
            this.maxError = zero;
            this.maxResults = Integer.MAX_VALUE;
            this.includeInteriors = true;
            this.useBruteForce = false;
        }

        public Builder(Options<D> options) {
            this.distanceLimit = options.distanceLimit;
            this.maxError = options.maxError;
            this.maxResults = options.maxResults;
            this.includeInteriors = options.includeInteriors;
            this.useBruteForce = options.useBruteForce;
        }

        public Builder(Builder<D> other) {
            this.distanceLimit = other.distanceLimit;
            this.maxError = other.maxError;
            this.maxResults = other.maxResults;
            this.includeInteriors = other.includeInteriors;
            this.useBruteForce = other.useBruteForce;
        }

        public abstract S2BestEdgesQueryBase<D> build();

        public S2BestEdgesQueryBase<D> build(S2ShapeIndex index) {
            S2BestEdgesQueryBase<D> query = this.build();
            query.init(index);
            return query;
        }

        @CanIgnoreReturnValue
        public Builder<D> setMaxResults(int maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public int maxResults() {
            return this.maxResults;
        }

        @CanIgnoreReturnValue
        public Builder<D> setDistanceLimit(D distanceLimit) {
            this.distanceLimit = distanceLimit;
            return this;
        }

        public D distanceLimit() {
            return this.distanceLimit;
        }

        @CanIgnoreReturnValue
        public Builder<D> setMaxError(D maxError) {
            this.maxError = maxError;
            return this;
        }

        public D maxError() {
            return this.maxError;
        }

        @CanIgnoreReturnValue
        public Builder<D> setIncludeInteriors(boolean includeInteriors) {
            this.includeInteriors = includeInteriors;
            return this;
        }

        public boolean includeInteriors() {
            return this.includeInteriors;
        }

        @CanIgnoreReturnValue
        public Builder<D> setUseBruteForce(boolean useBruteForce) {
            this.useBruteForce = useBruteForce;
            return this;
        }

        public boolean useBruteForce() {
            return this.useBruteForce;
        }
    }

    public static interface ResultVisitor<D> {
        public boolean accept(D var1, int var2, int var3);
    }

    public static class Result<D extends S1Distance<D>> {
        private D distance;
        private int shapeId;
        private int edgeId;

        public Result(D distance, int shapeId, int edgeId) {
            this.distance = distance;
            this.shapeId = shapeId;
            this.edgeId = edgeId;
        }

        public void set(D distance, int shapeId, int edgeId) {
            this.distance = distance;
            this.shapeId = shapeId;
            this.edgeId = edgeId;
        }

        public boolean isInterior() {
            return this.shapeId >= 0 && this.edgeId < 0;
        }

        public D distance() {
            return this.distance;
        }

        public int shapeId() {
            return this.shapeId;
        }

        public int edgeId() {
            return this.edgeId;
        }

        public boolean equalsResult(Result<D> other) {
            return this.distance.equals(other.distance) && this.shapeId == other.shapeId && this.edgeId == other.edgeId;
        }
    }

    public static interface ShapeFilter
    extends Predicate<Integer> {
    }
}

