/*
 * Decompiled with CFR 0.152.
 */
package com.conversantmedia.util.estimation;

import java.io.PrintStream;
import java.util.Arrays;

public class Percentile {
    private static float[] DEFAULT_PERCENTILE = new float[]{0.05f, 0.5f, 0.683f, 0.75f, 0.85f, 0.954f, 0.99f};
    private final float[] quantiles;
    private final int m;
    private final float[] q;
    private final int[] n;
    private final float[] f;
    private final float[] d;
    private final float[] e;
    private boolean isInitializing;
    private int ni;

    public Percentile() {
        this(DEFAULT_PERCENTILE);
    }

    public Percentile(float[] quantiles) {
        this.m = quantiles.length;
        this.quantiles = Arrays.copyOf(quantiles, this.m);
        int N = 2 * this.m + 3;
        this.q = new float[N + 1];
        this.n = new int[N + 1];
        this.f = new float[N + 1];
        this.d = new float[N + 1];
        this.e = new float[this.m];
        this.clear();
    }

    public void clear() {
        int i;
        for (i = 1; i <= 2 * this.m + 3; ++i) {
            this.n[i] = i + 1;
        }
        this.f[1] = 0.0f;
        this.f[2 * this.m + 3] = 1.0f;
        for (i = 1; i <= this.m; ++i) {
            this.f[2 * i + 1] = this.quantiles[i - 1];
        }
        for (i = 1; i <= this.m + 1; ++i) {
            this.f[2 * i] = (this.f[2 * i - 1] + this.f[2 * i + 1]) / 2.0f;
        }
        for (i = 1; i <= 2 * this.m + 3; ++i) {
            this.d[i] = 1.0f + (float)(2 * (this.m + 1)) * this.f[i];
        }
        this.isInitializing = true;
        this.ni = 1;
    }

    public void add(float x) {
        if (this.isInitializing) {
            this.q[this.ni++] = x;
            if (this.ni == 2 * this.m + 3 + 1) {
                Arrays.sort(this.q);
                this.isInitializing = false;
            }
        } else {
            this.addMeasurement(x);
        }
    }

    public float[] getQuantiles() {
        return this.quantiles;
    }

    public boolean isReady() {
        return !this.isInitializing;
    }

    public int getNSamples() {
        if (!this.isInitializing) {
            return this.n[2 * this.m + 3] - 1;
        }
        return this.ni - 1;
    }

    public float[] getEstimates() throws InsufficientSamplesException {
        if (!this.isInitializing) {
            for (int i = 1; i <= this.m; ++i) {
                this.e[i - 1] = this.q[2 * i + 1];
            }
            return this.e;
        }
        throw new InsufficientSamplesException();
    }

    public float getMin() {
        return this.q[1];
    }

    public float getMax() {
        return this.q[2 * this.m + 3];
    }

    private void addMeasurement(float x) {
        int i;
        int k = 1;
        if (x < this.q[1]) {
            k = 1;
            this.q[1] = x;
        } else if (x >= this.q[2 * this.m + 3]) {
            k = 2 * this.m + 2;
            this.q[2 * this.m + 3] = x;
        } else {
            for (i = 1; i <= 2 * this.m + 2; ++i) {
                if (!(this.q[i] <= x) || !(x < this.q[i + 1])) continue;
                k = i;
                break;
            }
        }
        for (i = k + 1; i <= 2 * this.m + 3; ++i) {
            this.n[i] = this.n[i] + 1;
        }
        for (i = 1; i <= 2 * this.m + 3; ++i) {
            this.d[i] = this.d[i] + this.f[i];
        }
        for (i = 2; i <= 2 * this.m + 2; ++i) {
            float qt;
            float dval = this.d[i] - (float)this.n[i];
            float dp = this.n[i + 1] - this.n[i];
            float dm = this.n[i - 1] - this.n[i];
            float qp = (this.q[i + 1] - this.q[i]) / dp;
            float qm = (this.q[i - 1] - this.q[i]) / dm;
            if (dval >= 1.0f && dp > 1.0f) {
                qt = this.q[i] + ((1.0f - dm) * qp + (dp - 1.0f) * qm) / (dp - dm);
                this.q[i] = this.q[i - 1] < qt && qt < this.q[i + 1] ? qt : this.q[i] + qp;
                this.n[i] = this.n[i] + 1;
                continue;
            }
            if (!(dval <= -1.0f) || !(dm < -1.0f)) continue;
            qt = this.q[i] - ((1.0f + dp) * qm - (dm + 1.0f) * qp) / (dp - dm);
            this.q[i] = this.q[i - 1] < qt && qt < this.q[i + 1] ? qt : this.q[i] - qm;
            this.n[i] = this.n[i] - 1;
        }
    }

    public static void print(PrintStream out, String name, Percentile p) {
        if (p.isReady()) {
            try {
                StringBuilder sb = new StringBuilder(512);
                float[] q = p.getQuantiles();
                float[] e = p.getEstimates();
                int SCREENWIDTH = 80;
                sb.append(name);
                sb.append(", min(");
                sb.append(p.getMin());
                sb.append("), max(");
                sb.append(p.getMax());
                sb.append(')');
                sb.append("\n");
                float max = e[e.length - 1];
                for (int i = 0; i < q.length; ++i) {
                    sb.append(String.format("%4.3f", Float.valueOf(q[i])));
                    sb.append(": ");
                    int len = (int)(e[i] / max * 80.0f);
                    for (int j = 0; j < len; ++j) {
                        sb.append('#');
                    }
                    sb.append(" ");
                    sb.append(String.format("%4.3f\n", Float.valueOf(e[i])));
                }
                out.println(sb.toString());
            }
            catch (InsufficientSamplesException insufficientSamplesException) {
                // empty catch block
            }
        }
    }

    public class InsufficientSamplesException
    extends Exception {
        private InsufficientSamplesException() {
        }
    }
}

