/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.containerservice.implementation;

import com.microsoft.azure.AzureClient;
import com.microsoft.azure.AzureServiceClient;
import com.microsoft.azure.management.containerservice.implementation.ContainerServicesInner;
import com.microsoft.azure.management.containerservice.implementation.ManagedClustersInner;
import com.microsoft.azure.management.containerservice.implementation.OperationsInner;
import com.microsoft.rest.RestClient;
import com.microsoft.rest.credentials.ServiceClientCredentials;

public class ContainerServiceManagementClientImpl
extends AzureServiceClient {
    private AzureClient azureClient;
    private String subscriptionId;
    private String acceptLanguage;
    private int longRunningOperationRetryTimeout;
    private boolean generateClientRequestId;
    private ContainerServicesInner containerServices;
    private OperationsInner operations;
    private ManagedClustersInner managedClusters;

    public AzureClient getAzureClient() {
        return this.azureClient;
    }

    public String subscriptionId() {
        return this.subscriptionId;
    }

    public ContainerServiceManagementClientImpl withSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
        return this;
    }

    public String acceptLanguage() {
        return this.acceptLanguage;
    }

    public ContainerServiceManagementClientImpl withAcceptLanguage(String acceptLanguage) {
        this.acceptLanguage = acceptLanguage;
        return this;
    }

    public int longRunningOperationRetryTimeout() {
        return this.longRunningOperationRetryTimeout;
    }

    public ContainerServiceManagementClientImpl withLongRunningOperationRetryTimeout(int longRunningOperationRetryTimeout) {
        this.longRunningOperationRetryTimeout = longRunningOperationRetryTimeout;
        return this;
    }

    public boolean generateClientRequestId() {
        return this.generateClientRequestId;
    }

    public ContainerServiceManagementClientImpl withGenerateClientRequestId(boolean generateClientRequestId) {
        this.generateClientRequestId = generateClientRequestId;
        return this;
    }

    public ContainerServicesInner containerServices() {
        return this.containerServices;
    }

    public OperationsInner operations() {
        return this.operations;
    }

    public ManagedClustersInner managedClusters() {
        return this.managedClusters;
    }

    public ContainerServiceManagementClientImpl(ServiceClientCredentials credentials) {
        this("https://management.azure.com", credentials);
    }

    public ContainerServiceManagementClientImpl(String baseUrl, ServiceClientCredentials credentials) {
        super(baseUrl, credentials);
        this.initialize();
    }

    public ContainerServiceManagementClientImpl(RestClient restClient) {
        super(restClient);
        this.initialize();
    }

    protected void initialize() {
        this.acceptLanguage = "en-US";
        this.longRunningOperationRetryTimeout = 30;
        this.generateClientRequestId = true;
        this.containerServices = new ContainerServicesInner(this.restClient().retrofit(), this);
        this.operations = new OperationsInner(this.restClient().retrofit(), this);
        this.managedClusters = new ManagedClustersInner(this.restClient().retrofit(), this);
        this.azureClient = new AzureClient((AzureServiceClient)this);
    }

    public String userAgent() {
        return String.format("%s (%s)", super.userAgent(), "ContainerServiceManagementClient");
    }
}

