/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.trafficmanager.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.management.trafficmanager.implementation.DeleteOperationResultInner;
import com.microsoft.azure.management.trafficmanager.implementation.TrafficManagerManagementClientImpl;
import com.microsoft.azure.management.trafficmanager.implementation.UserMetricsModelInner;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class TrafficManagerUserMetricsKeysInner {
    private TrafficManagerUserMetricsKeysService service;
    private TrafficManagerManagementClientImpl client;

    public TrafficManagerUserMetricsKeysInner(Retrofit retrofit, TrafficManagerManagementClientImpl client) {
        this.service = (TrafficManagerUserMetricsKeysService)retrofit.create(TrafficManagerUserMetricsKeysService.class);
        this.client = client;
    }

    public UserMetricsModelInner get() {
        return (UserMetricsModelInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync().toBlocking().single()).body());
    }

    public ServiceFuture<UserMetricsModelInner> getAsync(ServiceCallback<UserMetricsModelInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(), serviceCallback);
    }

    public Observable<UserMetricsModelInner> getAsync() {
        return this.getWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<UserMetricsModelInner>, UserMetricsModelInner>(){

            public UserMetricsModelInner call(ServiceResponse<UserMetricsModelInner> response) {
                return (UserMetricsModelInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<UserMetricsModelInner>> getWithServiceResponseAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.get(this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<UserMetricsModelInner>>>(){

            public Observable<ServiceResponse<UserMetricsModelInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = TrafficManagerUserMetricsKeysInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<UserMetricsModelInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<UserMetricsModelInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public UserMetricsModelInner createOrUpdate() {
        return (UserMetricsModelInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync().toBlocking().single()).body());
    }

    public ServiceFuture<UserMetricsModelInner> createOrUpdateAsync(ServiceCallback<UserMetricsModelInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(), serviceCallback);
    }

    public Observable<UserMetricsModelInner> createOrUpdateAsync() {
        return this.createOrUpdateWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<UserMetricsModelInner>, UserMetricsModelInner>(){

            public UserMetricsModelInner call(ServiceResponse<UserMetricsModelInner> response) {
                return (UserMetricsModelInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<UserMetricsModelInner>> createOrUpdateWithServiceResponseAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.createOrUpdate(this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<UserMetricsModelInner>>>(){

            public Observable<ServiceResponse<UserMetricsModelInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = TrafficManagerUserMetricsKeysInner.this.createOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<UserMetricsModelInner> createOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(201, new TypeToken<UserMetricsModelInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public DeleteOperationResultInner delete() {
        return (DeleteOperationResultInner)((ServiceResponse)this.deleteWithServiceResponseAsync().toBlocking().single()).body();
    }

    public ServiceFuture<DeleteOperationResultInner> deleteAsync(ServiceCallback<DeleteOperationResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(), serviceCallback);
    }

    public Observable<DeleteOperationResultInner> deleteAsync() {
        return this.deleteWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<DeleteOperationResultInner>, DeleteOperationResultInner>(){

            public DeleteOperationResultInner call(ServiceResponse<DeleteOperationResultInner> response) {
                return (DeleteOperationResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<DeleteOperationResultInner>> deleteWithServiceResponseAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.delete(this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<DeleteOperationResultInner>>>(){

            public Observable<ServiceResponse<DeleteOperationResultInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = TrafficManagerUserMetricsKeysInner.this.deleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<DeleteOperationResultInner> deleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<DeleteOperationResultInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface TrafficManagerUserMetricsKeysService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.trafficmanager.TrafficManagerUserMetricsKeys get"})
        @GET(value="subscriptions/{subscriptionId}/providers/Microsoft.Network/trafficManagerUserMetricsKeys/default")
        public Observable<Response<ResponseBody>> get(@Path(value="subscriptionId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.trafficmanager.TrafficManagerUserMetricsKeys createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/providers/Microsoft.Network/trafficManagerUserMetricsKeys/default")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="subscriptionId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.trafficmanager.TrafficManagerUserMetricsKeys delete"})
        @HTTP(path="subscriptions/{subscriptionId}/providers/Microsoft.Network/trafficManagerUserMetricsKeys/default", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="subscriptionId") String var1, @Query(value="api-version") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);
    }
}

