/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.appservice.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.appservice.ManagedServiceIdentity;
import com.microsoft.azure.management.appservice.ManagedServiceIdentityType;
import com.microsoft.azure.management.appservice.ManagedServiceIdentityUserAssignedIdentitiesValue;
import com.microsoft.azure.management.appservice.SitePatchResource;
import com.microsoft.azure.management.appservice.implementation.SiteInner;
import com.microsoft.azure.management.appservice.implementation.WebAppBaseImpl;
import com.microsoft.azure.management.graphrbac.implementation.GraphRbacManager;
import com.microsoft.azure.management.graphrbac.implementation.RoleAssignmentHelper;
import com.microsoft.azure.management.msi.Identity;
import com.microsoft.azure.management.resources.fluentcore.dag.TaskGroup;
import com.microsoft.azure.management.resources.fluentcore.model.Creatable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@LangDefinition(ContainerName="/Microsoft.Azure.Management.AppService.Fluent")
public class WebAppMsiHandler
extends RoleAssignmentHelper {
    private WebAppBaseImpl webAppBase;
    private List<String> creatableIdentityKeys;
    private Map<String, ManagedServiceIdentityUserAssignedIdentitiesValue> userAssignedIdentities;

    WebAppMsiHandler(GraphRbacManager rbacManager, WebAppBaseImpl webAppBase) {
        super(rbacManager, webAppBase.taskGroup(), webAppBase.idProvider());
        this.webAppBase = webAppBase;
        this.creatableIdentityKeys = new ArrayList<String>();
        this.userAssignedIdentities = new HashMap<String, ManagedServiceIdentityUserAssignedIdentitiesValue>();
    }

    WebAppMsiHandler withLocalManagedServiceIdentity() {
        this.initSiteIdentity(ManagedServiceIdentityType.SYSTEM_ASSIGNED);
        return this;
    }

    WebAppMsiHandler withoutLocalManagedServiceIdentity() {
        SiteInner siteInner = (SiteInner)((Object)this.webAppBase.inner());
        if (siteInner.identity() == null || siteInner.identity().type() == null || siteInner.identity().type().equals((Object)ManagedServiceIdentityType.NONE) || siteInner.identity().type().equals((Object)ManagedServiceIdentityType.USER_ASSIGNED)) {
            return this;
        }
        if (siteInner.identity().type().equals((Object)ManagedServiceIdentityType.SYSTEM_ASSIGNED)) {
            siteInner.identity().withType(ManagedServiceIdentityType.NONE);
        } else if (siteInner.identity().type().equals((Object)ManagedServiceIdentityType.SYSTEM_ASSIGNED_USER_ASSIGNED)) {
            siteInner.identity().withType(ManagedServiceIdentityType.USER_ASSIGNED);
        }
        return this;
    }

    WebAppMsiHandler withNewExternalManagedServiceIdentity(Creatable<Identity> creatableIdentity) {
        this.initSiteIdentity(ManagedServiceIdentityType.USER_ASSIGNED);
        TaskGroup.HasTaskGroup dependency = (TaskGroup.HasTaskGroup)creatableIdentity;
        Objects.requireNonNull(dependency);
        this.webAppBase.taskGroup().addDependency(dependency);
        this.creatableIdentityKeys.add(creatableIdentity.key());
        return this;
    }

    WebAppMsiHandler withExistingExternalManagedServiceIdentity(Identity identity) {
        this.initSiteIdentity(ManagedServiceIdentityType.USER_ASSIGNED);
        this.userAssignedIdentities.put(identity.id(), new ManagedServiceIdentityUserAssignedIdentitiesValue());
        return this;
    }

    WebAppMsiHandler withoutExternalManagedServiceIdentity(String identityId) {
        this.userAssignedIdentities.put(identityId, null);
        return this;
    }

    void processCreatedExternalIdentities() {
        for (String key : this.creatableIdentityKeys) {
            Identity identity = (Identity)this.webAppBase.taskGroup().taskResult(key);
            Objects.requireNonNull(identity);
            this.userAssignedIdentities.put(identity.id(), new ManagedServiceIdentityUserAssignedIdentitiesValue());
        }
        this.creatableIdentityKeys.clear();
    }

    void handleExternalIdentities() {
        SiteInner siteInner = (SiteInner)((Object)this.webAppBase.inner());
        if (!this.userAssignedIdentities.isEmpty()) {
            siteInner.identity().withUserAssignedIdentities(this.userAssignedIdentities);
        }
    }

    void handleExternalIdentities(SitePatchResource siteUpdate) {
        if (this.handleRemoveAllExternalIdentitiesCase(siteUpdate)) {
            return;
        }
        SiteInner siteInner = (SiteInner)((Object)this.webAppBase.inner());
        ManagedServiceIdentity currentIdentity = siteInner.identity();
        siteUpdate.withIdentity(currentIdentity);
        if (!this.userAssignedIdentities.isEmpty()) {
            siteUpdate.identity().withUserAssignedIdentities(this.userAssignedIdentities);
        } else if (currentIdentity != null) {
            currentIdentity.withUserAssignedIdentities(null);
        }
    }

    void clear() {
        this.userAssignedIdentities = new HashMap<String, ManagedServiceIdentityUserAssignedIdentitiesValue>();
    }

    private boolean handleRemoveAllExternalIdentitiesCase(SitePatchResource siteUpdate) {
        SiteInner siteInner = (SiteInner)((Object)this.webAppBase.inner());
        if (!this.userAssignedIdentities.isEmpty()) {
            boolean containsRemoveOnly;
            int rmCount = 0;
            for (ManagedServiceIdentityUserAssignedIdentitiesValue v : this.userAssignedIdentities.values()) {
                if (v != null) break;
                ++rmCount;
            }
            boolean bl = containsRemoveOnly = rmCount > 0 && rmCount == this.userAssignedIdentities.size();
            if (containsRemoveOnly) {
                boolean bl2;
                HashSet<String> currentIds = new HashSet<String>();
                ManagedServiceIdentity currentIdentity = siteInner.identity();
                if (currentIdentity != null && currentIdentity.userAssignedIdentities() != null) {
                    for (String string : currentIdentity.userAssignedIdentities().keySet()) {
                        currentIds.add(string.toLowerCase());
                    }
                }
                HashSet<String> removeIds = new HashSet<String>();
                for (Map.Entry<String, ManagedServiceIdentityUserAssignedIdentitiesValue> entrySet : this.userAssignedIdentities.entrySet()) {
                    if (entrySet.getValue() != null) continue;
                    removeIds.add(entrySet.getKey().toLowerCase());
                }
                boolean bl3 = bl2 = currentIds.size() == removeIds.size() && currentIds.containsAll(removeIds);
                if (bl2) {
                    if (currentIdentity == null || currentIdentity.type() == null) {
                        siteUpdate.withIdentity(new ManagedServiceIdentity().withType(ManagedServiceIdentityType.NONE));
                    } else if (currentIdentity.type().equals((Object)ManagedServiceIdentityType.SYSTEM_ASSIGNED_USER_ASSIGNED)) {
                        siteUpdate.withIdentity(currentIdentity);
                        siteUpdate.identity().withType(ManagedServiceIdentityType.SYSTEM_ASSIGNED);
                    } else if (currentIdentity.type().equals((Object)ManagedServiceIdentityType.USER_ASSIGNED)) {
                        siteUpdate.withIdentity(currentIdentity);
                        siteUpdate.identity().withType(ManagedServiceIdentityType.NONE);
                    }
                    siteUpdate.identity().withUserAssignedIdentities(null);
                    return true;
                }
                if (currentIds.size() == 0 && removeIds.size() != 0 && currentIdentity == null) {
                    siteUpdate.withIdentity(new ManagedServiceIdentity().withType(ManagedServiceIdentityType.NONE));
                    siteUpdate.identity().withUserAssignedIdentities(null);
                    return true;
                }
            }
        }
        return false;
    }

    private void initSiteIdentity(ManagedServiceIdentityType identityType) {
        if (!identityType.equals((Object)ManagedServiceIdentityType.USER_ASSIGNED) && !identityType.equals((Object)ManagedServiceIdentityType.SYSTEM_ASSIGNED)) {
            throw new IllegalArgumentException("Invalid argument: " + (Object)((Object)identityType));
        }
        SiteInner siteInner = (SiteInner)((Object)this.webAppBase.inner());
        if (siteInner.identity() == null) {
            siteInner.withIdentity(new ManagedServiceIdentity());
        }
        if (siteInner.identity().type() == null || siteInner.identity().type().equals((Object)ManagedServiceIdentityType.NONE) || siteInner.identity().type().equals((Object)identityType)) {
            siteInner.identity().withType(identityType);
        } else {
            siteInner.identity().withType(ManagedServiceIdentityType.SYSTEM_ASSIGNED_USER_ASSIGNED);
        }
    }
}

