/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management;

import com.microsoft.azure.AzureEnvironment;
import com.microsoft.azure.AzureResponseBuilder;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.credentials.ApplicationTokenCredentials;
import com.microsoft.azure.credentials.AzureTokenCredentials;
import com.microsoft.azure.management.AccessManagement;
import com.microsoft.azure.management.apigeneration.Beta;
import com.microsoft.azure.management.appservice.WebApps;
import com.microsoft.azure.management.appservice.implementation.AppServiceManager;
import com.microsoft.azure.management.batch.BatchAccounts;
import com.microsoft.azure.management.batch.implementation.BatchManager;
import com.microsoft.azure.management.batchai.BatchAIUsages;
import com.microsoft.azure.management.batchai.BatchAIWorkspaces;
import com.microsoft.azure.management.batchai.implementation.BatchAIManager;
import com.microsoft.azure.management.cdn.CdnProfiles;
import com.microsoft.azure.management.cdn.implementation.CdnManager;
import com.microsoft.azure.management.compute.AvailabilitySets;
import com.microsoft.azure.management.compute.ComputeSkus;
import com.microsoft.azure.management.compute.ComputeUsages;
import com.microsoft.azure.management.compute.Disks;
import com.microsoft.azure.management.compute.Galleries;
import com.microsoft.azure.management.compute.GalleryImageVersions;
import com.microsoft.azure.management.compute.GalleryImages;
import com.microsoft.azure.management.compute.Snapshots;
import com.microsoft.azure.management.compute.VirtualMachineCustomImages;
import com.microsoft.azure.management.compute.VirtualMachineImages;
import com.microsoft.azure.management.compute.VirtualMachineScaleSets;
import com.microsoft.azure.management.compute.VirtualMachines;
import com.microsoft.azure.management.compute.implementation.ComputeManager;
import com.microsoft.azure.management.containerinstance.ContainerGroups;
import com.microsoft.azure.management.containerinstance.implementation.ContainerInstanceManager;
import com.microsoft.azure.management.containerregistry.Registries;
import com.microsoft.azure.management.containerregistry.RegistryTaskRuns;
import com.microsoft.azure.management.containerregistry.RegistryTasks;
import com.microsoft.azure.management.containerregistry.implementation.ContainerRegistryManager;
import com.microsoft.azure.management.containerservice.ContainerServices;
import com.microsoft.azure.management.containerservice.KubernetesClusters;
import com.microsoft.azure.management.containerservice.implementation.ContainerServiceManager;
import com.microsoft.azure.management.cosmosdb.CosmosDBAccounts;
import com.microsoft.azure.management.cosmosdb.implementation.CosmosDBManager;
import com.microsoft.azure.management.dns.DnsZones;
import com.microsoft.azure.management.dns.implementation.DnsZoneManager;
import com.microsoft.azure.management.eventhub.EventHubDisasterRecoveryPairings;
import com.microsoft.azure.management.eventhub.EventHubNamespaces;
import com.microsoft.azure.management.eventhub.EventHubs;
import com.microsoft.azure.management.eventhub.implementation.EventHubManager;
import com.microsoft.azure.management.graphrbac.ActiveDirectoryApplications;
import com.microsoft.azure.management.graphrbac.ActiveDirectoryGroups;
import com.microsoft.azure.management.graphrbac.ActiveDirectoryUsers;
import com.microsoft.azure.management.graphrbac.RoleAssignments;
import com.microsoft.azure.management.graphrbac.RoleDefinitions;
import com.microsoft.azure.management.graphrbac.ServicePrincipals;
import com.microsoft.azure.management.graphrbac.implementation.GraphRbacManager;
import com.microsoft.azure.management.keyvault.Vaults;
import com.microsoft.azure.management.keyvault.implementation.KeyVaultManager;
import com.microsoft.azure.management.locks.ManagementLocks;
import com.microsoft.azure.management.locks.implementation.AuthorizationManager;
import com.microsoft.azure.management.monitor.ActionGroups;
import com.microsoft.azure.management.monitor.ActivityLogs;
import com.microsoft.azure.management.monitor.AlertRules;
import com.microsoft.azure.management.monitor.AutoscaleSettings;
import com.microsoft.azure.management.monitor.DiagnosticSettings;
import com.microsoft.azure.management.monitor.MetricDefinitions;
import com.microsoft.azure.management.monitor.implementation.MonitorManager;
import com.microsoft.azure.management.msi.Identities;
import com.microsoft.azure.management.msi.implementation.MSIManager;
import com.microsoft.azure.management.network.ApplicationGateways;
import com.microsoft.azure.management.network.ApplicationSecurityGroups;
import com.microsoft.azure.management.network.DdosProtectionPlans;
import com.microsoft.azure.management.network.ExpressRouteCircuits;
import com.microsoft.azure.management.network.ExpressRouteCrossConnections;
import com.microsoft.azure.management.network.LoadBalancers;
import com.microsoft.azure.management.network.LocalNetworkGateways;
import com.microsoft.azure.management.network.NetworkInterfaces;
import com.microsoft.azure.management.network.NetworkSecurityGroups;
import com.microsoft.azure.management.network.NetworkUsages;
import com.microsoft.azure.management.network.NetworkWatchers;
import com.microsoft.azure.management.network.Networks;
import com.microsoft.azure.management.network.PublicIPAddresses;
import com.microsoft.azure.management.network.RouteFilters;
import com.microsoft.azure.management.network.RouteTables;
import com.microsoft.azure.management.network.VirtualNetworkGateways;
import com.microsoft.azure.management.network.implementation.NetworkManager;
import com.microsoft.azure.management.redis.RedisCaches;
import com.microsoft.azure.management.redis.implementation.RedisManager;
import com.microsoft.azure.management.resources.Deployments;
import com.microsoft.azure.management.resources.Features;
import com.microsoft.azure.management.resources.GenericResources;
import com.microsoft.azure.management.resources.PolicyAssignments;
import com.microsoft.azure.management.resources.PolicyDefinitions;
import com.microsoft.azure.management.resources.Providers;
import com.microsoft.azure.management.resources.ResourceGroups;
import com.microsoft.azure.management.resources.Subscription;
import com.microsoft.azure.management.resources.Subscriptions;
import com.microsoft.azure.management.resources.Tenants;
import com.microsoft.azure.management.resources.fluentcore.arm.AzureConfigurable;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.AzureConfigurableImpl;
import com.microsoft.azure.management.resources.fluentcore.utils.ProviderRegistrationInterceptor;
import com.microsoft.azure.management.resources.fluentcore.utils.ResourceManagerThrottlingInterceptor;
import com.microsoft.azure.management.resources.implementation.ResourceManager;
import com.microsoft.azure.management.search.SearchServices;
import com.microsoft.azure.management.search.implementation.SearchServiceManager;
import com.microsoft.azure.management.servicebus.ServiceBusNamespaces;
import com.microsoft.azure.management.servicebus.implementation.ServiceBusManager;
import com.microsoft.azure.management.sql.SqlServers;
import com.microsoft.azure.management.sql.implementation.SqlServerManager;
import com.microsoft.azure.management.storage.BlobContainers;
import com.microsoft.azure.management.storage.BlobServices;
import com.microsoft.azure.management.storage.ManagementPolicies;
import com.microsoft.azure.management.storage.StorageAccounts;
import com.microsoft.azure.management.storage.StorageSkus;
import com.microsoft.azure.management.storage.Usages;
import com.microsoft.azure.management.storage.implementation.StorageManager;
import com.microsoft.azure.management.trafficmanager.TrafficManagerProfiles;
import com.microsoft.azure.management.trafficmanager.implementation.TrafficManager;
import com.microsoft.azure.serializer.AzureJacksonAdapter;
import com.microsoft.rest.RestClient;
import com.microsoft.rest.credentials.ServiceClientCredentials;
import com.microsoft.rest.protocol.Environment;
import com.microsoft.rest.protocol.ResponseBuilder;
import com.microsoft.rest.protocol.SerializerAdapter;
import java.io.File;
import java.io.IOException;
import okhttp3.Interceptor;

public final class Azure {
    private final ResourceManager resourceManager;
    private final StorageManager storageManager;
    private final ComputeManager computeManager;
    private final NetworkManager networkManager;
    private final KeyVaultManager keyVaultManager;
    private final BatchManager batchManager;
    private final BatchAIManager batchAIManager;
    private final TrafficManager trafficManager;
    private final RedisManager redisManager;
    private final CdnManager cdnManager;
    private final DnsZoneManager dnsZoneManager;
    private final AppServiceManager appServiceManager;
    private final SqlServerManager sqlServerManager;
    private final ServiceBusManager serviceBusManager;
    private final ContainerInstanceManager containerInstanceManager;
    private final ContainerRegistryManager containerRegistryManager;
    private final ContainerServiceManager containerServiceManager;
    private final SearchServiceManager searchServiceManager;
    private final CosmosDBManager cosmosDBManager;
    private final AuthorizationManager authorizationManager;
    private final MSIManager msiManager;
    private final MonitorManager monitorManager;
    private final EventHubManager eventHubManager;
    private final String subscriptionId;
    private final Authenticated authenticated;

    public static Authenticated authenticate(AzureTokenCredentials credentials) {
        return new AuthenticatedImpl(new RestClient.Builder().withBaseUrl((Environment)credentials.environment(), (Environment.Endpoint)AzureEnvironment.Endpoint.RESOURCE_MANAGER).withCredentials((ServiceClientCredentials)credentials).withSerializerAdapter((SerializerAdapter)new AzureJacksonAdapter()).withResponseBuilderFactory((ResponseBuilder.Factory)new AzureResponseBuilder.Factory()).withInterceptor((Interceptor)new ProviderRegistrationInterceptor(credentials)).withInterceptor((Interceptor)new ResourceManagerThrottlingInterceptor()).build(), credentials.domain());
    }

    public static Authenticated authenticate(File credentialsFile) throws IOException {
        ApplicationTokenCredentials credentials = ApplicationTokenCredentials.fromFile((File)credentialsFile);
        return new AuthenticatedImpl(new RestClient.Builder().withBaseUrl((Environment)credentials.environment(), (Environment.Endpoint)AzureEnvironment.Endpoint.RESOURCE_MANAGER).withCredentials((ServiceClientCredentials)credentials).withSerializerAdapter((SerializerAdapter)new AzureJacksonAdapter()).withResponseBuilderFactory((ResponseBuilder.Factory)new AzureResponseBuilder.Factory()).withInterceptor((Interceptor)new ProviderRegistrationInterceptor((AzureTokenCredentials)credentials)).withInterceptor((Interceptor)new ResourceManagerThrottlingInterceptor()).build(), credentials.domain()).withDefaultSubscription(credentials.defaultSubscriptionId());
    }

    public static Authenticated authenticate(RestClient restClient, String tenantId) {
        return new AuthenticatedImpl(restClient, tenantId);
    }

    public static Authenticated authenticate(RestClient restClient, String tenantId, String subscriptionId) {
        return new AuthenticatedImpl(restClient, tenantId).withDefaultSubscription(subscriptionId);
    }

    public static Configurable configure() {
        return new ConfigurableImpl();
    }

    private Azure(RestClient restClient, String subscriptionId, String tenantId, Authenticated authenticated) {
        this.resourceManager = ResourceManager.authenticate((RestClient)restClient).withSubscription(subscriptionId);
        this.storageManager = StorageManager.authenticate((RestClient)restClient, (String)subscriptionId);
        this.computeManager = ComputeManager.authenticate((RestClient)restClient, (String)subscriptionId);
        this.networkManager = NetworkManager.authenticate((RestClient)restClient, (String)subscriptionId);
        this.keyVaultManager = KeyVaultManager.authenticate((RestClient)restClient, (String)tenantId, (String)subscriptionId);
        this.batchManager = BatchManager.authenticate((RestClient)restClient, (String)subscriptionId);
        this.batchAIManager = BatchAIManager.authenticate((RestClient)restClient, (String)subscriptionId);
        this.trafficManager = TrafficManager.authenticate((RestClient)restClient, (String)subscriptionId);
        this.redisManager = RedisManager.authenticate((RestClient)restClient, (String)subscriptionId);
        this.cdnManager = CdnManager.authenticate((RestClient)restClient, (String)subscriptionId);
        this.dnsZoneManager = DnsZoneManager.authenticate((RestClient)restClient, (String)subscriptionId);
        this.appServiceManager = AppServiceManager.authenticate((RestClient)restClient, (String)tenantId, (String)subscriptionId);
        this.sqlServerManager = SqlServerManager.authenticate((RestClient)restClient, (String)tenantId, (String)subscriptionId);
        this.serviceBusManager = ServiceBusManager.authenticate((RestClient)restClient, (String)subscriptionId);
        this.containerInstanceManager = ContainerInstanceManager.authenticate((RestClient)restClient, (String)subscriptionId);
        this.containerRegistryManager = ContainerRegistryManager.authenticate((RestClient)restClient, (String)subscriptionId);
        this.containerServiceManager = ContainerServiceManager.authenticate((RestClient)restClient, (String)subscriptionId);
        this.cosmosDBManager = CosmosDBManager.authenticate((RestClient)restClient, (String)subscriptionId);
        this.searchServiceManager = SearchServiceManager.authenticate((RestClient)restClient, (String)subscriptionId);
        this.authorizationManager = AuthorizationManager.authenticate((RestClient)restClient, (String)subscriptionId);
        this.msiManager = MSIManager.authenticate((RestClient)restClient, (String)subscriptionId);
        this.monitorManager = MonitorManager.authenticate((RestClient)restClient, (String)subscriptionId);
        this.eventHubManager = EventHubManager.authenticate((RestClient)restClient, (String)subscriptionId);
        this.subscriptionId = subscriptionId;
        this.authenticated = authenticated;
    }

    public String subscriptionId() {
        return this.subscriptionId;
    }

    public Subscription getCurrentSubscription() {
        return (Subscription)this.subscriptions().getById(this.subscriptionId());
    }

    public Subscriptions subscriptions() {
        return this.authenticated.subscriptions();
    }

    public ResourceGroups resourceGroups() {
        return this.resourceManager.resourceGroups();
    }

    public Deployments deployments() {
        return this.resourceManager.deployments();
    }

    public GenericResources genericResources() {
        return this.resourceManager.genericResources();
    }

    public ManagementLocks managementLocks() {
        return this.authorizationManager.managementLocks();
    }

    public Features features() {
        return this.resourceManager.features();
    }

    public Providers providers() {
        return this.resourceManager.providers();
    }

    public PolicyDefinitions policyDefinitions() {
        return this.resourceManager.policyDefinitions();
    }

    public PolicyAssignments policyAssignments() {
        return this.resourceManager.policyAssignments();
    }

    public StorageAccounts storageAccounts() {
        return this.storageManager.storageAccounts();
    }

    public Usages storageUsages() {
        return this.storageManager.usages();
    }

    public StorageSkus storageSkus() {
        return this.storageManager.storageSkus();
    }

    public AvailabilitySets availabilitySets() {
        return this.computeManager.availabilitySets();
    }

    public Networks networks() {
        return this.networkManager.networks();
    }

    public RouteTables routeTables() {
        return this.networkManager.routeTables();
    }

    public LoadBalancers loadBalancers() {
        return this.networkManager.loadBalancers();
    }

    public ApplicationGateways applicationGateways() {
        return this.networkManager.applicationGateways();
    }

    public NetworkSecurityGroups networkSecurityGroups() {
        return this.networkManager.networkSecurityGroups();
    }

    public NetworkUsages networkUsages() {
        return this.networkManager.usages();
    }

    public NetworkWatchers networkWatchers() {
        return this.networkManager.networkWatchers();
    }

    public VirtualNetworkGateways virtualNetworkGateways() {
        return this.networkManager.virtualNetworkGateways();
    }

    public LocalNetworkGateways localNetworkGateways() {
        return this.networkManager.localNetworkGateways();
    }

    @Beta(value=Beta.SinceVersion.V1_4_0)
    public ExpressRouteCircuits expressRouteCircuits() {
        return this.networkManager.expressRouteCircuits();
    }

    @Beta(value=Beta.SinceVersion.V1_11_0)
    public ExpressRouteCrossConnections expressRouteCrossConnections() {
        return this.networkManager.expressRouteCrossConnections();
    }

    @Beta(value=Beta.SinceVersion.V1_10_0)
    public ApplicationSecurityGroups applicationSecurityGroups() {
        return this.networkManager.applicationSecurityGroups();
    }

    @Beta(value=Beta.SinceVersion.V1_10_0)
    public RouteFilters routeFilters() {
        return this.networkManager.routeFilters();
    }

    @Beta(value=Beta.SinceVersion.V1_10_0)
    public DdosProtectionPlans ddosProtectionPlans() {
        return this.networkManager.ddosProtectionPlans();
    }

    public VirtualMachines virtualMachines() {
        return this.computeManager.virtualMachines();
    }

    public VirtualMachineScaleSets virtualMachineScaleSets() {
        return this.computeManager.virtualMachineScaleSets();
    }

    public VirtualMachineImages virtualMachineImages() {
        return this.computeManager.virtualMachineImages();
    }

    public VirtualMachineCustomImages virtualMachineCustomImages() {
        return this.computeManager.virtualMachineCustomImages();
    }

    public Disks disks() {
        return this.computeManager.disks();
    }

    public Snapshots snapshots() {
        return this.computeManager.snapshots();
    }

    public ComputeSkus computeSkus() {
        return this.computeManager.computeSkus();
    }

    public PublicIPAddresses publicIPAddresses() {
        return this.networkManager.publicIPAddresses();
    }

    public NetworkInterfaces networkInterfaces() {
        return this.networkManager.networkInterfaces();
    }

    public ComputeUsages computeUsages() {
        return this.computeManager.usages();
    }

    public Vaults vaults() {
        return this.keyVaultManager.vaults();
    }

    public BatchAccounts batchAccounts() {
        return this.batchManager.batchAccounts();
    }

    @Beta(value=Beta.SinceVersion.V1_12_0)
    public BatchAIWorkspaces batchAIWorkspaces() {
        return this.batchAIManager.workspaces();
    }

    @Beta(value=Beta.SinceVersion.V1_12_0)
    public BatchAIUsages batchAIUsages() {
        return this.batchAIManager.usages();
    }

    public TrafficManagerProfiles trafficManagerProfiles() {
        return this.trafficManager.profiles();
    }

    public RedisCaches redisCaches() {
        return this.redisManager.redisCaches();
    }

    public CdnProfiles cdnProfiles() {
        return this.cdnManager.profiles();
    }

    public DnsZones dnsZones() {
        return this.dnsZoneManager.zones();
    }

    @Beta
    public WebApps webApps() {
        return this.appServiceManager.webApps();
    }

    @Beta
    public AppServiceManager appServices() {
        return this.appServiceManager;
    }

    public SqlServers sqlServers() {
        return this.sqlServerManager.sqlServers();
    }

    @Beta
    public ServiceBusNamespaces serviceBusNamespaces() {
        return this.serviceBusManager.namespaces();
    }

    @Beta(value=Beta.SinceVersion.V1_4_0)
    public ContainerServices containerServices() {
        return this.containerServiceManager.containerServices();
    }

    @Beta(value=Beta.SinceVersion.V1_4_0)
    public KubernetesClusters kubernetesClusters() {
        return this.containerServiceManager.kubernetesClusters();
    }

    @Beta(value=Beta.SinceVersion.V1_3_0)
    public ContainerGroups containerGroups() {
        return this.containerInstanceManager.containerGroups();
    }

    @Beta(value=Beta.SinceVersion.V1_1_0)
    public Registries containerRegistries() {
        return this.containerRegistryManager.containerRegistries();
    }

    @Beta
    public RegistryTasks containerRegistryTasks() {
        return this.containerRegistryManager.containerRegistryTasks();
    }

    @Beta
    public RegistryTaskRuns containerRegistryTaskRuns() {
        return this.containerRegistryManager.registryTaskRuns();
    }

    @Beta(value=Beta.SinceVersion.V1_2_0)
    public CosmosDBAccounts cosmosDBAccounts() {
        return this.cosmosDBManager.databaseAccounts();
    }

    @Beta(value=Beta.SinceVersion.V1_2_0)
    public SearchServices searchServices() {
        return this.searchServiceManager.searchServices();
    }

    @Beta(value=Beta.SinceVersion.V1_5_1)
    public Identities identities() {
        return this.msiManager.identities();
    }

    @Beta(value=Beta.SinceVersion.V1_2_0)
    public AccessManagement accessManagement() {
        return this.authenticated;
    }

    @Beta(value=Beta.SinceVersion.V1_6_0)
    public ActivityLogs activityLogs() {
        return this.monitorManager.activityLogs();
    }

    @Beta(value=Beta.SinceVersion.V1_6_0)
    public MetricDefinitions metricDefinitions() {
        return this.monitorManager.metricDefinitions();
    }

    @Beta(value=Beta.SinceVersion.V1_8_0)
    public DiagnosticSettings diagnosticSettings() {
        return this.monitorManager.diagnosticSettings();
    }

    @Beta(value=Beta.SinceVersion.V1_9_0)
    public ActionGroups actionGroups() {
        return this.monitorManager.actionGroups();
    }

    @Beta(value=Beta.SinceVersion.V1_15_0)
    public AlertRules alertRules() {
        return this.monitorManager.alertRules();
    }

    @Beta(value=Beta.SinceVersion.V1_15_0)
    public AutoscaleSettings autoscaleSettings() {
        return this.monitorManager.autoscaleSettings();
    }

    @Beta(value=Beta.SinceVersion.V1_7_0)
    public EventHubNamespaces eventHubNamespaces() {
        return this.eventHubManager.namespaces();
    }

    @Beta(value=Beta.SinceVersion.V1_7_0)
    public EventHubs eventHubs() {
        return this.eventHubManager.eventHubs();
    }

    @Beta(value=Beta.SinceVersion.V1_7_0)
    public EventHubDisasterRecoveryPairings eventHubDisasterRecoveryPairings() {
        return this.eventHubManager.eventHubDisasterRecoveryPairings();
    }

    @Beta(value=Beta.SinceVersion.V1_15_0)
    public Galleries galleries() {
        return this.computeManager.galleries();
    }

    @Beta(value=Beta.SinceVersion.V1_15_0)
    public GalleryImages galleryImages() {
        return this.computeManager.galleryImages();
    }

    @Beta(value=Beta.SinceVersion.V1_15_0)
    public GalleryImageVersions galleryImageVersions() {
        return this.computeManager.galleryImageVersions();
    }

    public BlobContainers storageBlobContainers() {
        return this.storageManager.blobContainers();
    }

    public BlobServices storageBlobServices() {
        return this.storageManager.blobServices();
    }

    public ManagementPolicies storageManagementPolicies() {
        return this.storageManager.managementPolicies();
    }

    private static final class AuthenticatedImpl
    implements Authenticated {
        private final RestClient restClient;
        private final ResourceManager.Authenticated resourceManagerAuthenticated;
        private final GraphRbacManager graphRbacManager;
        private String defaultSubscription;
        private String tenantId;

        private AuthenticatedImpl(RestClient restClient, String tenantId) {
            this.resourceManagerAuthenticated = ResourceManager.authenticate((RestClient)restClient);
            this.graphRbacManager = GraphRbacManager.authenticate((RestClient)restClient, (String)tenantId);
            this.restClient = restClient;
            this.tenantId = tenantId;
        }

        private AuthenticatedImpl withDefaultSubscription(String subscriptionId) {
            this.defaultSubscription = subscriptionId;
            return this;
        }

        @Override
        public String tenantId() {
            return this.tenantId;
        }

        @Override
        public Subscriptions subscriptions() {
            return this.resourceManagerAuthenticated.subscriptions();
        }

        @Override
        public Tenants tenants() {
            return this.resourceManagerAuthenticated.tenants();
        }

        @Override
        public ActiveDirectoryUsers activeDirectoryUsers() {
            return this.graphRbacManager.users();
        }

        @Override
        public ActiveDirectoryGroups activeDirectoryGroups() {
            return this.graphRbacManager.groups();
        }

        @Override
        public ServicePrincipals servicePrincipals() {
            return this.graphRbacManager.servicePrincipals();
        }

        @Override
        public ActiveDirectoryApplications activeDirectoryApplications() {
            return this.graphRbacManager.applications();
        }

        @Override
        public RoleDefinitions roleDefinitions() {
            return this.graphRbacManager.roleDefinitions();
        }

        @Override
        public RoleAssignments roleAssignments() {
            return this.graphRbacManager.roleAssignments();
        }

        @Override
        public Azure withSubscription(String subscriptionId) {
            return new Azure(this.restClient, subscriptionId, this.tenantId, this);
        }

        @Override
        public Azure withDefaultSubscription() throws CloudException, IOException {
            if (this.defaultSubscription != null) {
                return this.withSubscription(this.defaultSubscription);
            }
            PagedList subs = this.subscriptions().list();
            if (!subs.isEmpty()) {
                return this.withSubscription(((Subscription)subs.get(0)).subscriptionId());
            }
            return this.withSubscription(null);
        }
    }

    public static interface Authenticated
    extends AccessManagement {
        public String tenantId();

        public Subscriptions subscriptions();

        public Tenants tenants();

        public Azure withSubscription(String var1);

        public Azure withDefaultSubscription() throws CloudException, IOException;
    }

    private static final class ConfigurableImpl
    extends AzureConfigurableImpl<Configurable>
    implements Configurable {
        private ConfigurableImpl() {
        }

        @Override
        public Authenticated authenticate(AzureTokenCredentials credentials) {
            if (credentials.defaultSubscriptionId() != null) {
                return Azure.authenticate(this.buildRestClient(credentials), credentials.domain(), credentials.defaultSubscriptionId());
            }
            return Azure.authenticate(this.buildRestClient(credentials), credentials.domain());
        }

        @Override
        public Authenticated authenticate(File credentialsFile) throws IOException {
            ApplicationTokenCredentials credentials = ApplicationTokenCredentials.fromFile((File)credentialsFile);
            return Azure.authenticate(this.buildRestClient((AzureTokenCredentials)credentials), credentials.domain(), credentials.defaultSubscriptionId());
        }
    }

    public static interface Configurable
    extends AzureConfigurable<Configurable> {
        public Authenticated authenticate(AzureTokenCredentials var1);

        public Authenticated authenticate(File var1) throws IOException;
    }
}

