/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.keyvault.authentication;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import okhttp3.HttpUrl;

class ChallengeCache {
    private final HashMap<String, Map<String, String>> cachedChallenges = new HashMap();

    ChallengeCache() {
    }

    public Map<String, String> getCachedChallenge(HttpUrl url) {
        if (url == null) {
            return null;
        }
        String authority = this.getAuthority(url);
        authority = authority.toLowerCase(Locale.ENGLISH);
        return this.cachedChallenges.get(authority);
    }

    public void addCachedChallenge(HttpUrl url, Map<String, String> challenge) {
        if (url == null || challenge == null) {
            return;
        }
        String authority = this.getAuthority(url);
        authority = authority.toLowerCase(Locale.ENGLISH);
        this.cachedChallenges.put(authority, challenge);
    }

    public String getAuthority(HttpUrl url) {
        String scheme = url.scheme();
        String host = url.host();
        int port = url.port();
        StringBuilder builder = new StringBuilder();
        if (scheme != null) {
            builder.append(scheme).append("://");
        }
        builder.append(host);
        if (port >= 0) {
            builder.append(':').append(port);
        }
        return builder.toString();
    }
}

