/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.protocol;

import org.apache.hadoop.hdds.protocol.proto.HddsProtos;

public enum StorageType {
    RAM_DISK,
    SSD,
    DISK,
    ARCHIVE;

    public static final StorageType DEFAULT;

    public HddsProtos.StorageTypeProto toProto() {
        switch (this.ordinal()) {
            case 2: {
                return HddsProtos.StorageTypeProto.DISK;
            }
            case 1: {
                return HddsProtos.StorageTypeProto.SSD;
            }
            case 3: {
                return HddsProtos.StorageTypeProto.ARCHIVE;
            }
            case 0: {
                return HddsProtos.StorageTypeProto.RAM_DISK;
            }
        }
        throw new IllegalStateException("BUG: StorageType not found, type=" + (Object)((Object)this));
    }

    public static StorageType valueOf(HddsProtos.StorageTypeProto type) {
        switch (type) {
            case DISK: {
                return DISK;
            }
            case SSD: {
                return SSD;
            }
            case ARCHIVE: {
                return ARCHIVE;
            }
            case RAM_DISK: {
                return RAM_DISK;
            }
        }
        throw new IllegalStateException("BUG: StorageTypeProto not found, type=" + type);
    }

    static {
        DEFAULT = DISK;
    }
}

