/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.services.nifi;

import java.util.HashMap;
import java.util.List;
import org.apache.ranger.plugin.service.RangerBaseService;
import org.apache.ranger.plugin.service.ResourceLookupContext;
import org.apache.ranger.services.nifi.client.NiFiClient;
import org.apache.ranger.services.nifi.client.NiFiConnectionMgr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerServiceNiFi
extends RangerBaseService {
    private static final Logger LOG = LoggerFactory.getLogger(RangerServiceNiFi.class);

    public HashMap<String, Object> validateConfig() throws Exception {
        HashMap<String, Object> ret = new HashMap();
        String serviceName = this.getServiceName();
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerServiceNiFi.validateConfig Service: (" + serviceName + " )");
        }
        if (this.configs != null) {
            try {
                ret = NiFiConnectionMgr.connectionTest(serviceName, this.configs);
            }
            catch (Exception e) {
                LOG.error("<== RangerServiceNiFi.validateConfig Error:", (Throwable)e);
                throw e;
            }
        } else {
            throw new IllegalStateException("No Configuration found");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerServiceNiFi.validateConfig Response : (" + ret + " )");
        }
        return ret;
    }

    public List<String> lookupResource(ResourceLookupContext context) throws Exception {
        NiFiClient client = NiFiConnectionMgr.getNiFiClient(this.serviceName, this.configs);
        return client.getResources(context);
    }
}

