/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.spi.type;

import com.fasterxml.jackson.annotation.JsonValue;
import io.prestosql.spi.type.DateTimeEncoding;
import io.prestosql.spi.type.TimeZoneKey;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import java.util.TimeZone;

public final class SqlTimestampWithTimeZone {
    public static final String JSON_FORMAT = "uuuu-MM-dd HH:mm:ss.SSS VV";
    private static final DateTimeFormatter JSON_FORMATTER = DateTimeFormatter.ofPattern("uuuu-MM-dd HH:mm:ss.SSS VV");
    private final long millisUtc;
    private final TimeZoneKey timeZoneKey;

    public SqlTimestampWithTimeZone(long timestampWithTimeZone) {
        this.millisUtc = DateTimeEncoding.unpackMillisUtc(timestampWithTimeZone);
        this.timeZoneKey = DateTimeEncoding.unpackZoneKey(timestampWithTimeZone);
    }

    public SqlTimestampWithTimeZone(long millisUtc, TimeZoneKey timeZoneKey) {
        this.millisUtc = millisUtc;
        this.timeZoneKey = timeZoneKey;
    }

    public SqlTimestampWithTimeZone(long millisUtc, TimeZone timeZone) {
        this.millisUtc = millisUtc;
        this.timeZoneKey = TimeZoneKey.getTimeZoneKey(timeZone.getID());
    }

    public long getMillisUtc() {
        return this.millisUtc;
    }

    public TimeZoneKey getTimeZoneKey() {
        return this.timeZoneKey;
    }

    public int hashCode() {
        return Objects.hash(this.millisUtc, this.timeZoneKey);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SqlTimestampWithTimeZone other = (SqlTimestampWithTimeZone)obj;
        return this.millisUtc == other.millisUtc && this.timeZoneKey == other.timeZoneKey;
    }

    @JsonValue
    public String toString() {
        return Instant.ofEpochMilli(this.millisUtc).atZone(ZoneId.of(this.timeZoneKey.getId())).format(JSON_FORMATTER);
    }
}

