/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authz.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.List;
import java.util.Objects;
import org.apache.ranger.authz.model.RangerAccessContext;
import org.apache.ranger.authz.model.RangerAccessInfo;
import org.apache.ranger.authz.model.RangerUserInfo;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonIgnoreProperties(ignoreUnknown=true)
public class RangerMultiAuthzRequest {
    private String requestId;
    private RangerUserInfo user;
    private List<RangerAccessInfo> accesses;
    private RangerAccessContext context;

    public RangerMultiAuthzRequest() {
    }

    public RangerMultiAuthzRequest(RangerUserInfo user, List<RangerAccessInfo> accesses, RangerAccessContext context) {
        this(null, user, accesses, context);
    }

    public RangerMultiAuthzRequest(String requestId, RangerUserInfo user, List<RangerAccessInfo> accesses, RangerAccessContext context) {
        this.requestId = requestId;
        this.user = user;
        this.accesses = accesses;
        this.context = context;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public RangerUserInfo getUser() {
        return this.user;
    }

    public void setUser(RangerUserInfo user) {
        this.user = user;
    }

    public List<RangerAccessInfo> getAccesses() {
        return this.accesses;
    }

    public void setAccesses(List<RangerAccessInfo> accesses) {
        this.accesses = accesses;
    }

    public RangerAccessContext getContext() {
        return this.context;
    }

    public void setContext(RangerAccessContext context) {
        this.context = context;
    }

    public int hashCode() {
        return Objects.hash(this.requestId, this.user, this.accesses, this.context);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RangerMultiAuthzRequest other = (RangerMultiAuthzRequest)obj;
        return Objects.equals(this.requestId, other.requestId) && Objects.equals(this.user, other.user) && Objects.equals(this.accesses, other.accesses) && Objects.equals(this.context, other.context);
    }

    public String toString() {
        return "RangerAuthzRequest{requestId='" + this.requestId + '\'' + ", user=" + this.user + ", accesses=" + this.accesses + ", context=" + this.context + '}';
    }
}

