/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.stream;

import java.io.IOException;
import org.apache.solr.client.solrj.io.stream.CsvStream;
import org.apache.solr.client.solrj.io.stream.expr.Explanation;
import org.apache.solr.client.solrj.io.stream.expr.Expressible;
import org.apache.solr.client.solrj.io.stream.expr.StreamExplanation;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class TsvStream
extends CsvStream
implements Expressible {
    private static final long serialVersionUID = 1L;

    public TsvStream(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
    }

    @Override
    public StreamExpression toExpression(StreamFactory factory) throws IOException {
        return this.toExpression(factory, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private StreamExpression toExpression(StreamFactory factory, boolean includeStreams) throws IOException {
        StreamExpression expression = new StreamExpression(factory.getFunctionName(this.getClass()));
        if (includeStreams) {
            if (!(this.originalStream instanceof Expressible)) throw new IOException("This TsvStream contains a non-expressible TupleStream - it cannot be converted to an expression");
            expression.addParameter(((Expressible)((Object)this.originalStream)).toExpression(factory));
            return expression;
        } else {
            expression.addParameter("<stream>");
        }
        return expression;
    }

    @Override
    public Explanation toExplanation(StreamFactory factory) throws IOException {
        return new StreamExplanation(this.getStreamNodeId().toString()).withChildren(new Explanation[]{this.originalStream.toExplanation(factory)}).withFunctionName(factory.getFunctionName(this.getClass())).withImplementingClass(this.getClass().getName()).withExpressionType("stream-decorator").withExpression(this.toExpression(factory, false).toString());
    }

    @Override
    protected String[] split(String line) {
        String[] parts = line.split("\\t", -1);
        return parts;
    }
}

