/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.ranger.service;

import org.apache.ranger.db.RangerDaoManager;
import org.apache.ranger.db.XXAccessTypeDefDao;
import org.apache.ranger.db.XXAccessTypeDefGrantsDao;
import org.apache.ranger.db.XXAssetDao;
import org.apache.ranger.db.XXAuditMapDao;
import org.apache.ranger.db.XXAuthSessionDao;
import org.apache.ranger.db.XXContextEnricherDefDao;
import org.apache.ranger.db.XXCredentialStoreDao;
import org.apache.ranger.db.XXDataMaskTypeDefDao;
import org.apache.ranger.db.XXEnumDefDao;
import org.apache.ranger.db.XXEnumElementDefDao;
import org.apache.ranger.db.XXGlobalStateDao;
import org.apache.ranger.db.XXGroupDao;
import org.apache.ranger.db.XXGroupGroupDao;
import org.apache.ranger.db.XXGroupPermissionDao;
import org.apache.ranger.db.XXGroupUserDao;
import org.apache.ranger.db.XXModuleDefDao;
import org.apache.ranger.db.XXPermMapDao;
import org.apache.ranger.db.XXPolicyConditionDefDao;
import org.apache.ranger.db.XXPolicyDao;
import org.apache.ranger.db.XXPolicyExportAuditDao;
import org.apache.ranger.db.XXPolicyItemAccessDao;
import org.apache.ranger.db.XXPolicyItemConditionDao;
import org.apache.ranger.db.XXPolicyItemDao;
import org.apache.ranger.db.XXPolicyItemDataMaskInfoDao;
import org.apache.ranger.db.XXPolicyItemGroupPermDao;
import org.apache.ranger.db.XXPolicyItemRowFilterInfoDao;
import org.apache.ranger.db.XXPolicyItemUserPermDao;
import org.apache.ranger.db.XXPolicyLabelDao;
import org.apache.ranger.db.XXPolicyLabelMapDao;
import org.apache.ranger.db.XXPolicyResourceDao;
import org.apache.ranger.db.XXPolicyResourceMapDao;
import org.apache.ranger.db.XXPortalUserDao;
import org.apache.ranger.db.XXPortalUserRoleDao;
import org.apache.ranger.db.XXResourceDao;
import org.apache.ranger.db.XXResourceDefDao;
import org.apache.ranger.db.XXRoleDao;
import org.apache.ranger.db.XXSecurityZoneDao;
import org.apache.ranger.db.XXServiceConfigDefDao;
import org.apache.ranger.db.XXServiceConfigMapDao;
import org.apache.ranger.db.XXServiceDao;
import org.apache.ranger.db.XXServiceDefDao;
import org.apache.ranger.db.XXServiceResourceDao;
import org.apache.ranger.db.XXTagDao;
import org.apache.ranger.db.XXTagDefDao;
import org.apache.ranger.db.XXTagResourceMapDao;
import org.apache.ranger.db.XXUgsyncAuditInfoDao;
import org.apache.ranger.db.XXUserDao;
import org.apache.ranger.db.XXUserPermissionDao;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.junit.jupiter.MockitoExtension;

import static org.mockito.Mockito.verify;
import static org.mockito.Mockito.when;

/**
 * @generated by Cursor
 * @description : Unit Test cases for XPortalUserService
 */

@ExtendWith(MockitoExtension.class)
public class TestXPortalUserService {
    @InjectMocks
    private XPortalUserService service = new XPortalUserService();

    @Mock
    private RangerDaoManager daoManager;

    // Declare needed DAOs
    @Mock private XXAssetDao                     xxAssetDao;
    @Mock private XXAuditMapDao                  xxAuditMapDao;
    @Mock private XXAuthSessionDao               xxAuthSessionDao;
    @Mock private XXCredentialStoreDao           xxCredentialStoreDao;
    @Mock private XXGroupDao                     xxGroupDao;
    @Mock private XXGroupGroupDao                xxGroupGroupDao;
    @Mock private XXGroupUserDao                 xxGroupUserDao;
    @Mock private XXPermMapDao                   xxPermMapDao;
    @Mock private XXPolicyExportAuditDao         xxPolicyExportAuditDao;
    @Mock private XXPortalUserDao                xxPortalUserDao;
    @Mock private XXPortalUserRoleDao            xxPortalUserRoleDao;
    @Mock private XXResourceDao                  xxResourceDao;
    @Mock private XXUserDao                      xxUserDao;
    @Mock private XXServiceDefDao                xxServiceDefDao;
    @Mock private XXServiceDao                   xxServiceDao;
    @Mock private XXPolicyDao                    xxPolicyDao;
    @Mock private XXServiceConfigDefDao          xxServiceConfigDefDao;
    @Mock private XXResourceDefDao               xxResourceDefDao;
    @Mock private XXAccessTypeDefDao             xxAccessTypeDefDao;
    @Mock private XXAccessTypeDefGrantsDao       xxAccessTypeDefGrantsDao;
    @Mock private XXPolicyConditionDefDao        xxPolicyConditionDefDao;
    @Mock private XXContextEnricherDefDao        xxContextEnricherDefDao;
    @Mock private XXEnumDefDao                   xxEnumDefDao;
    @Mock private XXEnumElementDefDao            xxEnumElementDefDao;
    @Mock private XXServiceConfigMapDao          xxServiceConfigMapDao;
    @Mock private XXPolicyResourceDao            xxPolicyResourceDao;
    @Mock private XXPolicyResourceMapDao         xxPolicyResourceMapDao;
    @Mock private XXPolicyItemDao                xxPolicyItemDao;
    @Mock private XXPolicyItemAccessDao          xxPolicyItemAccessDao;
    @Mock private XXPolicyItemConditionDao       xxPolicyItemConditionDao;
    @Mock private XXPolicyItemUserPermDao        xxPolicyItemUserPermDao;
    @Mock private XXPolicyItemGroupPermDao       xxPolicyItemGroupPermDao;
    @Mock private XXModuleDefDao                 xxModuleDefDao;
    @Mock private XXUserPermissionDao            xxUserPermissionDao;
    @Mock private XXGroupPermissionDao           xxGroupPermissionDao;
    @Mock private XXTagDefDao                    xxTagDefDao;
    @Mock private XXServiceResourceDao           xxServiceResourceDao;
    @Mock private XXTagDao                       xxTagDao;
    @Mock private XXTagResourceMapDao            xxTagResourceMapDao;
    @Mock private XXDataMaskTypeDefDao           xxDataMaskTypeDefDao;
    @Mock private XXPolicyItemDataMaskInfoDao    xxPolicyItemDataMaskInfoDao;
    @Mock private XXPolicyItemRowFilterInfoDao   xxPolicyItemRowFilterInfoDao;
    @Mock private XXUgsyncAuditInfoDao           xxUgsyncAuditInfoDao;
    @Mock private XXPolicyLabelDao               xxPolicyLabelDao;
    @Mock private XXPolicyLabelMapDao            xxPolicyLabelMapDao;
    @Mock private XXGlobalStateDao               xxGlobalStateDao;
    @Mock private XXSecurityZoneDao              xxSecurityZoneDao;
    @Mock private XXRoleDao                      xxRoleDao;

    @Test
    public void testUpdateXXPortalUserReferences_invokesAllDaosForAddedAndUpdatedBy() {
        long uid = 7L;
        // wire daoManager getters
        when(daoManager.getXXAsset()).thenReturn(xxAssetDao);
        when(daoManager.getXXAuditMap()).thenReturn(xxAuditMapDao);
        when(daoManager.getXXAuthSession()).thenReturn(xxAuthSessionDao);
        when(daoManager.getXXCredentialStore()).thenReturn(xxCredentialStoreDao);
        when(daoManager.getXXGroup()).thenReturn(xxGroupDao);
        when(daoManager.getXXGroupGroup()).thenReturn(xxGroupGroupDao);
        when(daoManager.getXXGroupUser()).thenReturn(xxGroupUserDao);
        when(daoManager.getXXPermMap()).thenReturn(xxPermMapDao);
        when(daoManager.getXXPolicyExportAudit()).thenReturn(xxPolicyExportAuditDao);
        when(daoManager.getXXPortalUser()).thenReturn(xxPortalUserDao);
        when(daoManager.getXXPortalUserRole()).thenReturn(xxPortalUserRoleDao);
        when(daoManager.getXXResource()).thenReturn(xxResourceDao);
        when(daoManager.getXXUser()).thenReturn(xxUserDao);
        when(daoManager.getXXServiceDef()).thenReturn(xxServiceDefDao);
        when(daoManager.getXXService()).thenReturn(xxServiceDao);
        when(daoManager.getXXPolicy()).thenReturn(xxPolicyDao);
        when(daoManager.getXXServiceConfigDef()).thenReturn(xxServiceConfigDefDao);
        when(daoManager.getXXResourceDef()).thenReturn(xxResourceDefDao);
        when(daoManager.getXXAccessTypeDef()).thenReturn(xxAccessTypeDefDao);
        when(daoManager.getXXAccessTypeDefGrants()).thenReturn(xxAccessTypeDefGrantsDao);
        when(daoManager.getXXPolicyConditionDef()).thenReturn(xxPolicyConditionDefDao);
        when(daoManager.getXXContextEnricherDef()).thenReturn(xxContextEnricherDefDao);
        when(daoManager.getXXEnumDef()).thenReturn(xxEnumDefDao);
        when(daoManager.getXXEnumElementDef()).thenReturn(xxEnumElementDefDao);
        when(daoManager.getXXServiceConfigMap()).thenReturn(xxServiceConfigMapDao);
        when(daoManager.getXXPolicyResource()).thenReturn(xxPolicyResourceDao);
        when(daoManager.getXXPolicyResourceMap()).thenReturn(xxPolicyResourceMapDao);
        when(daoManager.getXXPolicyItem()).thenReturn(xxPolicyItemDao);
        when(daoManager.getXXPolicyItemAccess()).thenReturn(xxPolicyItemAccessDao);
        when(daoManager.getXXPolicyItemCondition()).thenReturn(xxPolicyItemConditionDao);
        when(daoManager.getXXPolicyItemUserPerm()).thenReturn(xxPolicyItemUserPermDao);
        when(daoManager.getXXPolicyItemGroupPerm()).thenReturn(xxPolicyItemGroupPermDao);
        when(daoManager.getXXModuleDef()).thenReturn(xxModuleDefDao);
        when(daoManager.getXXUserPermission()).thenReturn(xxUserPermissionDao);
        when(daoManager.getXXGroupPermission()).thenReturn(xxGroupPermissionDao);
        when(daoManager.getXXTagDef()).thenReturn(xxTagDefDao);
        when(daoManager.getXXServiceResource()).thenReturn(xxServiceResourceDao);
        when(daoManager.getXXTag()).thenReturn(xxTagDao);
        when(daoManager.getXXTagResourceMap()).thenReturn(xxTagResourceMapDao);
        when(daoManager.getXXDataMaskTypeDef()).thenReturn(xxDataMaskTypeDefDao);
        when(daoManager.getXXPolicyItemDataMaskInfo()).thenReturn(xxPolicyItemDataMaskInfoDao);
        when(daoManager.getXXPolicyItemRowFilterInfo()).thenReturn(xxPolicyItemRowFilterInfoDao);
        when(daoManager.getXXUgsyncAuditInfo()).thenReturn(xxUgsyncAuditInfoDao);
        when(daoManager.getXXPolicyLabels()).thenReturn(xxPolicyLabelDao);
        when(daoManager.getXXPolicyLabelMap()).thenReturn(xxPolicyLabelMapDao);
        when(daoManager.getXXGlobalState()).thenReturn(xxGlobalStateDao);
        when(daoManager.getXXSecurityZoneDao()).thenReturn(xxSecurityZoneDao);
        when(daoManager.getXXRole()).thenReturn(xxRoleDao);

        service.updateXXPortalUserReferences(uid);

        // verify that at least a couple of representative DAOs are called for both columns
        verify(xxAssetDao).updateUserIDReference("added_by_id", uid);
        verify(xxAssetDao).updateUserIDReference("upd_by_id", uid);
        verify(xxPortalUserDao).updateUserIDReference("added_by_id", uid);
        verify(xxPortalUserDao).updateUserIDReference("upd_by_id", uid);
        verify(xxServiceDefDao).updateUserIDReference("added_by_id", uid);
        verify(xxServiceDefDao).updateUserIDReference("upd_by_id", uid);
        verify(xxPolicyDao).updateUserIDReference("added_by_id", uid);
        verify(xxPolicyDao).updateUserIDReference("upd_by_id", uid);
        // Note: security zone ref and role ref tables no longer have audit fields
    }
}
