/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.utils;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HdfsNameServiceResolver {
    private static final Logger LOG = LoggerFactory.getLogger(HdfsNameServiceResolver.class);
    public static final String HDFS_SCHEME = "hdfs://";
    private static final int DEFAULT_PORT = 8020;
    private static final String HDFS_NAMESERVICE_PROPERTY_KEY = "dfs.nameservices";
    private static final String HDFS_INTERNAL_NAMESERVICE_PROPERTY_KEY = "dfs.internal.nameservices";
    private static final String HDFS_NAMENODES_HA_NODES_PREFIX = "dfs.ha.namenodes.";
    private static final String HDFS_NAMENODE_HA_ADDRESS_TEMPLATE = "dfs.namenode.rpc-address.%s.%s";
    private static final String HDFS_NAMENODE_ADDRESS_TEMPLATE = "dfs.namenode.rpc-address.%s";
    private static final Map<String, String> hostToNameServiceMap = new HashMap<String, String>();

    public static String getPathWithNameServiceID(String path) {
        URI uri;
        String nsId;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> HdfsNameServiceResolver.getPathWithNameServiceID({})", (Object)path);
        }
        String ret = path;
        if (path != null && path.indexOf(HDFS_SCHEME) == 0 && (nsId = (uri = new Path(path).toUri()).getPort() != -1 ? hostToNameServiceMap.get(uri.getAuthority()) : hostToNameServiceMap.get(uri.getHost() + ":" + 8020)) != null) {
            ret = StringUtils.replaceOnce((String)path, (String)uri.getAuthority(), (String)nsId);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== HdfsNameServiceResolver.getPathWithNameServiceID({}) = {}", (Object)path, (Object)ret);
        }
        return ret;
    }

    public static String getNameServiceIDForPath(String path) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> HdfsNameServiceResolver.getNameServiceIDForPath({})", (Object)path);
        }
        String ret = "";
        if (path != null && path.indexOf(HDFS_SCHEME) == 0) {
            try {
                URI uri = new Path(path).toUri();
                if (uri != null) {
                    if (uri.getPort() != -1) {
                        ret = HdfsNameServiceResolver.getNameServiceID(uri.getHost(), uri.getPort());
                    } else {
                        ret = HdfsNameServiceResolver.getNameServiceID(uri.getHost(), 8020);
                        if (StringUtils.isEmpty((String)ret) && hostToNameServiceMap.containsValue(uri.getHost())) {
                            ret = uri.getHost();
                        }
                    }
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== HdfsNameServiceResolver.getNameServiceIDForPath({}) = {}", (Object)path, (Object)ret);
        }
        return ret;
    }

    private static String getNameServiceID(String host, int port) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> HdfsNameServiceResolver.getNameServiceID({}, {})", (Object)host, (Object)port);
        }
        String ret = hostToNameServiceMap.getOrDefault(host + ":" + port, "");
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== HdfsNameServiceResolver.getNameServiceID({}, {}) = {}", new Object[]{host, port, ret});
        }
        return ret;
    }

    private static void init() {
        HdfsConfiguration hdfsConfiguration;
        Object[] nameServiceIDs;
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> HdfsNameServiceResolver.init()");
        }
        if (Objects.isNull(nameServiceIDs = (hdfsConfiguration = new HdfsConfiguration(true)).getTrimmedStrings(HDFS_INTERNAL_NAMESERVICE_PROPERTY_KEY)) || nameServiceIDs.length == 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("NSID not found for {}, looking under {}", (Object)HDFS_INTERNAL_NAMESERVICE_PROPERTY_KEY, (Object)HDFS_NAMESERVICE_PROPERTY_KEY);
            }
            nameServiceIDs = hdfsConfiguration.getTrimmedStrings(HDFS_NAMESERVICE_PROPERTY_KEY);
        }
        if (Objects.nonNull(nameServiceIDs) && nameServiceIDs.length > 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("NSIDs = {}", nameServiceIDs);
            }
            for (Object nameServiceID : nameServiceIDs) {
                String nameNodeAddress;
                String nameNodeMappingKey;
                boolean isHA;
                String[] nameNodes = hdfsConfiguration.getTrimmedStrings(HDFS_NAMENODES_HA_NODES_PREFIX + (String)nameServiceID);
                boolean bl = isHA = nameNodes != null && nameNodes.length > 0;
                if (isHA) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Processing HA node info");
                    }
                    for (String nameNode : nameNodes) {
                        nameNodeMappingKey = String.format(HDFS_NAMENODE_HA_ADDRESS_TEMPLATE, nameServiceID, nameNode);
                        nameNodeAddress = hdfsConfiguration.get(nameNodeMappingKey, "");
                        if (!StringUtils.isNotEmpty((String)nameNodeAddress)) continue;
                        hostToNameServiceMap.put(nameNodeAddress, (String)nameServiceID);
                    }
                    continue;
                }
                nameNodeMappingKey = String.format(HDFS_NAMENODE_ADDRESS_TEMPLATE, nameServiceID);
                nameNodeAddress = hdfsConfiguration.get(nameNodeMappingKey, "");
                if (!StringUtils.isNotEmpty((String)nameNodeAddress)) continue;
                hostToNameServiceMap.put(nameNodeAddress, (String)nameServiceID);
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("No NSID could be resolved");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== HdfsNameServiceResolver.init()");
        }
    }

    static {
        HdfsNameServiceResolver.init();
    }
}

