/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.service;

import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.atlas.annotation.AtlasService;
import org.apache.atlas.service.Service;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Profile;

@AtlasService
@Profile(value={"!test"})
public class Services {
    public static final Logger LOG = LoggerFactory.getLogger(Services.class);
    private static final String DATA_MIGRATION_CLASS_NAME_DEFAULT = "DataMigrationService";
    private static final String FILE_EXTENSION_ZIP = ".zip";
    private final List<Service> services;
    private final String dataMigrationClassName;
    private final boolean servicesEnabled;
    private final String migrationDirName;
    private final boolean migrationEnabled;

    @Inject
    public Services(List<Service> services, Configuration configuration) {
        this.services = services;
        this.dataMigrationClassName = configuration.getString("atlas.migration.class.name", DATA_MIGRATION_CLASS_NAME_DEFAULT);
        this.servicesEnabled = configuration.getBoolean("atlas.services.enabled", true);
        this.migrationDirName = configuration.getString("atlas.migration.data.filename");
        this.migrationEnabled = StringUtils.isNotEmpty((String)this.migrationDirName);
    }

    @PostConstruct
    public void start() {
        try {
            for (Service svc : this.services) {
                if (!this.isServiceUsed(svc)) continue;
                LOG.info("Starting service {}", (Object)svc.getClass().getName());
                svc.start();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @PreDestroy
    public void stop() {
        for (int idx = this.services.size() - 1; idx >= 0; --idx) {
            Service svc = this.services.get(idx);
            try {
                if (!this.isServiceUsed(svc)) continue;
                LOG.info("Stopping service {}", (Object)svc.getClass().getName());
                svc.stop();
                continue;
            }
            catch (Throwable e) {
                LOG.warn("Error stopping service {}", (Object)svc.getClass().getName(), (Object)e);
            }
        }
    }

    private boolean isServiceUsed(Service service) {
        if (this.isDataMigrationService(service)) {
            return this.migrationEnabled;
        }
        if (this.isZipFileMigration()) {
            return this.isNeededForZipFileMigration(service);
        }
        return !this.migrationEnabled && this.servicesEnabled;
    }

    private boolean isZipFileMigration() {
        return this.migrationEnabled && StringUtils.endsWithIgnoreCase((String)this.migrationDirName, (String)FILE_EXTENSION_ZIP);
    }

    private boolean isNeededForZipFileMigration(Service svc) {
        return svc.getClass().getSuperclass().getSimpleName().equals("AbstractStorageBasedAuditRepository") || svc.getClass().getSuperclass().getSimpleName().equals("AbstractNotification") || svc.getClass().getSimpleName().equals("AtlasPatchService");
    }

    private boolean isDataMigrationService(Service svc) {
        return svc.getClass().getSimpleName().equals(this.dataMigrationClassName);
    }
}

