/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.ha;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;

public final class HAConfiguration {
    public static final String ATLAS_SERVER_ZK_ROOT_DEFAULT = "/apache_atlas";
    public static final String ATLAS_SERVER_HA_PREFIX = "atlas.server.ha.";
    public static final String ZOOKEEPER_PREFIX = "zookeeper.";
    public static final String ATLAS_SERVER_HA_ZK_ROOT_KEY = "atlas.server.ha.zookeeper.zkroot";
    public static final String ATLAS_SERVER_HA_ENABLED_KEY = "atlas.server.ha.enabled";
    public static final String ATLAS_SERVER_ADDRESS_PREFIX = "atlas.server.address.";
    public static final String ATLAS_SERVER_IDS = "atlas.server.ids";
    public static final String HA_ZOOKEEPER_CONNECT = "atlas.server.ha.zookeeper.connect";
    public static final int DEFAULT_ZOOKEEPER_CONNECT_SLEEPTIME_MILLIS = 1000;
    public static final String HA_ZOOKEEPER_RETRY_SLEEPTIME_MILLIS = "atlas.server.ha.zookeeper.retry.sleeptime.ms";
    public static final String HA_ZOOKEEPER_NUM_RETRIES = "atlas.server.ha.zookeeper.num.retries";
    public static final int DEFAULT_ZOOKEEPER_CONNECT_NUM_RETRIES = 3;
    public static final String HA_ZOOKEEPER_SESSION_TIMEOUT_MS = "atlas.server.ha.zookeeper.session.timeout.ms";
    public static final int DEFAULT_ZOOKEEPER_SESSION_TIMEOUT_MILLIS = 20000;
    public static final String HA_ZOOKEEPER_ACL = "atlas.server.ha.zookeeper.acl";
    public static final String HA_ZOOKEEPER_AUTH = "atlas.server.ha.zookeeper.auth";

    private HAConfiguration() {
    }

    public static boolean isHAEnabled(Configuration configuration) {
        String[] ids;
        boolean ret = false;
        ret = configuration.containsKey(ATLAS_SERVER_HA_ENABLED_KEY) ? configuration.getBoolean(ATLAS_SERVER_HA_ENABLED_KEY) : (ids = configuration.getStringArray(ATLAS_SERVER_IDS)) != null && ids.length > 1;
        return ret;
    }

    public static String getBoundAddressForId(Configuration configuration, String serverId) {
        String hostPort = configuration.getString(ATLAS_SERVER_ADDRESS_PREFIX + serverId);
        boolean isSecure = configuration.getBoolean("atlas.enableTLS");
        String protocol = isSecure ? "https://" : "http://";
        return protocol + hostPort;
    }

    public static List<String> getServerInstances(Configuration configuration) {
        String[] serverIds = configuration.getStringArray(ATLAS_SERVER_IDS);
        ArrayList<String> serverInstances = new ArrayList<String>(serverIds.length);
        for (String serverId : serverIds) {
            serverInstances.add(HAConfiguration.getBoundAddressForId(configuration, serverId));
        }
        return serverInstances;
    }

    public static ZookeeperProperties getZookeeperProperties(Configuration configuration) {
        Object[] zkServers = configuration.containsKey(HA_ZOOKEEPER_CONNECT) ? configuration.getStringArray(HA_ZOOKEEPER_CONNECT) : configuration.getStringArray("atlas.kafka.zookeeper.connect");
        String zkRoot = configuration.getString(ATLAS_SERVER_HA_ZK_ROOT_KEY, ATLAS_SERVER_ZK_ROOT_DEFAULT);
        int retriesSleepTimeMillis = configuration.getInt(HA_ZOOKEEPER_RETRY_SLEEPTIME_MILLIS, 1000);
        int numRetries = configuration.getInt(HA_ZOOKEEPER_NUM_RETRIES, 3);
        int sessionTimeout = configuration.getInt(HA_ZOOKEEPER_SESSION_TIMEOUT_MS, 20000);
        String acl = configuration.getString(HA_ZOOKEEPER_ACL);
        String auth = configuration.getString(HA_ZOOKEEPER_AUTH);
        return new ZookeeperProperties(StringUtils.join((Object[])zkServers, (char)','), zkRoot, retriesSleepTimeMillis, numRetries, sessionTimeout, acl, auth);
    }

    public static class ZookeeperProperties {
        private String connectString;
        private String zkRoot;
        private int retriesSleepTimeMillis;
        private int numRetries;
        private int sessionTimeout;
        private String acl;
        private String auth;

        public ZookeeperProperties(String connectString, String zkRoot, int retriesSleepTimeMillis, int numRetries, int sessionTimeout, String acl, String auth) {
            this.connectString = connectString;
            this.zkRoot = zkRoot;
            this.retriesSleepTimeMillis = retriesSleepTimeMillis;
            this.numRetries = numRetries;
            this.sessionTimeout = sessionTimeout;
            this.acl = acl;
            this.auth = auth;
        }

        public String getConnectString() {
            return this.connectString;
        }

        public int getRetriesSleepTimeMillis() {
            return this.retriesSleepTimeMillis;
        }

        public int getNumRetries() {
            return this.numRetries;
        }

        public int getSessionTimeout() {
            return this.sessionTimeout;
        }

        public String getAcl() {
            return this.acl;
        }

        public String getAuth() {
            return this.auth;
        }

        public String getZkRoot() {
            return this.zkRoot;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ZookeeperProperties that = (ZookeeperProperties)o;
            return this.retriesSleepTimeMillis == that.retriesSleepTimeMillis && this.numRetries == that.numRetries && this.sessionTimeout == that.sessionTimeout && Objects.equals(this.connectString, that.connectString) && Objects.equals(this.zkRoot, that.zkRoot) && Objects.equals(this.acl, that.acl) && Objects.equals(this.auth, that.auth);
        }

        public int hashCode() {
            return Objects.hash(this.connectString, this.zkRoot, this.retriesSleepTimeMillis, this.numRetries, this.sessionTimeout, this.acl, this.auth);
        }

        public boolean hasAcl() {
            return this.getAcl() != null;
        }

        public boolean hasAuth() {
            return this.getAuth() != null;
        }
    }
}

