/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas;

import java.util.Arrays;
import org.apache.atlas.ApplicationProperties;
import org.apache.atlas.AtlasClient;
import org.apache.atlas.AtlasException;
import org.apache.atlas.AtlasServiceException;
import org.apache.atlas.model.metrics.AtlasMetrics;
import org.apache.atlas.type.AtlasType;
import org.apache.atlas.utils.AuthenticationUtil;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.configuration.Configuration;

public class AtlasAdminClient {
    private static final Option STATUS = new Option("status", false, "Get the status of an atlas instance");
    private static final Option STATS = new Option("stats", false, "Get the metrics of an atlas instance");
    private static final Option CREDENTIALS = new Option("u", true, "Authorized atlas user credentials (<user>:<password>)");
    private static final Options OPTIONS = new Options();
    private static final int INVALID_OPTIONS_STATUS = 1;
    private static final int PROGRAM_ERROR_STATUS = -1;

    public static void main(String[] args) throws AtlasException, ParseException {
        AtlasAdminClient atlasAdminClient = new AtlasAdminClient();
        int result = atlasAdminClient.run(args);
        System.exit(result);
    }

    private int run(String[] args) throws AtlasException {
        CommandLine commandLine = this.parseCommandLineOptions(args);
        Configuration configuration = ApplicationProperties.get();
        String[] atlasServerUri = configuration.getStringArray("atlas.rest.address");
        if (atlasServerUri == null || atlasServerUri.length == 0) {
            atlasServerUri = new String[]{"http://localhost:21000"};
        }
        return this.handleCommand(commandLine, atlasServerUri);
    }

    private int handleCommand(CommandLine commandLine, String[] atlasServerUri) throws AtlasException {
        String[] providedUserPassword = this.getUserPassword(commandLine);
        int cmdStatus = -1;
        if (commandLine.hasOption(STATUS.getOpt())) {
            AtlasClient atlasClient = this.initAtlasClient(atlasServerUri, providedUserPassword);
            try {
                System.out.println(atlasClient.getAdminStatus());
                cmdStatus = 0;
            }
            catch (AtlasServiceException e) {
                System.err.println("Could not retrieve status of the server at " + Arrays.toString(atlasServerUri));
                this.printStandardHttpErrorDetails(e);
            }
        } else if (commandLine.hasOption(STATS.getOpt())) {
            AtlasClient atlasClient = this.initAtlasClient(atlasServerUri, providedUserPassword);
            try {
                AtlasMetrics atlasMetrics = atlasClient.getAtlasMetrics();
                String json = AtlasType.toJson((Object)atlasMetrics);
                System.out.println(json);
                cmdStatus = 0;
            }
            catch (AtlasServiceException e) {
                System.err.println("Could not retrieve metrics of the server at " + Arrays.toString(atlasServerUri));
                this.printStandardHttpErrorDetails(e);
            }
        } else {
            System.err.println("Unsupported option. Refer to usage for valid options.");
            this.printUsage();
        }
        return cmdStatus;
    }

    private String[] getUserPassword(CommandLine commandLine) {
        String value;
        String[] basicAuthUsernamePassword = null;
        if (commandLine.hasOption(CREDENTIALS.getOpt()) && (value = commandLine.getOptionValue(CREDENTIALS.getOpt())) != null) {
            basicAuthUsernamePassword = value.split(":");
        }
        if (basicAuthUsernamePassword == null || basicAuthUsernamePassword.length != 2) {
            System.err.println("Invalid credentials. Format: <user>:<password>");
        }
        return basicAuthUsernamePassword;
    }

    private AtlasClient initAtlasClient(String[] atlasServerUri, String[] providedUserNamePassword) throws AtlasException {
        AtlasClient atlasClient = !AuthenticationUtil.isKerberosAuthenticationEnabled() ? (providedUserNamePassword == null || providedUserNamePassword.length < 2 ? new AtlasClient(atlasServerUri, AuthenticationUtil.getBasicAuthenticationInput()) : new AtlasClient(atlasServerUri, providedUserNamePassword)) : new AtlasClient(atlasServerUri);
        return atlasClient;
    }

    private void printStandardHttpErrorDetails(AtlasServiceException e) {
        System.err.println("Error details: ");
        System.err.println("HTTP Status: " + e.getStatus().getStatusCode() + "," + e.getStatus().getReasonPhrase());
        System.err.println("Exception message: " + e.getMessage());
    }

    private CommandLine parseCommandLineOptions(String[] args) {
        if (args.length == 0) {
            this.printUsage();
        }
        GnuParser parser = new GnuParser();
        CommandLine commandLine = null;
        try {
            commandLine = parser.parse(OPTIONS, args);
        }
        catch (ParseException e) {
            System.err.println("Could not parse command line options. " + e.getMessage());
            this.printUsage();
        }
        return commandLine;
    }

    private void printUsage() {
        HelpFormatter helpFormatter = new HelpFormatter();
        helpFormatter.printHelp("atlas_admin.py", OPTIONS);
        System.exit(1);
    }

    static {
        OPTIONS.addOption(STATUS);
        OPTIONS.addOption(STATS);
        OPTIONS.addOption(CREDENTIALS);
    }
}

