/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.notification.spool;

import java.io.File;
import org.apache.atlas.notification.spool.SpoolUtils;
import org.apache.commons.configuration.Configuration;

public class SpoolConfiguration {
    private static final int PROP_RETRY_DESTINATION_MS_DEFAULT = 30000;
    private static final int PROP_FILE_ROLLOVER_SEC_DEFAULT = 60;
    private static final int PROP_FILE_SPOOL_ARCHIVE_MAX_FILES_COUNT_DEFAULT = 100;
    private static final int PROP_PAUSE_BEFORE_SEND_MS_DEFAULT = 60;
    private static final String PROP_FILE_SPOOL_ARCHIVE_DIR_DEFAULT = "archive";
    private static final String PROP_FILE_SPOOL_LOCAL_DIR_DEFAULT = "/tmp/spool";
    private static final int PROP_FILE_MESSAGE_BATCH_SIZE_DEFAULT = 100;
    private static final String PROP_HIVE_METASTORE_NAME_DEFAULT = "HiveMetastoreHookImpl";
    private static final String PROPERTY_PREFIX_SPOOL = "atlas.hook.spool.";
    public static final String PROP_FILE_SPOOL_LOCAL_DIR = "atlas.hook.spool.dir";
    private static final String PROP_FILE_SPOOL_ARCHIVE_DIR = "atlas.hook.spool.archive.dir";
    private static final String PROP_FILE_SPOOL_ARCHIVE_MAX_FILES_COUNT = "atlas.hook.spool.archive.max.files";
    public static final String PROP_FILE_SPOOL_FILE_ROLLOVER_SEC = "atlas.hook.spool.file.rollover.sec";
    public static final String PROP_FILE_SPOOL_DEST_RETRY_MS = "atlas.hook.spool.destination.retry.ms";
    private static final String PROP_MESSAGE_BATCH_SIZE = "atlas.hook.spool.destination.message.batchsize";
    public static final String PROP_FILE_SPOOL_PAUSE_BEFORE_SEND_SEC = "atlas.hook.spool.pause.before.send.sec";
    private static final String PROP_HIVE_METASTORE_NAME = "atlas.hook.spool.hivemetastore.name";
    private final Configuration config;
    private final String messageHandlerName;
    private final int maxArchivedFilesCount;
    private final int messageBatchSize;
    private final int retryDestinationMS;
    private final int fileRollOverSec;
    private final int fileSpoolMaxFilesCount;
    private String spoolDirPath;
    private String archiveDir;
    private final int pauseBeforeSendSec;
    private final String hiveMetaStoreName;
    private String sourceName;
    private String user;

    public SpoolConfiguration(Configuration cfg, String messageHandlerName) {
        this.config = cfg;
        this.messageHandlerName = messageHandlerName;
        this.maxArchivedFilesCount = cfg.getInt(PROP_FILE_SPOOL_ARCHIVE_MAX_FILES_COUNT, 100);
        this.messageBatchSize = cfg.getInt(PROP_MESSAGE_BATCH_SIZE, 100);
        this.retryDestinationMS = cfg.getInt(PROP_FILE_SPOOL_DEST_RETRY_MS, 30000);
        this.pauseBeforeSendSec = cfg.getInt(PROP_FILE_SPOOL_PAUSE_BEFORE_SEND_SEC, 60);
        this.fileRollOverSec = cfg.getInt(PROP_FILE_SPOOL_FILE_ROLLOVER_SEC, 60) * 1000;
        this.fileSpoolMaxFilesCount = cfg.getInt(PROP_FILE_SPOOL_ARCHIVE_MAX_FILES_COUNT, 100);
        this.spoolDirPath = cfg.getString(PROP_FILE_SPOOL_LOCAL_DIR, PROP_FILE_SPOOL_LOCAL_DIR_DEFAULT);
        this.archiveDir = cfg.getString(PROP_FILE_SPOOL_ARCHIVE_DIR, new File(this.getSpoolDirPath(), PROP_FILE_SPOOL_ARCHIVE_DIR_DEFAULT).toString());
        this.hiveMetaStoreName = cfg.getString(PROP_HIVE_METASTORE_NAME, PROP_HIVE_METASTORE_NAME_DEFAULT);
    }

    public void setSource(String source, String user) {
        this.sourceName = source;
        this.user = user;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public int getMaxArchiveFiles() {
        return this.maxArchivedFilesCount;
    }

    public int getRetryDestinationMS() {
        return this.retryDestinationMS;
    }

    public int getFileRolloverSec() {
        return this.fileRollOverSec;
    }

    public int getFileSpoolMaxFilesCount() {
        return this.fileSpoolMaxFilesCount;
    }

    public String getSpoolDirPath() {
        return this.spoolDirPath;
    }

    public File getSpoolDir() {
        return new File(this.getSpoolDirPath());
    }

    public void setSpoolDir(String absolutePath) {
        this.spoolDirPath = absolutePath;
    }

    public File getArchiveDir() {
        this.archiveDir = this.config.getString(PROP_FILE_SPOOL_ARCHIVE_DIR, new File(this.getSpoolDirPath(), PROP_FILE_SPOOL_ARCHIVE_DIR_DEFAULT).toString());
        return new File(this.archiveDir);
    }

    public String getMessageHandlerName() {
        return this.messageHandlerName;
    }

    public int getMessageBatchSize() {
        return this.messageBatchSize;
    }

    public File getIndexFile() {
        String fileName = SpoolUtils.getIndexFileName(this.getSourceName(), this.getMessageHandlerName());
        return new File(this.getSpoolDir(), fileName);
    }

    public File getIndexDoneFile() {
        String fileName = SpoolUtils.getIndexFileName(this.getSourceName(), this.getMessageHandlerName());
        String fileDoneName = SpoolUtils.getIndexDoneFile(fileName);
        return new File(this.getSpoolDir(), fileDoneName);
    }

    public File getIndexPublishFile() {
        String fileName = SpoolUtils.getIndexFileName(this.getSourceName(), this.getMessageHandlerName());
        String fileDoneName = SpoolUtils.getIndexPublishFile(fileName);
        return new File(this.getSpoolDir(), fileDoneName);
    }

    public int getPauseBeforeSendSec() {
        return this.pauseBeforeSendSec;
    }

    public boolean isHiveMetaStore() {
        return this.sourceName.equals(this.hiveMetaStoreName);
    }

    public String getUser() {
        return this.user;
    }
}

