/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.model.glossary;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.atlas.model.annotation.AtlasJSON;
import org.apache.atlas.model.glossary.AtlasGlossaryBaseObject;
import org.apache.atlas.model.glossary.AtlasGlossaryCategory;
import org.apache.atlas.model.glossary.AtlasGlossaryTerm;
import org.apache.atlas.model.glossary.relations.AtlasRelatedCategoryHeader;
import org.apache.atlas.model.glossary.relations.AtlasRelatedTermHeader;
import org.apache.commons.collections.CollectionUtils;

@AtlasJSON
public class AtlasGlossary
extends AtlasGlossaryBaseObject {
    private String language;
    private String usage;
    private Set<AtlasRelatedTermHeader> terms;
    private Set<AtlasRelatedCategoryHeader> categories;

    public AtlasGlossary() {
    }

    public AtlasGlossary(AtlasGlossary other) {
        super(other);
        super.setQualifiedName(other.getQualifiedName());
        super.setGuid(other.getGuid());
        super.setName(other.name);
        super.setShortDescription(other.shortDescription);
        super.setLongDescription(other.longDescription);
        this.language = other.language;
        this.usage = other.usage;
        this.terms = other.terms;
        this.categories = other.categories;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getUsage() {
        return this.usage;
    }

    public void setUsage(String usage) {
        this.usage = usage;
    }

    public Set<AtlasRelatedCategoryHeader> getCategories() {
        return this.categories;
    }

    public void setCategories(Set<AtlasRelatedCategoryHeader> categories) {
        this.categories = categories;
    }

    public Set<AtlasRelatedTermHeader> getTerms() {
        return this.terms;
    }

    public void setTerms(Set<AtlasRelatedTermHeader> terms) {
        this.terms = terms;
    }

    @Override
    @JsonIgnore
    public void setAttribute(String attrName, String attrVal) {
        Objects.requireNonNull(attrName, "AtlasGlossary attribute name");
        switch (attrName) {
            case "name": {
                this.setName(attrVal);
                break;
            }
            case "shortDescription": {
                this.setShortDescription(attrVal);
                break;
            }
            case "longDescription": {
                this.setLongDescription(attrVal);
                break;
            }
            case "language": {
                this.setLanguage(attrVal);
                break;
            }
            case "usage": {
                this.setUsage(attrVal);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid attribute '" + attrName + "' for object AtlasGlossary");
            }
        }
    }

    @JsonIgnore
    public void addTerm(AtlasRelatedTermHeader relatedTermId) {
        Set<AtlasRelatedTermHeader> terms = this.terms;
        if (terms == null) {
            terms = new HashSet<AtlasRelatedTermHeader>();
        }
        terms.add(relatedTermId);
        this.setTerms(terms);
    }

    @JsonIgnore
    public void addCategory(AtlasRelatedCategoryHeader relatedCategoryId) {
        Set<AtlasRelatedCategoryHeader> categories = this.categories;
        if (categories == null) {
            categories = new HashSet<AtlasRelatedCategoryHeader>();
        }
        categories.add(relatedCategoryId);
        this.setCategories(categories);
    }

    @JsonIgnore
    public void removeTerm(AtlasRelatedTermHeader relatedTermId) {
        if (CollectionUtils.isNotEmpty(this.terms)) {
            this.terms.remove(relatedTermId);
        }
    }

    @JsonIgnore
    public void removeCategory(AtlasRelatedCategoryHeader relatedCategoryId) {
        if (CollectionUtils.isNotEmpty(this.categories)) {
            this.categories.remove(relatedCategoryId);
        }
    }

    @Override
    protected StringBuilder toString(StringBuilder sb) {
        sb.append(", language='").append(this.language).append('\'');
        sb.append(", usage='").append(this.usage).append('\'');
        sb.append(", terms=").append(this.terms);
        sb.append(", categories=").append(this.categories);
        return sb;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AtlasGlossary)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AtlasGlossary glossary = (AtlasGlossary)o;
        return Objects.equals(this.language, glossary.language) && Objects.equals(this.usage, glossary.usage) && Objects.equals(this.terms, glossary.terms) && Objects.equals(this.categories, glossary.categories);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.language, this.usage, this.terms, this.categories);
    }

    @AtlasJSON
    public static class AtlasGlossaryExtInfo
    extends AtlasGlossary {
        private Map<String, AtlasGlossaryTerm> termInfo;
        private Map<String, AtlasGlossaryCategory> categoryInfo;

        public AtlasGlossaryExtInfo() {
        }

        public AtlasGlossaryExtInfo(AtlasGlossary glossary) {
            super(glossary);
        }

        public Map<String, AtlasGlossaryTerm> getTermInfo() {
            return this.termInfo;
        }

        public void addTermInfo(AtlasGlossaryTerm term) {
            if (this.termInfo == null) {
                this.termInfo = new HashMap<String, AtlasGlossaryTerm>();
            }
            this.termInfo.put(term.getGuid(), term);
        }

        public void setTermInfo(Map<String, AtlasGlossaryTerm> termInfo) {
            this.termInfo = termInfo;
        }

        public Map<String, AtlasGlossaryCategory> getCategoryInfo() {
            return this.categoryInfo;
        }

        public void addCategoryInfo(AtlasGlossaryCategory category) {
            if (this.categoryInfo == null) {
                this.categoryInfo = new HashMap<String, AtlasGlossaryCategory>();
            }
            this.categoryInfo.put(category.getGuid(), category);
        }

        public void setCategoryInfo(Map<String, AtlasGlossaryCategory> categoryInfo) {
            this.categoryInfo = categoryInfo;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof AtlasGlossaryExtInfo)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            AtlasGlossaryExtInfo that = (AtlasGlossaryExtInfo)o;
            return Objects.equals(this.termInfo, that.termInfo) && Objects.equals(this.categoryInfo, that.categoryInfo);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.termInfo, this.categoryInfo);
        }

        @Override
        public StringBuilder toString(StringBuilder sb) {
            sb.append(", termInfo=").append(this.termInfo);
            sb.append(", categoryInfo=").append(this.categoryInfo);
            return sb;
        }
    }
}

