/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.get;

import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.apache.lucene.util.CollectionUtil;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.cluster.metadata.AliasMetadata;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentParserUtils;

public class GetIndexResponse
extends ActionResponse
implements ToXContentObject {
    private ImmutableOpenMap<String, ImmutableOpenMap<String, MappingMetadata>> mappings = ImmutableOpenMap.of();
    private ImmutableOpenMap<String, List<AliasMetadata>> aliases = ImmutableOpenMap.of();
    private ImmutableOpenMap<String, Settings> settings = ImmutableOpenMap.of();
    private ImmutableOpenMap<String, Settings> defaultSettings = ImmutableOpenMap.of();
    private ImmutableOpenMap<String, String> dataStreams = ImmutableOpenMap.of();
    private final String[] indices;

    public GetIndexResponse(String[] indices, ImmutableOpenMap<String, ImmutableOpenMap<String, MappingMetadata>> mappings, ImmutableOpenMap<String, List<AliasMetadata>> aliases, ImmutableOpenMap<String, Settings> settings, ImmutableOpenMap<String, Settings> defaultSettings, ImmutableOpenMap<String, String> dataStreams) {
        this.indices = indices;
        Arrays.sort(indices);
        if (mappings != null) {
            this.mappings = mappings;
        }
        if (aliases != null) {
            this.aliases = aliases;
        }
        if (settings != null) {
            this.settings = settings;
        }
        if (defaultSettings != null) {
            this.defaultSettings = defaultSettings;
        }
        if (dataStreams != null) {
            this.dataStreams = dataStreams;
        }
    }

    GetIndexResponse(StreamInput in) throws IOException {
        super(in);
        this.indices = in.readStringArray();
        int mappingsSize = in.readVInt();
        ImmutableOpenMap.Builder mappingsMapBuilder = ImmutableOpenMap.builder();
        for (int i = 0; i < mappingsSize; ++i) {
            String key = in.readString();
            int valueSize = in.readVInt();
            ImmutableOpenMap.Builder<String, MappingMetadata> mappingEntryBuilder = ImmutableOpenMap.builder();
            for (int j = 0; j < valueSize; ++j) {
                mappingEntryBuilder.put(in.readString(), new MappingMetadata(in));
            }
            mappingsMapBuilder.put(key, mappingEntryBuilder.build());
        }
        this.mappings = mappingsMapBuilder.build();
        int aliasesSize = in.readVInt();
        ImmutableOpenMap.Builder aliasesMapBuilder = ImmutableOpenMap.builder();
        for (int i = 0; i < aliasesSize; ++i) {
            String key = in.readString();
            int valueSize = in.readVInt();
            ArrayList<AliasMetadata> aliasEntryBuilder = new ArrayList<AliasMetadata>(valueSize);
            for (int j = 0; j < valueSize; ++j) {
                aliasEntryBuilder.add(new AliasMetadata(in));
            }
            aliasesMapBuilder.put(key, Collections.unmodifiableList(aliasEntryBuilder));
        }
        this.aliases = aliasesMapBuilder.build();
        int settingsSize = in.readVInt();
        ImmutableOpenMap.Builder<String, Settings> settingsMapBuilder = ImmutableOpenMap.builder();
        for (int i = 0; i < settingsSize; ++i) {
            String key = in.readString();
            settingsMapBuilder.put(key, Settings.readSettingsFromStream(in));
        }
        this.settings = settingsMapBuilder.build();
        ImmutableOpenMap.Builder<String, Settings> defaultSettingsMapBuilder = ImmutableOpenMap.builder();
        int defaultSettingsSize = in.readVInt();
        for (int i = 0; i < defaultSettingsSize; ++i) {
            defaultSettingsMapBuilder.put(in.readString(), Settings.readSettingsFromStream(in));
        }
        this.defaultSettings = defaultSettingsMapBuilder.build();
        if (in.getVersion().onOrAfter(Version.V_7_8_0)) {
            ImmutableOpenMap.Builder<String, String> dataStreamsMapBuilder = ImmutableOpenMap.builder();
            int dataStreamsSize = in.readVInt();
            for (int i = 0; i < dataStreamsSize; ++i) {
                dataStreamsMapBuilder.put(in.readString(), in.readOptionalString());
            }
            this.dataStreams = dataStreamsMapBuilder.build();
        }
    }

    public String[] indices() {
        return this.indices;
    }

    public String[] getIndices() {
        return this.indices();
    }

    public ImmutableOpenMap<String, ImmutableOpenMap<String, MappingMetadata>> mappings() {
        return this.mappings;
    }

    public ImmutableOpenMap<String, ImmutableOpenMap<String, MappingMetadata>> getMappings() {
        return this.mappings();
    }

    public ImmutableOpenMap<String, List<AliasMetadata>> aliases() {
        return this.aliases;
    }

    public ImmutableOpenMap<String, List<AliasMetadata>> getAliases() {
        return this.aliases();
    }

    public ImmutableOpenMap<String, Settings> settings() {
        return this.settings;
    }

    public ImmutableOpenMap<String, String> dataStreams() {
        return this.dataStreams;
    }

    public ImmutableOpenMap<String, String> getDataStreams() {
        return this.dataStreams();
    }

    public ImmutableOpenMap<String, Settings> defaultSettings() {
        return this.defaultSettings;
    }

    public ImmutableOpenMap<String, Settings> getSettings() {
        return this.settings();
    }

    public String getSetting(String index, String setting) {
        Settings indexSettings = this.settings.get(index);
        if (setting != null) {
            if (indexSettings != null && indexSettings.hasValue(setting)) {
                return indexSettings.get(setting);
            }
            Settings defaultIndexSettings = this.defaultSettings.get(index);
            if (defaultIndexSettings != null) {
                return defaultIndexSettings.get(setting);
            }
            return null;
        }
        return null;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeStringArray(this.indices);
        out.writeVInt(this.mappings.size());
        for (ObjectObjectCursor<String, ImmutableOpenMap<String, MappingMetadata>> objectObjectCursor : this.mappings) {
            out.writeString((String)objectObjectCursor.key);
            out.writeVInt(((ImmutableOpenMap)objectObjectCursor.value).size());
            for (ObjectObjectCursor mappingEntry : (ImmutableOpenMap)objectObjectCursor.value) {
                out.writeString((String)mappingEntry.key);
                ((MappingMetadata)mappingEntry.value).writeTo(out);
            }
        }
        out.writeVInt(this.aliases.size());
        for (ObjectObjectCursor objectObjectCursor : this.aliases) {
            out.writeString((String)objectObjectCursor.key);
            out.writeVInt(((List)objectObjectCursor.value).size());
            for (AliasMetadata aliasEntry : (List)objectObjectCursor.value) {
                aliasEntry.writeTo(out);
            }
        }
        out.writeVInt(this.settings.size());
        for (ObjectObjectCursor objectObjectCursor : this.settings) {
            out.writeString((String)objectObjectCursor.key);
            Settings.writeSettingsToStream((Settings)objectObjectCursor.value, out);
        }
        out.writeVInt(this.defaultSettings.size());
        for (ObjectObjectCursor objectObjectCursor : this.defaultSettings) {
            out.writeString((String)objectObjectCursor.key);
            Settings.writeSettingsToStream((Settings)objectObjectCursor.value, out);
        }
        if (out.getVersion().onOrAfter(Version.V_7_8_0)) {
            out.writeVInt(this.dataStreams.size());
            for (ObjectObjectCursor objectObjectCursor : this.dataStreams) {
                out.writeString((String)objectObjectCursor.key);
                out.writeOptionalString((String)objectObjectCursor.value);
            }
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        for (String index : this.indices) {
            String string;
            builder.startObject(index);
            builder.startObject("aliases");
            List<AliasMetadata> indexAliases = this.aliases.get(index);
            if (indexAliases != null) {
                for (AliasMetadata alias : indexAliases) {
                    AliasMetadata.Builder.toXContent(alias, builder, params);
                }
            }
            builder.endObject();
            ImmutableOpenMap<String, MappingMetadata> indexMappings = this.mappings.get(index);
            boolean includeTypeName = params.paramAsBoolean("include_type_name", false);
            if (includeTypeName) {
                builder.startObject("mappings");
                if (indexMappings != null) {
                    for (ObjectObjectCursor<String, MappingMetadata> objectObjectCursor : indexMappings) {
                        builder.field((String)objectObjectCursor.key);
                        builder.map(((MappingMetadata)objectObjectCursor.value).sourceAsMap());
                    }
                }
                builder.endObject();
            } else {
                MappingMetadata mappings = null;
                for (ObjectObjectCursor<String, MappingMetadata> objectObjectCursor : indexMappings) {
                    if (((String)objectObjectCursor.key).equals("_default_")) continue;
                    assert (mappings == null);
                    mappings = (MappingMetadata)objectObjectCursor.value;
                }
                if (mappings == null) {
                    builder.startObject("mappings").endObject();
                } else {
                    builder.field("mappings", mappings.sourceAsMap());
                }
            }
            builder.startObject("settings");
            Settings indexSettings = this.settings.get(index);
            if (indexSettings != null) {
                indexSettings.toXContent(builder, params);
            }
            builder.endObject();
            Settings settings = this.defaultSettings.get(index);
            if (settings != null && !settings.isEmpty()) {
                builder.startObject("defaults");
                settings.toXContent(builder, params);
                builder.endObject();
            }
            if ((string = this.dataStreams.get(index)) != null) {
                builder.field("data_stream", string);
            }
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    private static List<AliasMetadata> parseAliases(XContentParser parser) throws IOException {
        ArrayList<AliasMetadata> indexAliases = new ArrayList<AliasMetadata>();
        while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            XContentParserUtils.ensureExpectedToken(XContentParser.Token.FIELD_NAME, parser.currentToken(), parser);
            indexAliases.add(AliasMetadata.Builder.fromXContent(parser));
        }
        return indexAliases;
    }

    private static ImmutableOpenMap<String, MappingMetadata> parseMappings(XContentParser parser) throws IOException {
        ImmutableOpenMap.Builder<String, MappingMetadata> indexMappings = ImmutableOpenMap.builder();
        while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            XContentParserUtils.ensureExpectedToken(XContentParser.Token.FIELD_NAME, parser.currentToken(), parser);
            parser.nextToken();
            if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
                String mappingType = parser.currentName();
                indexMappings.put(mappingType, new MappingMetadata(mappingType, parser.map()));
                continue;
            }
            if (parser.currentToken() != XContentParser.Token.START_ARRAY) continue;
            parser.skipChildren();
        }
        return indexMappings.build();
    }

    private static IndexEntry parseIndexEntry(XContentParser parser) throws IOException {
        List<AliasMetadata> indexAliases = null;
        ImmutableOpenMap<String, MappingMetadata> indexMappings = null;
        Settings indexSettings = null;
        Settings indexDefaultSettings = null;
        String dataStream = null;
        block12: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            XContentParserUtils.ensureExpectedToken(XContentParser.Token.FIELD_NAME, parser.currentToken(), parser);
            parser.nextToken();
            if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
                switch (parser.currentName()) {
                    case "aliases": {
                        indexAliases = GetIndexResponse.parseAliases(parser);
                        continue block12;
                    }
                    case "mappings": {
                        indexMappings = GetIndexResponse.parseMappings(parser);
                        continue block12;
                    }
                    case "settings": {
                        indexSettings = Settings.fromXContent(parser);
                        continue block12;
                    }
                    case "defaults": {
                        indexDefaultSettings = Settings.fromXContent(parser);
                        continue block12;
                    }
                }
                parser.skipChildren();
                continue;
            }
            if (parser.currentToken() == XContentParser.Token.VALUE_STRING) {
                if (parser.currentName().equals("data_stream")) {
                    dataStream = parser.text();
                }
                parser.skipChildren();
                continue;
            }
            if (parser.currentToken() != XContentParser.Token.START_ARRAY) continue;
            parser.skipChildren();
        }
        return new IndexEntry(indexAliases, indexMappings, indexSettings, indexDefaultSettings, dataStream);
    }

    public static GetIndexResponse fromXContent(XContentParser parser) throws IOException {
        ImmutableOpenMap.Builder<String, List<AliasMetadata>> aliases = ImmutableOpenMap.builder();
        ImmutableOpenMap.Builder<String, ImmutableOpenMap<String, MappingMetadata>> mappings = ImmutableOpenMap.builder();
        ImmutableOpenMap.Builder<String, Settings> settings = ImmutableOpenMap.builder();
        ImmutableOpenMap.Builder<String, Settings> defaultSettings = ImmutableOpenMap.builder();
        ImmutableOpenMap.Builder<String, String> dataStreams = ImmutableOpenMap.builder();
        ArrayList<String> indices = new ArrayList<String>();
        if (parser.currentToken() == null) {
            parser.nextToken();
        }
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.currentToken(), parser);
        parser.nextToken();
        while (!parser.isClosed()) {
            if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
                String indexName = parser.currentName();
                indices.add(indexName);
                IndexEntry indexEntry = GetIndexResponse.parseIndexEntry(parser);
                CollectionUtil.timSort(indexEntry.indexAliases, Comparator.comparing(AliasMetadata::alias));
                aliases.put(indexName, Collections.unmodifiableList(indexEntry.indexAliases));
                mappings.put(indexName, indexEntry.indexMappings);
                settings.put(indexName, indexEntry.indexSettings);
                if (!indexEntry.indexDefaultSettings.isEmpty()) {
                    defaultSettings.put(indexName, indexEntry.indexDefaultSettings);
                }
                if (indexEntry.dataStream == null) continue;
                dataStreams.put(indexName, indexEntry.dataStream);
                continue;
            }
            if (parser.currentToken() == XContentParser.Token.START_ARRAY) {
                parser.skipChildren();
                continue;
            }
            parser.nextToken();
        }
        return new GetIndexResponse(indices.toArray(new String[0]), mappings.build(), aliases.build(), settings.build(), defaultSettings.build(), dataStreams.build());
    }

    public String toString() {
        return Strings.toString((ToXContent)this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetIndexResponse that = (GetIndexResponse)o;
        return Arrays.equals(this.indices, that.indices) && Objects.equals(this.aliases, that.aliases) && Objects.equals(this.mappings, that.mappings) && Objects.equals(this.settings, that.settings) && Objects.equals(this.defaultSettings, that.defaultSettings) && Objects.equals(this.dataStreams, that.dataStreams);
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.indices), this.aliases, this.mappings, this.settings, this.defaultSettings, this.dataStreams);
    }

    private static class IndexEntry {
        List<AliasMetadata> indexAliases = new ArrayList<AliasMetadata>();
        ImmutableOpenMap<String, MappingMetadata> indexMappings = ImmutableOpenMap.of();
        Settings indexSettings = Settings.EMPTY;
        Settings indexDefaultSettings = Settings.EMPTY;
        String dataStream;

        IndexEntry(List<AliasMetadata> indexAliases, ImmutableOpenMap<String, MappingMetadata> indexMappings, Settings indexSettings, Settings indexDefaultSettings, String dataStream) {
            if (indexAliases != null) {
                this.indexAliases = indexAliases;
            }
            if (indexMappings != null) {
                this.indexMappings = indexMappings;
            }
            if (indexSettings != null) {
                this.indexSettings = indexSettings;
            }
            if (indexDefaultSettings != null) {
                this.indexDefaultSettings = indexDefaultSettings;
            }
            if (dataStream != null) {
                this.dataStream = dataStream;
            }
        }
    }
}

