/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store.berkeleydb.tuple;

import com.sleepycat.je.DatabaseEntry;
import java.util.UUID;
import org.apache.qpid.server.store.berkeleydb.entry.QueueEntryKey;
import org.apache.qpid.server.util.CachingUUIDFactory;

public class QueueEntryBinding {
    private QueueEntryBinding() {
    }

    public static QueueEntryKey entryToObject(CachingUUIDFactory uuidFactory, DatabaseEntry entry) {
        byte[] data = entry.getData();
        int offset = entry.getOffset();
        UUID queueId = uuidFactory.createUuidFromBits(QueueEntryBinding.readUnsignedLong(data, offset) ^ Long.MIN_VALUE, QueueEntryBinding.readUnsignedLong(data, offset + 8) ^ Long.MIN_VALUE);
        long messageId = QueueEntryBinding.readUnsignedLong(data, offset + 16) ^ Long.MIN_VALUE;
        return new QueueEntryKey(queueId, messageId);
    }

    public static void objectToEntry(QueueEntryKey entryKey, DatabaseEntry entry) {
        byte[] output = new byte[24];
        UUID uuid = entryKey.getQueueId();
        QueueEntryBinding.writeUnsignedLong(uuid.getMostSignificantBits() ^ Long.MIN_VALUE, output, 0);
        QueueEntryBinding.writeUnsignedLong(uuid.getLeastSignificantBits() ^ Long.MIN_VALUE, output, 8);
        QueueEntryBinding.writeUnsignedLong(entryKey.getMessageId() ^ Long.MIN_VALUE, output, 16);
        entry.setData(output);
    }

    private static void writeUnsignedLong(long val, byte[] data, int offset) {
        data[offset++] = (byte)(val >>> 56);
        data[offset++] = (byte)(val >>> 48);
        data[offset++] = (byte)(val >>> 40);
        data[offset++] = (byte)(val >>> 32);
        data[offset++] = (byte)(val >>> 24);
        data[offset++] = (byte)(val >>> 16);
        data[offset++] = (byte)(val >>> 8);
        data[offset] = (byte)val;
    }

    private static long readUnsignedLong(byte[] data, int offset) {
        return ((long)data[offset++] & 0xFFL) << 56 | ((long)data[offset++] & 0xFFL) << 48 | ((long)data[offset++] & 0xFFL) << 40 | ((long)data[offset++] & 0xFFL) << 32 | ((long)data[offset++] & 0xFFL) << 24 | ((long)data[offset++] & 0xFFL) << 16 | ((long)data[offset++] & 0xFFL) << 8 | (long)data[offset] & 0xFFL;
    }
}

