/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0.type.transaction;

import org.apache.qpid.server.protocol.v1_0.type.ErrorCondition;
import org.apache.qpid.server.protocol.v1_0.type.RestrictedType;
import org.apache.qpid.server.protocol.v1_0.type.Symbol;

public class TransactionError
implements ErrorCondition,
RestrictedType<Symbol> {
    private final Symbol _val;
    public static final TransactionError UNKNOWN_ID = new TransactionError(Symbol.valueOf("amqp:transaction:unknown-id"));
    public static final TransactionError TRANSACTION_ROLLBACK = new TransactionError(Symbol.valueOf("amqp:transaction:rollback"));
    public static final TransactionError TRANSACTION_TIMEOUT = new TransactionError(Symbol.valueOf("amqp:transaction:timeout"));

    private TransactionError(Symbol val) {
        this._val = val;
    }

    @Override
    public Symbol getValue() {
        return this._val;
    }

    public String toString() {
        if (this == UNKNOWN_ID) {
            return "unknown-id";
        }
        if (this == TRANSACTION_ROLLBACK) {
            return "transaction-rollback";
        }
        if (this == TRANSACTION_TIMEOUT) {
            return "transaction-timeout";
        }
        return String.valueOf(this._val);
    }

    public static TransactionError valueOf(Object obj) {
        if (obj instanceof Symbol) {
            Symbol val = (Symbol)obj;
            if (TransactionError.UNKNOWN_ID._val.equals(val)) {
                return UNKNOWN_ID;
            }
            if (TransactionError.TRANSACTION_ROLLBACK._val.equals(val)) {
                return TRANSACTION_ROLLBACK;
            }
            if (TransactionError.TRANSACTION_TIMEOUT._val.equals(val)) {
                return TRANSACTION_TIMEOUT;
            }
        }
        String message = String.format("Cannot convert '%s' into 'transaction-error'", obj);
        throw new IllegalArgumentException(message);
    }
}

