/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_8;

import java.lang.ref.SoftReference;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.protocol.v0_8.AMQPInvalidClassException;
import org.apache.qpid.server.protocol.v0_8.AMQShortString;
import org.apache.qpid.server.protocol.v0_8.AMQType;
import org.apache.qpid.server.protocol.v0_8.AMQTypeMap;
import org.apache.qpid.server.protocol.v0_8.AMQTypedValue;
import org.apache.qpid.server.protocol.v0_8.EncodingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldTable {
    private static final Logger LOGGER = LoggerFactory.getLogger(FieldTable.class);
    private static final String STRICT_AMQP_NAME = "_strictAMQP";
    static boolean _strictAMQP = Boolean.valueOf(System.getProperty("_strictAMQP", "false"));
    private final FieldTableSupport _fieldTableSupport;

    FieldTable(QpidByteBuffer input, int len) {
        QpidByteBuffer encodedForm = input.view(0, len);
        input.position(input.position() + len);
        this._fieldTableSupport = new ByteBufferFieldTableSupport(encodedForm);
    }

    FieldTable(QpidByteBuffer buffer) {
        this._fieldTableSupport = new ByteBufferFieldTableSupport(buffer.duplicate());
    }

    FieldTable(Map<String, Object> properties) {
        Map m = properties != null && !properties.isEmpty() ? (Map)properties.entrySet().stream().peek(e -> FieldTable.checkPropertyName((String)e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, e -> FieldTable.getAMQTypeValue(e.getValue()), (x, y) -> y, LinkedHashMap::new)) : Collections.emptyMap();
        this._fieldTableSupport = new MapFieldTableSupport(m);
    }

    FieldTable(FieldTableSupport fieldTableSupport) {
        this._fieldTableSupport = new MapFieldTableSupport(fieldTableSupport.getAsMap());
    }

    private static AMQTypedValue getAMQTypeValue(Object object) throws AMQPInvalidClassException {
        if (object == null) {
            return AMQType.VOID.asTypedValue(null);
        }
        if (object instanceof Boolean) {
            return AMQType.BOOLEAN.asTypedValue(object);
        }
        if (object instanceof Byte) {
            return AMQType.BYTE.asTypedValue(object);
        }
        if (object instanceof Short) {
            return AMQType.SHORT.asTypedValue(object);
        }
        if (object instanceof Integer) {
            return AMQTypedValue.createAMQTypedValue((Integer)object);
        }
        if (object instanceof Long) {
            return AMQTypedValue.createAMQTypedValue((Long)object);
        }
        if (object instanceof Float) {
            return AMQType.FLOAT.asTypedValue(object);
        }
        if (object instanceof Double) {
            return AMQType.DOUBLE.asTypedValue(object);
        }
        if (object instanceof String) {
            return AMQType.LONG_STRING.asTypedValue(object);
        }
        if (object instanceof Character) {
            return AMQType.ASCII_CHARACTER.asTypedValue(object);
        }
        if (object instanceof FieldTable) {
            return AMQType.FIELD_TABLE.asTypedValue(object);
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            return AMQType.FIELD_TABLE.asTypedValue(FieldTable.convertToFieldTable(map));
        }
        if (object instanceof Collection) {
            return AMQType.FIELD_ARRAY.asTypedValue(object);
        }
        if (object instanceof Date) {
            return AMQType.TIMESTAMP.asTypedValue(((Date)object).getTime());
        }
        if (object instanceof BigDecimal) {
            BigDecimal decimal = (BigDecimal)object;
            if (decimal.longValue() > Integer.MAX_VALUE) {
                throw new UnsupportedOperationException(String.format("AMQP does not support decimals larger than %d", Integer.MAX_VALUE));
            }
            if (decimal.scale() > 127) {
                throw new UnsupportedOperationException(String.format("AMQP does not support decimal scales larger than %d", (byte)127));
            }
            return AMQType.DECIMAL.asTypedValue(decimal);
        }
        if (object instanceof byte[]) {
            return AMQType.BINARY.asTypedValue(object);
        }
        if (object instanceof UUID) {
            return AMQType.LONG_STRING.asTypedValue(object.toString());
        }
        throw new AMQPInvalidClassException("Only Primitive objects allowed. Object is: " + String.valueOf(object.getClass()));
    }

    public String toString() {
        return this._fieldTableSupport.toString();
    }

    private static void checkPropertyName(String propertyName) {
        if (propertyName == null) {
            throw new IllegalArgumentException("Property name must not be null");
        }
        if (propertyName.length() == 0) {
            throw new IllegalArgumentException("Property name must not be the empty string");
        }
        if (_strictAMQP) {
            FieldTable.checkIdentiferFormat(propertyName);
        }
    }

    private static void checkIdentiferFormat(String propertyName) {
        if (propertyName.length() > 128) {
            throw new IllegalArgumentException("AMQP limits property names to 128 characters");
        }
        if (!Character.isLetter(propertyName.charAt(0)) && propertyName.charAt(0) != '$' && propertyName.charAt(0) != '#' && propertyName.charAt(0) != '_') {
            throw new IllegalArgumentException("Identifier '" + propertyName + "' does not start with a valid AMQP start character");
        }
    }

    public void writeToBuffer(QpidByteBuffer buffer) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("FieldTable::writeToBuffer: Writing encoded length of " + this.getEncodedSize() + "...");
            if (this._fieldTableSupport instanceof MapFieldTableSupport) {
                LOGGER.debug(this._fieldTableSupport.toString());
            }
        }
        buffer.putUnsignedInt(this.getEncodedSize());
        this._fieldTableSupport.writeToBuffer(buffer);
    }

    public byte[] getDataAsBytes() {
        return this._fieldTableSupport.getAsBytes();
    }

    public long getEncodedSize() {
        return this._fieldTableSupport.getEncodedSize();
    }

    private static long recalculateEncodedSize(Map<String, AMQTypedValue> properties) {
        long size = 0L;
        for (Map.Entry<String, AMQTypedValue> e : properties.entrySet()) {
            String key = e.getKey();
            AMQTypedValue value = e.getValue();
            size += (long)(EncodingUtils.encodedShortStringLength(key) + 1 + value.getEncodingSize());
        }
        return size;
    }

    public static Map<String, Object> convertToMap(FieldTable fieldTable) {
        if (fieldTable != null) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            Map<String, AMQTypedValue> properties = fieldTable.getProperties();
            if (properties != null) {
                for (Map.Entry<String, AMQTypedValue> e : properties.entrySet()) {
                    Map<String, Object> val = e.getValue().getValue();
                    if (val instanceof AMQShortString) {
                        val = val.toString();
                    } else if (val instanceof FieldTable) {
                        val = FieldTable.convertToMap((FieldTable)((Object)val));
                    }
                    map.put(e.getKey(), val);
                }
            }
            return map;
        }
        return Collections.emptyMap();
    }

    public void dispose() {
        this._fieldTableSupport.dispose();
    }

    public int size() {
        return this.getProperties().size();
    }

    public boolean isEmpty() {
        return this.getEncodedSize() > 0L;
    }

    public boolean containsKey(String key) {
        return this._fieldTableSupport.containsKey(key);
    }

    public Set<String> keys() {
        return new LinkedHashSet<String>(this.getProperties().keySet());
    }

    public Object get(String key) {
        FieldTable.checkPropertyName(key);
        return this._fieldTableSupport.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldTable that = (FieldTable)o;
        return this._fieldTableSupport.equals(that._fieldTableSupport);
    }

    public int hashCode() {
        return this._fieldTableSupport.hashCode();
    }

    private Map<String, AMQTypedValue> getProperties() {
        return this._fieldTableSupport.getAsMap();
    }

    public static FieldTable convertToFieldTable(Map<String, Object> map) {
        if (map != null) {
            return new FieldTable(map);
        }
        return null;
    }

    public static FieldTable convertToDecodedFieldTable(FieldTable fieldTable) {
        if (fieldTable == null) {
            return null;
        }
        return new FieldTable(fieldTable._fieldTableSupport);
    }

    public void validate() {
        this._fieldTableSupport.validate();
    }

    static class ByteBufferFieldTableSupport
    implements FieldTableSupport {
        private static final AMQTypedValue NOT_PRESENT = AMQType.VOID.asTypedValue(null);
        private final QpidByteBuffer _encodedForm;
        private volatile SoftReference<Map<String, AMQTypedValue>> _cache;

        ByteBufferFieldTableSupport(QpidByteBuffer encodedForm) {
            this._encodedForm = encodedForm;
            this._cache = new SoftReference(new LinkedHashMap());
        }

        @Override
        public synchronized long getEncodedSize() {
            return this._encodedForm.remaining();
        }

        @Override
        public synchronized Object get(String key) {
            AMQTypedValue value = this.getValue(key);
            if (value != null && value != NOT_PRESENT) {
                return value.getValue();
            }
            return null;
        }

        @Override
        public boolean containsKey(String key) {
            AMQTypedValue value = this.getValue(key);
            return value != null && value != NOT_PRESENT;
        }

        @Override
        public synchronized void writeToBuffer(QpidByteBuffer buffer) {
            byte[] encodedCopy = new byte[this._encodedForm.remaining()];
            this._encodedForm.copyTo(encodedCopy);
            buffer.put(encodedCopy);
        }

        @Override
        public synchronized byte[] getAsBytes() {
            byte[] encodedCopy = new byte[this._encodedForm.remaining()];
            this._encodedForm.copyTo(encodedCopy);
            return encodedCopy;
        }

        @Override
        public Map<String, AMQTypedValue> getAsMap() {
            return this.decode();
        }

        @Override
        public synchronized void dispose() {
            if (this._encodedForm != null) {
                this._encodedForm.dispose();
                this._cache.clear();
            }
        }

        @Override
        public void validate() {
            this.decode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ByteBufferFieldTableSupport that = (ByteBufferFieldTableSupport)o;
            return this._encodedForm.equals(that._encodedForm);
        }

        public int hashCode() {
            return this._encodedForm.hashCode();
        }

        public String toString() {
            return this.getAsMap().toString();
        }

        private synchronized AMQTypedValue getValue(String key) {
            AMQTypedValue value = null;
            Map<String, AMQTypedValue> properties = this._cache.get();
            if (properties == null) {
                this._cache = new SoftReference(new LinkedHashMap());
                properties = this._cache.get();
            }
            if (properties != null) {
                value = properties.get(key);
            }
            if (value == null) {
                value = this.findValueForKey(key);
                if (value == null) {
                    value = NOT_PRESENT;
                }
                if (properties != null) {
                    properties.put(key, value);
                }
            }
            return value;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private AMQTypedValue findValueForKey(String key) {
            byte[] keyBytes = key.getBytes(StandardCharsets.UTF_8);
            this._encodedForm.mark();
            try {
                while (this._encodedForm.hasRemaining()) {
                    byte[] bytes = AMQShortString.readAMQShortStringAsBytes(this._encodedForm);
                    if (Arrays.equals(keyBytes, bytes)) {
                        AMQTypedValue aMQTypedValue = AMQTypedValue.readFromBuffer(this._encodedForm);
                        return aMQTypedValue;
                    }
                    AMQType type = AMQTypeMap.getType(this._encodedForm.get());
                    type.skip(this._encodedForm);
                }
            }
            finally {
                this._encodedForm.reset();
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized Map<String, AMQTypedValue> decode() {
            HashMap<String, AMQTypedValue> properties = new HashMap<String, AMQTypedValue>();
            long encodedSize = this.getEncodedSize();
            if (encodedSize > 0L) {
                this._encodedForm.mark();
                try {
                    do {
                        String key = AMQShortString.readAMQShortStringAsString(this._encodedForm);
                        FieldTable.checkPropertyName(key);
                        AMQTypedValue value = AMQTypedValue.readFromBuffer(this._encodedForm);
                        properties.put(key, value);
                    } while (this._encodedForm.hasRemaining());
                }
                finally {
                    this._encodedForm.reset();
                }
                long recalculateEncodedSize = FieldTable.recalculateEncodedSize(properties);
                if (encodedSize != recalculateEncodedSize) {
                    throw new IllegalStateException(String.format("Malformed field table detected: provided encoded size '%d' does not equal calculated size '%d'", encodedSize, recalculateEncodedSize));
                }
            }
            return properties;
        }
    }

    static interface FieldTableSupport {
        public Object get(String var1);

        public boolean containsKey(String var1);

        public long getEncodedSize();

        public void writeToBuffer(QpidByteBuffer var1);

        public byte[] getAsBytes();

        public Map<String, AMQTypedValue> getAsMap();

        public void dispose();

        public void validate();
    }

    static class MapFieldTableSupport
    implements FieldTableSupport {
        private final Map<String, AMQTypedValue> _properties;
        private final long _encodedSize;

        MapFieldTableSupport(Map<String, AMQTypedValue> properties) {
            this._properties = Collections.unmodifiableMap(new LinkedHashMap<String, AMQTypedValue>(properties));
            this._encodedSize = FieldTable.recalculateEncodedSize(properties);
        }

        @Override
        public long getEncodedSize() {
            return this._encodedSize;
        }

        @Override
        public Object get(String key) {
            AMQTypedValue value = this._properties.get(key);
            if (value == null) {
                return null;
            }
            return value.getValue();
        }

        @Override
        public boolean containsKey(String key) {
            return this._properties.containsKey(key);
        }

        @Override
        public void writeToBuffer(QpidByteBuffer buffer) {
            for (Map.Entry<String, AMQTypedValue> me : this._properties.entrySet()) {
                EncodingUtils.writeShortStringBytes(buffer, me.getKey());
                me.getValue().writeToBuffer(buffer);
            }
        }

        @Override
        public byte[] getAsBytes() {
            byte[] data = new byte[(int)this.getEncodedSize()];
            QpidByteBuffer buf = QpidByteBuffer.wrap((byte[])data);
            this.writeToBuffer(buf);
            return data;
        }

        @Override
        public Map<String, AMQTypedValue> getAsMap() {
            return this._properties;
        }

        @Override
        public void dispose() {
        }

        @Override
        public void validate() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MapFieldTableSupport that = (MapFieldTableSupport)o;
            if (this._encodedSize != that._encodedSize) {
                return false;
            }
            return this._properties.equals(that._properties);
        }

        public int hashCode() {
            int result = this._properties.hashCode();
            result = 31 * result + (int)(this._encodedSize ^ this._encodedSize >>> 32);
            return result;
        }

        public String toString() {
            return this._properties.toString();
        }
    }
}

