/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind;

import java.io.Serializable;
import tools.jackson.databind.PropertyNamingStrategy;
import tools.jackson.databind.cfg.MapperConfig;
import tools.jackson.databind.introspect.AnnotatedField;
import tools.jackson.databind.introspect.AnnotatedMethod;
import tools.jackson.databind.introspect.AnnotatedParameter;
import tools.jackson.databind.util.NamingStrategyImpls;

public abstract class PropertyNamingStrategies
implements Serializable {
    private static final long serialVersionUID = 3L;
    public static final PropertyNamingStrategy LOWER_CAMEL_CASE = new LowerCamelCaseStrategy();
    public static final PropertyNamingStrategy UPPER_CAMEL_CASE = new UpperCamelCaseStrategy();
    public static final PropertyNamingStrategy SNAKE_CASE = new SnakeCaseStrategy();
    public static final PropertyNamingStrategy UPPER_SNAKE_CASE = new UpperSnakeCaseStrategy();
    public static final PropertyNamingStrategy LOWER_CASE = new LowerCaseStrategy();
    public static final PropertyNamingStrategy KEBAB_CASE = new KebabCaseStrategy();
    public static final PropertyNamingStrategy LOWER_DOT_CASE = new LowerDotCaseStrategy();

    public static class LowerCamelCaseStrategy
    extends NamingBase {
        private static final long serialVersionUID = 3L;

        @Override
        protected String translate(String input) {
            return NamingStrategyImpls.LOWER_CAMEL_CASE.translate(input);
        }
    }

    public static class UpperCamelCaseStrategy
    extends NamingBase {
        private static final long serialVersionUID = 3L;

        @Override
        protected String translate(String input) {
            return NamingStrategyImpls.UPPER_CAMEL_CASE.translate(input);
        }
    }

    public static class SnakeCaseStrategy
    extends NamingBase {
        private static final long serialVersionUID = 3L;

        @Override
        protected String translate(String input) {
            return NamingStrategyImpls.SNAKE_CASE.translate(input);
        }
    }

    public static class UpperSnakeCaseStrategy
    extends SnakeCaseStrategy {
        private static final long serialVersionUID = 3L;

        @Override
        protected String translate(String input) {
            return NamingStrategyImpls.UPPER_SNAKE_CASE.translate(input);
        }
    }

    public static class LowerCaseStrategy
    extends NamingBase {
        private static final long serialVersionUID = 3L;

        @Override
        protected String translate(String input) {
            return NamingStrategyImpls.LOWER_CASE.translate(input);
        }
    }

    public static class KebabCaseStrategy
    extends NamingBase {
        private static final long serialVersionUID = 3L;

        @Override
        protected String translate(String input) {
            return NamingStrategyImpls.KEBAB_CASE.translate(input);
        }
    }

    public static class LowerDotCaseStrategy
    extends NamingBase {
        private static final long serialVersionUID = 3L;

        @Override
        protected String translate(String input) {
            return NamingStrategyImpls.LOWER_DOT_CASE.translate(input);
        }
    }

    public static abstract class NamingBase
    extends PropertyNamingStrategy {
        private static final long serialVersionUID = 3L;

        @Override
        public String nameForField(MapperConfig<?> config, AnnotatedField field, String defaultName) {
            return this.translate(defaultName);
        }

        @Override
        public String nameForGetterMethod(MapperConfig<?> config, AnnotatedMethod method, String defaultName) {
            return this.translate(defaultName);
        }

        @Override
        public String nameForSetterMethod(MapperConfig<?> config, AnnotatedMethod method, String defaultName) {
            return this.translate(defaultName);
        }

        @Override
        public String nameForConstructorParameter(MapperConfig<?> config, AnnotatedParameter ctorParam, String defaultName) {
            return this.translate(defaultName);
        }

        protected abstract String translate(String var1);
    }
}

