/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0.type.transport.codec;

import org.apache.qpid.server.protocol.v1_0.codec.AbstractCompositeTypeConstructor;
import org.apache.qpid.server.protocol.v1_0.codec.DescribedTypeConstructorRegistry;
import org.apache.qpid.server.protocol.v1_0.type.AmqpErrorException;
import org.apache.qpid.server.protocol.v1_0.type.Binary;
import org.apache.qpid.server.protocol.v1_0.type.DeliveryState;
import org.apache.qpid.server.protocol.v1_0.type.Symbol;
import org.apache.qpid.server.protocol.v1_0.type.UnsignedInteger;
import org.apache.qpid.server.protocol.v1_0.type.UnsignedLong;
import org.apache.qpid.server.protocol.v1_0.type.transport.AmqpError;
import org.apache.qpid.server.protocol.v1_0.type.transport.Error;
import org.apache.qpid.server.protocol.v1_0.type.transport.ReceiverSettleMode;
import org.apache.qpid.server.protocol.v1_0.type.transport.Transfer;

public final class TransferConstructor
extends AbstractCompositeTypeConstructor<Transfer> {
    private static final TransferConstructor INSTANCE = new TransferConstructor();

    public static void register(DescribedTypeConstructorRegistry registry) {
        registry.register(Symbol.valueOf("amqp:transfer:list"), INSTANCE);
        registry.register(UnsignedLong.valueOf(20L), INSTANCE);
    }

    @Override
    protected String getTypeName() {
        return Transfer.class.getSimpleName();
    }

    @Override
    protected Transfer construct(AbstractCompositeTypeConstructor.FieldValueReader fieldValueReader) throws AmqpErrorException {
        Boolean batchable;
        Boolean aborted;
        Boolean resume;
        DeliveryState state;
        Object rcvSettleMode;
        Boolean more;
        Boolean settled;
        UnsignedInteger messageFormat;
        Binary deliveryTag;
        Transfer obj = new Transfer();
        UnsignedInteger handle = fieldValueReader.readValue(0, "handle", true, UnsignedInteger.class);
        obj.setHandle(handle);
        UnsignedInteger deliveryId = fieldValueReader.readValue(1, "deliveryId", false, UnsignedInteger.class);
        if (deliveryId != null) {
            obj.setDeliveryId(deliveryId);
        }
        if ((deliveryTag = fieldValueReader.readValue(2, "deliveryTag", false, Binary.class)) != null) {
            obj.setDeliveryTag(deliveryTag);
        }
        if ((messageFormat = fieldValueReader.readValue(3, "messageFormat", false, UnsignedInteger.class)) != null) {
            obj.setMessageFormat(messageFormat);
        }
        if ((settled = fieldValueReader.readValue(4, "settled", false, Boolean.class)) != null) {
            obj.setSettled(settled);
        }
        if ((more = fieldValueReader.readValue(5, "more", false, Boolean.class)) != null) {
            obj.setMore(more);
        }
        if ((rcvSettleMode = fieldValueReader.readValue(6, "rcvSettleMode", false, Object.class)) != null) {
            try {
                obj.setRcvSettleMode(ReceiverSettleMode.valueOf(rcvSettleMode));
            }
            catch (RuntimeException e) {
                Error error = new Error(AmqpError.DECODE_ERROR, "Could not decode value field 'rcvSettleMode' of 'Transfer'");
                throw new AmqpErrorException(error, (Throwable)e);
            }
        }
        if ((state = fieldValueReader.readValue(7, "state", false, DeliveryState.class)) != null) {
            obj.setState(state);
        }
        if ((resume = fieldValueReader.readValue(8, "resume", false, Boolean.class)) != null) {
            obj.setResume(resume);
        }
        if ((aborted = fieldValueReader.readValue(9, "aborted", false, Boolean.class)) != null) {
            obj.setAborted(aborted);
        }
        if ((batchable = fieldValueReader.readValue(10, "batchable", false, Boolean.class)) != null) {
            obj.setBatchable(batchable);
        }
        return obj;
    }
}

