/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.qpid.server.util.ByteBufferInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GZIPUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(GZIPUtils.class);
    public static final String GZIP_CONTENT_ENCODING = "gzip";

    public static byte[] compressBufferToArray(ByteBuffer input) {
        if (input != null) {
            byte[] byArray;
            ByteArrayOutputStream compressedBuffer = new ByteArrayOutputStream();
            try {
                try (GZIPOutputStream gzipOutputStream = new GZIPOutputStream(compressedBuffer);){
                    if (input.hasArray()) {
                        gzipOutputStream.write(input.array(), input.arrayOffset() + input.position(), input.remaining());
                    } else {
                        byte[] data = new byte[input.remaining()];
                        input.duplicate().get(data);
                        gzipOutputStream.write(data);
                    }
                }
                byArray = compressedBuffer.toByteArray();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        compressedBuffer.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOGGER.warn("Unexpected IOException when attempting to compress with gzip", (Throwable)e);
                }
            }
            compressedBuffer.close();
            return byArray;
        }
        return null;
    }

    public static byte[] uncompressBufferToArray(ByteBuffer contentBuffer) {
        if (contentBuffer != null) {
            try (ByteBufferInputStream input = new ByteBufferInputStream(contentBuffer);){
                byte[] byArray = GZIPUtils.uncompressStreamToArray(input);
                return byArray;
            }
        }
        return null;
    }

    public static byte[] uncompressStreamToArray(InputStream stream) {
        if (stream != null) {
            byte[] byArray;
            GZIPInputStream gzipInputStream = new GZIPInputStream(stream);
            try {
                int read;
                ByteArrayOutputStream inflatedContent = new ByteArrayOutputStream();
                byte[] buf = new byte[4096];
                while ((read = gzipInputStream.read(buf)) != -1) {
                    inflatedContent.write(buf, 0, read);
                }
                byArray = inflatedContent.toByteArray();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        gzipInputStream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOGGER.warn("Unexpected IOException when attempting to uncompress with gzip", (Throwable)e);
                }
            }
            gzipInputStream.close();
            return byArray;
        }
        return null;
    }
}

