/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.qpid.server.protocol.v1_0;

import org.apache.qpid.server.protocol.v1_0.type.AmqpErrorException;
import org.apache.qpid.server.protocol.v1_0.type.BaseSource;
import org.apache.qpid.server.protocol.v1_0.type.BaseTarget;
import org.apache.qpid.server.protocol.v1_0.type.Binary;
import org.apache.qpid.server.protocol.v1_0.type.DeliveryState;
import org.apache.qpid.server.protocol.v1_0.type.UnsignedInteger;
import org.apache.qpid.server.protocol.v1_0.type.transport.Attach;
import org.apache.qpid.server.protocol.v1_0.type.transport.Detach;
import org.apache.qpid.server.protocol.v1_0.type.transport.Error;
import org.apache.qpid.server.protocol.v1_0.type.transport.Flow;
import org.apache.qpid.server.protocol.v1_0.type.transport.ReceiverSettleMode;
import org.apache.qpid.server.protocol.v1_0.type.transport.Role;
import org.apache.qpid.server.protocol.v1_0.type.transport.SenderSettleMode;

public interface LinkEndpoint<S extends BaseSource, T extends BaseTarget>
{
    Role getRole();

    S getSource();

    T getTarget();

    Session_1_0 getSession();

    UnsignedInteger getLocalHandle();

    void setLocalHandle(UnsignedInteger localHandle);

    void receiveAttach(Attach attach) throws AmqpErrorException;

    void sendAttach();

    void remoteDetached(Detach detach);

    void receiveDeliveryState(Binary deliveryTag,
                              DeliveryState state,
                              Boolean settled);

    void receiveFlow(Flow flow);

    void sendFlow();

    void flowStateChanged();

    void start();

    void setStopped(boolean stopped);

    void destroy();

    void close(Error error);

    SenderSettleMode getSendingSettlementMode();

    ReceiverSettleMode getReceivingSettlementMode();

    void receiveComplete();
}
