/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.X509KeyManager;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.ManagedAttributeField;
import org.apache.qpid.server.model.ManagedObject;
import org.apache.qpid.server.model.ManagedObjectFactoryConstructor;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.model.StateTransition;
import org.apache.qpid.server.security.AbstractKeyStore;
import org.apache.qpid.server.security.CertificateDetails;
import org.apache.qpid.server.security.CertificateDetailsImpl;
import org.apache.qpid.server.security.FileKeyStore;
import org.apache.qpid.server.transport.network.security.ssl.QpidBestFitX509KeyManager;
import org.apache.qpid.server.transport.network.security.ssl.QpidServerX509KeyManager;
import org.apache.qpid.server.transport.network.security.ssl.SSLUtil;
import org.apache.qpid.server.util.StringUtil;
import org.apache.qpid.server.util.urlstreamhandler.data.Handler;

@ManagedObject(category=false)
public class FileKeyStoreImpl
extends AbstractKeyStore<FileKeyStoreImpl>
implements FileKeyStore<FileKeyStoreImpl> {
    @ManagedAttributeField
    private String _type;
    @ManagedAttributeField
    private String _keyStoreType;
    @ManagedAttributeField
    private String _certificateAlias;
    @ManagedAttributeField
    private String _keyManagerFactoryAlgorithm;
    @ManagedAttributeField(afterSet="postSetStoreUrl")
    private String _storeUrl;
    @ManagedAttributeField
    private boolean _useHostNameMatching;
    private String _path;
    @ManagedAttributeField
    private String _password;
    private volatile Map<String, Certificate> _certificates = Map.of();

    @ManagedObjectFactoryConstructor
    public FileKeyStoreImpl(Map<String, Object> attributes, Broker<?> broker) {
        super(attributes, broker);
    }

    @Override
    public void onValidate() {
        super.onValidate();
        this.validateKeyStoreAttributes(this);
    }

    @StateTransition(currentState={State.UNINITIALIZED, State.ERRORED}, desiredState=State.ACTIVE)
    protected CompletableFuture<Void> doActivate() {
        this.initializeExpiryChecking();
        this.setState(State.ACTIVE);
        return CompletableFuture.completedFuture(null);
    }

    @Override
    protected void onOpen() {
        super.onOpen();
        this.initialize();
    }

    @Override
    protected void changeAttributes(Map<String, Object> attributes) {
        super.changeAttributes(attributes);
        if (attributes.containsKey("storeUrl") || attributes.containsKey("password") || attributes.containsKey("keyStoreType") || attributes.containsKey("keyManagerFactoryAlgorithm")) {
            this.initialize();
        }
    }

    private void initialize() {
        try {
            this._certificates = Collections.unmodifiableMap(SSLUtil.getCertificates(this.getInitializedKeyStore(this), true));
        }
        catch (IOException | GeneralSecurityException e) {
            throw new IllegalConfigurationException(String.format("Cannot instantiate keystore '%s'", this.getName()), e);
        }
    }

    @Override
    protected void validateChange(ConfiguredObject<?> proxyForValidation, Set<String> changedAttributes) {
        super.validateChange(proxyForValidation, changedAttributes);
        FileKeyStore changedStore = (FileKeyStore)proxyForValidation;
        if (changedAttributes.contains("desiredState") && changedStore.getDesiredState() == State.DELETED) {
            return;
        }
        if (changedAttributes.contains("name") && !this.getName().equals(changedStore.getName())) {
            throw new IllegalConfigurationException("Changing the key store name is not allowed");
        }
        this.validateKeyStoreAttributes(changedStore);
    }

    private void validateKeyStoreAttributes(FileKeyStore<?> fileKeyStore) {
        String loggableStoreUrl = StringUtil.elideDataUrl(fileKeyStore.getStoreUrl());
        try {
            KeyStore keyStore = this.getInitializedKeyStore(fileKeyStore);
            String certAlias = fileKeyStore.getCertificateAlias();
            if (certAlias != null) {
                Certificate cert = keyStore.getCertificate(certAlias);
                if (cert == null) {
                    throw new IllegalConfigurationException(String.format("Cannot find a certificate with alias '%s' in key store '%s'.", certAlias, loggableStoreUrl));
                }
                if (!keyStore.entryInstanceOf(certAlias, KeyStore.PrivateKeyEntry.class)) {
                    throw new IllegalConfigurationException(String.format("Alias '%s' in key store '%s' does not identify a private key.", certAlias, loggableStoreUrl));
                }
            } else if (!this.containsPrivateKey(keyStore)) {
                throw new IllegalConfigurationException(String.format("Keystore '%s' must contain at least one private key.", loggableStoreUrl));
            }
        }
        catch (UnrecoverableKeyException e) {
            String message = String.format("Check key store password. Cannot instantiate key store from '%s'.", loggableStoreUrl);
            throw new IllegalConfigurationException(message, e);
        }
        catch (IOException | GeneralSecurityException e) {
            String message = String.format("Cannot instantiate key store from '%s'.", loggableStoreUrl);
            throw new IllegalConfigurationException(message, e);
        }
        try {
            KeyManagerFactory.getInstance(fileKeyStore.getKeyManagerFactoryAlgorithm());
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalConfigurationException(String.format("Unknown keyManagerFactoryAlgorithm: '%s'", fileKeyStore.getKeyManagerFactoryAlgorithm()));
        }
        if (!fileKeyStore.isDurable()) {
            throw new IllegalArgumentException(this.getClass().getSimpleName() + " must be durable");
        }
        this.checkCertificateExpiry();
    }

    private KeyStore getInitializedKeyStore(FileKeyStore<?> fileKeyStore) throws GeneralSecurityException, IOException {
        URL url = FileKeyStoreImpl.getUrlFromString(fileKeyStore.getStoreUrl());
        String password = fileKeyStore.getPassword();
        String keyStoreType = fileKeyStore.getKeyStoreType();
        return SSLUtil.getInitializedKeyStore(url, password, keyStoreType);
    }

    @Override
    public String getStoreUrl() {
        return this._storeUrl;
    }

    @Override
    public String getPath() {
        return this._path;
    }

    @Override
    public String getCertificateAlias() {
        return this._certificateAlias;
    }

    @Override
    public String getKeyManagerFactoryAlgorithm() {
        return this._keyManagerFactoryAlgorithm;
    }

    @Override
    public String getKeyStoreType() {
        return this._keyStoreType;
    }

    @Override
    public String getPassword() {
        return this._password;
    }

    @Override
    public boolean isUseHostNameMatching() {
        return this._useHostNameMatching;
    }

    @Override
    public void reload() {
        this.initialize();
    }

    public void setPassword(String password) {
        this._password = password;
    }

    @Override
    public KeyManager[] getKeyManagers() throws GeneralSecurityException {
        try {
            URL url = FileKeyStoreImpl.getUrlFromString(this._storeUrl);
            if (this.isUseHostNameMatching()) {
                return new KeyManager[]{new QpidBestFitX509KeyManager(this._certificateAlias, url, this._keyStoreType, this.getPassword(), this._keyManagerFactoryAlgorithm)};
            }
            if (this._certificateAlias != null) {
                return new KeyManager[]{new QpidServerX509KeyManager(this._certificateAlias, url, this._keyStoreType, this.getPassword(), this._keyManagerFactoryAlgorithm)};
            }
            KeyStore ks = SSLUtil.getInitializedKeyStore(url, this.getPassword(), this._keyStoreType);
            char[] keyStoreCharPassword = this.getPassword() == null ? null : this.getPassword().toCharArray();
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(this._keyManagerFactoryAlgorithm);
            kmf.init(ks, keyStoreCharPassword);
            KeyManager[] keyManagers = kmf.getKeyManagers();
            return keyManagers == null ? new KeyManager[]{} : Arrays.copyOf(keyManagers, keyManagers.length);
        }
        catch (IOException e) {
            throw new GeneralSecurityException(e);
        }
    }

    private static URL getUrlFromString(String urlString) throws MalformedURLException {
        URL url;
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            File file = new File(urlString);
            url = file.toURI().toURL();
        }
        return url;
    }

    private void postSetStoreUrl() {
        this._path = this._storeUrl != null && !this._storeUrl.startsWith("data:") ? this._storeUrl : null;
    }

    @Override
    protected void checkCertificateExpiry() {
        int expiryWarning = this.getCertificateExpiryWarnPeriod();
        if (expiryWarning > 0) {
            long currentTime = System.currentTimeMillis();
            Date expiryTestDate = new Date(currentTime + 86400000L * (long)expiryWarning);
            try {
                KeyStore ks = this.getInitializedKeyStore(this);
                char[] keyStoreCharPassword = this.getPassword() == null ? null : this.getPassword().toCharArray();
                KeyManagerFactory kmf = KeyManagerFactory.getInstance(this._keyManagerFactoryAlgorithm);
                kmf.init(ks, keyStoreCharPassword);
                for (KeyManager km : kmf.getKeyManagers()) {
                    if (!(km instanceof X509KeyManager)) continue;
                    X509KeyManager x509KeyManager = (X509KeyManager)km;
                    for (String alias : Collections.list(ks.aliases())) {
                        this.checkCertificatesExpiry(currentTime, expiryTestDate, x509KeyManager.getCertificateChain(alias));
                    }
                }
            }
            catch (IOException | GeneralSecurityException exception) {
                // empty catch block
            }
        }
    }

    @Override
    public List<CertificateDetails> getCertificateDetails() {
        if (this._certificates.isEmpty()) {
            return List.of();
        }
        return this._certificates.entrySet().stream().filter(entry -> entry.getValue() instanceof X509Certificate).map(entry -> new CertificateDetailsImpl((X509Certificate)entry.getValue(), (String)entry.getKey())).collect(Collectors.toList());
    }

    @Override
    protected Collection<Certificate> getCertificates() {
        return this._certificates.values();
    }

    private boolean containsPrivateKey(KeyStore keyStore) throws KeyStoreException {
        Enumeration<String> aliasesEnum = keyStore.aliases();
        boolean foundPrivateKey = false;
        while (aliasesEnum.hasMoreElements()) {
            String alias = aliasesEnum.nextElement();
            if (!keyStore.entryInstanceOf(alias, KeyStore.PrivateKeyEntry.class)) continue;
            foundPrivateKey = true;
            break;
        }
        return foundPrivateKey;
    }

    static {
        Handler.register();
    }
}

