/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.loadbalance.extensions.strategy;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.concurrent.ThreadSafe;
import lombok.Generated;
import org.apache.pulsar.broker.ServiceConfiguration;
import org.apache.pulsar.broker.loadbalance.extensions.LoadManagerContext;
import org.apache.pulsar.broker.loadbalance.extensions.data.BrokerLoadData;
import org.apache.pulsar.broker.loadbalance.extensions.strategy.BrokerSelectionStrategy;
import org.apache.pulsar.common.naming.ServiceUnitId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class LeastResourceUsageWithWeight
implements BrokerSelectionStrategy {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LeastResourceUsageWithWeight.class);
    private final ThreadLocal<ArrayList<String>> bestBrokers = ThreadLocal.withInitial(ArrayList::new);
    private final ThreadLocal<HashSet<String>> noLoadDataBrokers = ThreadLocal.withInitial(HashSet::new);

    private double getMaxResourceUsageWithWeight(String broker, BrokerLoadData brokerLoadData, ServiceConfiguration conf, boolean debugMode) {
        double overloadThreshold = (double)conf.getLoadBalancerBrokerOverloadedThresholdPercentage() / 100.0;
        double maxUsageWithWeight = brokerLoadData.getWeightedMaxEMA();
        if (maxUsageWithWeight > overloadThreshold) {
            log.warn("Broker {} is overloaded, brokerLoad({}%) > overloadThreshold({}%). load data:{{}}", new Object[]{broker, maxUsageWithWeight * 100.0, overloadThreshold * 100.0, brokerLoadData.toString(conf)});
        } else if (debugMode) {
            log.info("Broker {} load data:{{}}", (Object)broker, (Object)brokerLoadData.toString(conf));
        }
        return maxUsageWithWeight;
    }

    @Override
    public Optional<String> select(Set<String> candidates, ServiceUnitId bundleToAssign, LoadManagerContext context) {
        ServiceConfiguration conf = context.brokerConfiguration();
        if (candidates.isEmpty()) {
            log.warn("There are no available brokers as candidates at this point for bundle: {}", (Object)bundleToAssign);
            return Optional.empty();
        }
        ArrayList<String> bestBrokers = this.bestBrokers.get();
        HashSet<String> noLoadDataBrokers = this.noLoadDataBrokers.get();
        bestBrokers.clear();
        noLoadDataBrokers.clear();
        double totalUsage = 0.0;
        boolean debugMode = log.isDebugEnabled() || conf.isLoadBalancerDebugModeEnabled();
        for (String broker : candidates) {
            Optional<BrokerLoadData> brokerLoadDataOptional = context.brokerLoadDataStore().get(broker);
            if (brokerLoadDataOptional.isEmpty()) {
                log.warn("There is no broker load data for broker:{}. Skipping this broker. Phase one", (Object)broker);
                noLoadDataBrokers.add(broker);
                continue;
            }
            BrokerLoadData brokerLoadData = brokerLoadDataOptional.get();
            double usageWithWeight = this.getMaxResourceUsageWithWeight(broker, brokerLoadData, context.brokerConfiguration(), debugMode);
            totalUsage += usageWithWeight;
        }
        if (candidates.size() > noLoadDataBrokers.size()) {
            double avgUsage = totalUsage / (double)(candidates.size() - noLoadDataBrokers.size());
            double diffThreshold = (double)conf.getLoadBalancerAverageResourceUsageDifferenceThresholdPercentage() / 100.0;
            if (debugMode) {
                log.info("Computed avgUsage:{}, diffThreshold:{}", (Object)avgUsage, (Object)diffThreshold);
            }
            for (String broker : candidates) {
                Optional<BrokerLoadData> brokerLoadDataOptional = context.brokerLoadDataStore().get(broker);
                if (brokerLoadDataOptional.isEmpty()) {
                    log.warn("There is no broker load data for broker:{}. Skipping this broker. Phase two", (Object)broker);
                    continue;
                }
                double avgResUsage = brokerLoadDataOptional.get().getWeightedMaxEMA();
                if (!(avgResUsage + diffThreshold <= avgUsage) || noLoadDataBrokers.contains(broker)) continue;
                bestBrokers.add(broker);
            }
        }
        if (bestBrokers.isEmpty()) {
            if (debugMode) {
                log.info("Assign randomly as none of the brokers are underloaded. candidatesSize:{}, noLoadDataBrokersSize:{}", (Object)candidates.size(), (Object)noLoadDataBrokers.size());
            }
            bestBrokers.addAll(candidates);
        }
        if (debugMode) {
            log.info("Selected {} best brokers: {} from candidate brokers: {}, noLoadDataBrokers:{}", new Object[]{bestBrokers.size(), bestBrokers, candidates, noLoadDataBrokers});
        }
        return Optional.of(bestBrokers.get(ThreadLocalRandom.current().nextInt(bestBrokers.size())));
    }
}

