/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.schema;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import lombok.Generated;
import org.apache.pulsar.client.api.EncodeData;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.SchemaSerializationException;
import org.apache.pulsar.client.api.schema.KeyValueSchema;
import org.apache.pulsar.client.api.schema.SchemaInfoProvider;
import org.apache.pulsar.client.impl.schema.AbstractSchema;
import org.apache.pulsar.client.impl.schema.AbstractStructSchema;
import org.apache.pulsar.client.impl.schema.AutoConsumeSchema;
import org.apache.pulsar.client.impl.schema.AvroSchema;
import org.apache.pulsar.client.impl.schema.BytesSchema;
import org.apache.pulsar.client.impl.schema.JSONSchema;
import org.apache.pulsar.client.impl.schema.KeyValueSchemaInfo;
import org.apache.pulsar.client.internal.PulsarClientImplementationBinding;
import org.apache.pulsar.common.protocol.schema.BytesSchemaVersion;
import org.apache.pulsar.common.protocol.schema.SchemaVersion;
import org.apache.pulsar.common.schema.KeyValue;
import org.apache.pulsar.common.schema.KeyValueEncodingType;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.schema.SchemaType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyValueSchemaImpl<K, V>
extends AbstractSchema<KeyValue<K, V>>
implements KeyValueSchema<K, V> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KeyValueSchemaImpl.class);
    private final Schema<K> keySchema;
    private final Schema<V> valueSchema;
    private final KeyValueEncodingType keyValueEncodingType;
    private final Map<SchemaVersion, Schema<?>> schemaMap = new ConcurrentHashMap();
    private SchemaInfo schemaInfo;
    protected SchemaInfoProvider schemaInfoProvider;
    private static final Schema<KeyValue<byte[], byte[]>> KV_BYTES = new KeyValueSchemaImpl<byte[], byte[]>(BytesSchema.of(), BytesSchema.of());

    public static <K, V> Schema<KeyValue<K, V>> of(Class<K> key, Class<V> value, SchemaType type) {
        Preconditions.checkArgument((SchemaType.JSON == type || SchemaType.AVRO == type ? 1 : 0) != 0);
        if (SchemaType.JSON == type) {
            return new KeyValueSchemaImpl<K, V>(JSONSchema.of(key), JSONSchema.of(value), KeyValueEncodingType.INLINE);
        }
        return new KeyValueSchemaImpl<K, V>(AvroSchema.of(key), AvroSchema.of(value), KeyValueEncodingType.INLINE);
    }

    public static <K, V> Schema<KeyValue<K, V>> of(Schema<K> keySchema, Schema<V> valueSchema) {
        return new KeyValueSchemaImpl<K, V>(keySchema, valueSchema, KeyValueEncodingType.INLINE);
    }

    public static <K, V> Schema<KeyValue<K, V>> of(Schema<K> keySchema, Schema<V> valueSchema, KeyValueEncodingType keyValueEncodingType) {
        return new KeyValueSchemaImpl<K, V>(keySchema, valueSchema, keyValueEncodingType);
    }

    public static Schema<KeyValue<byte[], byte[]>> kvBytes() {
        return KV_BYTES;
    }

    public boolean supportSchemaVersioning() {
        return this.keySchema.supportSchemaVersioning() || this.valueSchema.supportSchemaVersioning();
    }

    private KeyValueSchemaImpl(Schema<K> keySchema, Schema<V> valueSchema) {
        this(keySchema, valueSchema, KeyValueEncodingType.INLINE);
    }

    private KeyValueSchemaImpl(Schema<K> keySchema, Schema<V> valueSchema, KeyValueEncodingType keyValueEncodingType) {
        SchemaType keySchemaType = null;
        if (keySchema != null && keySchema.getSchemaInfo() != null) {
            keySchemaType = keySchema.getSchemaInfo().getType();
        }
        SchemaType valueSchemaType = null;
        if (valueSchema != null && valueSchema.getSchemaInfo() != null) {
            valueSchemaType = valueSchema.getSchemaInfo().getType();
        }
        if (SchemaType.EXTERNAL.equals((Object)keySchemaType) && valueSchemaType != null && SchemaType.isStructType((SchemaType)valueSchemaType) || SchemaType.EXTERNAL.equals((Object)valueSchemaType) && keySchemaType != null && SchemaType.isStructType((SchemaType)keySchemaType)) {
            throw new IllegalArgumentException("External schema cannot be used with other Pulsar struct schema types,keySchemaType: " + String.valueOf(keySchemaType) + ", valueSchemaType: " + String.valueOf(valueSchemaType));
        }
        this.keySchema = keySchema;
        this.valueSchema = valueSchema;
        this.keyValueEncodingType = keyValueEncodingType;
        this.schemaInfoProvider = new SchemaInfoProvider(){

            public CompletableFuture<SchemaInfo> getSchemaByVersion(byte[] schemaVersion) {
                return CompletableFuture.completedFuture(KeyValueSchemaImpl.this.schemaInfo);
            }

            public CompletableFuture<SchemaInfo> getLatestSchema() {
                return CompletableFuture.completedFuture(KeyValueSchemaImpl.this.schemaInfo);
            }

            public String getTopicName() {
                return "key-value-schema";
            }
        };
        if (!this.requireFetchingSchemaInfo()) {
            this.configureKeyValueSchemaInfo();
        } else {
            this.buildKeyValueSchemaInfo();
        }
    }

    public byte[] encode(KeyValue<K, V> message) {
        return this.encode((String)null, message).data();
    }

    public EncodeData encode(String topic, KeyValue<K, V> message) {
        if (this.keyValueEncodingType != null && this.keyValueEncodingType == KeyValueEncodingType.INLINE) {
            return KeyValue.encode((String)topic, (Object)message.getKey(), this.keySchema, (Object)message.getValue(), this.valueSchema);
        }
        if (message.getValue() == null) {
            return null;
        }
        return this.valueSchema.encode(topic, message.getValue());
    }

    public KeyValue<K, V> decode(byte[] bytes) {
        return this.decode(bytes, null);
    }

    public KeyValue<K, V> decode(byte[] bytes, byte[] schemaVersion) {
        if (this.keyValueEncodingType == KeyValueEncodingType.SEPARATED) {
            throw new SchemaSerializationException("This method cannot be used under this SEPARATED encoding type");
        }
        return KeyValue.decode((byte[])bytes, (keyBytes, valueBytes) -> this.decode(keyBytes, valueBytes, schemaVersion));
    }

    @Override
    public KeyValue<K, V> decode(ByteBuf byteBuf) {
        return this.decode(ByteBufUtil.getBytes((ByteBuf)byteBuf));
    }

    public KeyValue<K, V> decode(String topic, byte[] data, byte[] schemaId) {
        if (this.keyValueEncodingType == KeyValueEncodingType.SEPARATED) {
            throw new SchemaSerializationException("This method cannot be used under this SEPARATED encoding type");
        }
        return KeyValue.decode((byte[])data, (keyBytes, valueBytes) -> this.decode(topic, keyBytes, valueBytes, schemaId));
    }

    public KeyValue<K, V> decode(String topic, ByteBuffer data, byte[] schemaId) {
        return this.decode(topic, PulsarClientImplementationBinding.getBytes((ByteBuffer)data), schemaId);
    }

    @Override
    public KeyValue<K, V> decode(ByteBuf byteBuf, byte[] schemaVersion) {
        return this.decode(ByteBufUtil.getBytes((ByteBuf)byteBuf), schemaVersion);
    }

    public KeyValue<K, V> decode(byte[] keyBytes, byte[] valueBytes, byte[] schemaVersion) {
        Object k = keyBytes == null ? null : (this.keySchema.supportSchemaVersioning() && schemaVersion != null ? this.keySchema.decode(keyBytes, schemaVersion) : this.keySchema.decode(keyBytes));
        Object v = valueBytes == null ? null : (this.valueSchema.supportSchemaVersioning() && schemaVersion != null ? this.valueSchema.decode(valueBytes, schemaVersion) : this.valueSchema.decode(valueBytes));
        return new KeyValue(k, v);
    }

    public KeyValue<K, V> decode(String topic, byte[] keyBytes, byte[] valueBytes, byte[] schemaId) {
        Object k = null;
        byte[] keySchemaId = null;
        byte[] valueSchemaId = null;
        if (EncodeData.isValidSchemaId((byte[])schemaId)) {
            KeyValue<byte[], byte[]> kvSchemaId = this.getKeyValueSchemaId(schemaId);
            keySchemaId = (byte[])kvSchemaId.getKey();
            valueSchemaId = (byte[])kvSchemaId.getValue();
        }
        if (keyBytes != null) {
            k = this.keySchema.supportSchemaVersioning() && EncodeData.isValidSchemaId((byte[])keySchemaId) ? this.keySchema.decode(topic, keyBytes, keySchemaId) : this.keySchema.decode(keyBytes);
        }
        Object v = null;
        if (valueBytes != null) {
            v = this.valueSchema.supportSchemaVersioning() && EncodeData.isValidSchemaId((byte[])valueSchemaId) ? this.valueSchema.decode(topic, valueBytes, valueSchemaId) : this.valueSchema.decode(valueBytes);
        }
        return new KeyValue(k, v);
    }

    private KeyValue<byte[], byte[]> getKeyValueSchemaId(byte[] schemaId) {
        if (!SchemaType.EXTERNAL.equals((Object)this.valueSchema.getSchemaInfo().getType())) {
            return new KeyValue((Object)schemaId, (Object)schemaId);
        }
        return KeyValue.getSchemaId((byte[])schemaId);
    }

    public SchemaInfo getSchemaInfo() {
        return this.schemaInfo;
    }

    public void setSchemaInfoProvider(SchemaInfoProvider schemaInfoProvider) {
        this.schemaInfoProvider = schemaInfoProvider;
    }

    public boolean requireFetchingSchemaInfo() {
        return this.keySchema.requireFetchingSchemaInfo() || this.valueSchema.requireFetchingSchemaInfo();
    }

    public void configureSchemaInfo(String topicName, String componentName, SchemaInfo schemaInfo) {
        if (schemaInfo == null) {
            log.info("KeyValueSchema starting from null SchemaInfo. This means that the topic {} still has not a schema", (Object)topicName);
            return;
        }
        KeyValue kvSchemaInfo = KeyValueSchemaInfo.decodeKeyValueSchemaInfo((SchemaInfo)schemaInfo);
        this.keySchema.configureSchemaInfo(topicName, "key", (SchemaInfo)kvSchemaInfo.getKey());
        this.valueSchema.configureSchemaInfo(topicName, "value", (SchemaInfo)kvSchemaInfo.getValue());
        this.configureKeyValueSchemaInfo();
        if (null == this.schemaInfo) {
            throw new RuntimeException("No key schema info or value schema info : key = " + String.valueOf(this.keySchema.getSchemaInfo()) + ", value = " + String.valueOf(this.valueSchema.getSchemaInfo()));
        }
    }

    @Override
    public Schema<KeyValue<K, V>> clone() {
        return KeyValueSchemaImpl.of(this.keySchema.clone(), this.valueSchema.clone(), this.keyValueEncodingType);
    }

    private void buildKeyValueSchemaInfo() {
        this.schemaInfo = KeyValueSchemaInfo.encodeKeyValueSchemaInfo(this.keySchema, this.valueSchema, (KeyValueEncodingType)this.keyValueEncodingType);
    }

    private void configureKeyValueSchemaInfo() {
        this.buildKeyValueSchemaInfo();
        this.setSchemaInfoProviderOnSubschemas();
    }

    private void setSchemaInfoProviderOnSubschemas() {
        this.keySchema.setSchemaInfoProvider(new SchemaInfoProvider(){

            public CompletableFuture<SchemaInfo> getSchemaByVersion(byte[] schemaVersion) {
                return KeyValueSchemaImpl.this.schemaInfoProvider.getSchemaByVersion(schemaVersion).thenApply(si -> (SchemaInfo)KeyValueSchemaInfo.decodeKeyValueSchemaInfo((SchemaInfo)si).getKey());
            }

            public CompletableFuture<SchemaInfo> getLatestSchema() {
                return CompletableFuture.completedFuture(((AbstractStructSchema)KeyValueSchemaImpl.this.keySchema).schemaInfo);
            }

            public String getTopicName() {
                return "key-schema";
            }
        });
        this.valueSchema.setSchemaInfoProvider(new SchemaInfoProvider(){

            public CompletableFuture<SchemaInfo> getSchemaByVersion(byte[] schemaVersion) {
                return KeyValueSchemaImpl.this.schemaInfoProvider.getSchemaByVersion(schemaVersion).thenApply(si -> (SchemaInfo)KeyValueSchemaInfo.decodeKeyValueSchemaInfo((SchemaInfo)si).getValue());
            }

            public CompletableFuture<SchemaInfo> getLatestSchema() {
                return CompletableFuture.completedFuture(((AbstractStructSchema)KeyValueSchemaImpl.this.valueSchema).schemaInfo);
            }

            public String getTopicName() {
                return "value-schema";
            }
        });
    }

    public String toString() {
        return "KeyValueSchema(" + String.valueOf(this.keyValueEncodingType) + "," + String.valueOf(this.keySchema) + "," + String.valueOf(this.valueSchema) + ")";
    }

    @Override
    public Schema<?> atSchemaVersion(byte[] schemaVersion) throws SchemaSerializationException {
        if (!this.supportSchemaVersioning()) {
            return this;
        }
        if (schemaVersion == null) {
            return this.internalAtSchemaVersion(null);
        }
        return this.schemaMap.computeIfAbsent((SchemaVersion)BytesSchemaVersion.of((byte[])schemaVersion), __ -> this.internalAtSchemaVersion(schemaVersion));
    }

    private Schema<?> internalAtSchemaVersion(byte[] schemaVersion) {
        Schema<K> keySchema = this.keySchema instanceof AbstractSchema ? ((AbstractSchema)this.keySchema).atSchemaVersion(schemaVersion) : this.keySchema;
        Schema<V> valueSchema = this.valueSchema instanceof AbstractSchema ? ((AbstractSchema)this.valueSchema).atSchemaVersion(schemaVersion) : this.valueSchema;
        return KeyValueSchemaImpl.of(keySchema, valueSchema, this.keyValueEncodingType);
    }

    public Schema<K> getKeySchema() {
        return this.keySchema;
    }

    public Schema<V> getValueSchema() {
        return this.valueSchema;
    }

    public KeyValueEncodingType getKeyValueEncodingType() {
        return this.keyValueEncodingType;
    }

    public void fetchSchemaIfNeeded(String topicName, SchemaVersion schemaVersion) throws SchemaSerializationException {
        SchemaInfo schemaInfo;
        if (this.schemaInfo != null) {
            if (this.keySchema instanceof AutoConsumeSchema) {
                ((AutoConsumeSchema)this.keySchema).fetchSchemaIfNeeded(schemaVersion);
            }
            if (this.valueSchema instanceof AutoConsumeSchema) {
                ((AutoConsumeSchema)this.valueSchema).fetchSchemaIfNeeded(schemaVersion);
            }
            return;
        }
        this.setSchemaInfoProviderOnSubschemas();
        if (schemaVersion == null) {
            schemaVersion = BytesSchemaVersion.of((byte[])new byte[0]);
        }
        if (this.schemaInfoProvider == null) {
            throw new SchemaSerializationException("Can't get accurate schema information for " + topicName + " using KeyValueSchemaImpl because SchemaInfoProvider is not set yet");
        }
        try {
            schemaInfo = (SchemaInfo)this.schemaInfoProvider.getSchemaByVersion(schemaVersion.bytes()).get();
            if (schemaInfo == null) {
                schemaInfo = BytesSchema.of().getSchemaInfo();
            }
            this.configureSchemaInfo(topicName, "topic", schemaInfo);
        }
        catch (InterruptedException | ExecutionException e) {
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            log.error("Can't get last schema for topic {} using KeyValueSchemaImpl", (Object)topicName);
            throw new SchemaSerializationException(e.getCause());
        }
        log.info("Configure schema {} for topic {} : {}", new Object[]{schemaVersion, topicName, schemaInfo.getSchemaDefinition()});
    }
}

