/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog.namespace;

import java.net.URI;
import org.apache.distributedlog.BKDistributedLogNamespace;
import org.apache.distributedlog.DistributedLogConfiguration;
import org.apache.distributedlog.TestDistributedLogBase;
import org.apache.distributedlog.api.namespace.Namespace;
import org.apache.distributedlog.api.namespace.NamespaceBuilder;
import org.junit.Assert;
import org.junit.Test;

public class TestNamespaceBuilder
extends TestDistributedLogBase {
    @Test(timeout=60000L, expected=NullPointerException.class)
    public void testEmptyBuilder() throws Exception {
        NamespaceBuilder.newBuilder().build();
    }

    @Test(timeout=60000L, expected=NullPointerException.class)
    public void testMissingUri() throws Exception {
        NamespaceBuilder.newBuilder().conf(new DistributedLogConfiguration()).build();
    }

    @Test(timeout=60000L, expected=NullPointerException.class)
    public void testMissingSchemeInUri() throws Exception {
        NamespaceBuilder.newBuilder().conf(new DistributedLogConfiguration()).uri(new URI("/test")).build();
    }

    @Test(timeout=60000L, expected=IllegalArgumentException.class)
    public void testInvalidSchemeInUri() throws Exception {
        NamespaceBuilder.newBuilder().conf(new DistributedLogConfiguration()).uri(new URI("dist://invalid/scheme/in/uri")).build();
    }

    @Test(timeout=60000L, expected=IllegalArgumentException.class)
    public void testInvalidSchemeCorrectBackendInUri() throws Exception {
        NamespaceBuilder.newBuilder().conf(new DistributedLogConfiguration()).uri(new URI("dist-bk://invalid/scheme/in/uri")).build();
    }

    @Test(timeout=60000L, expected=IllegalArgumentException.class)
    public void testUnknownBackendInUri() throws Exception {
        NamespaceBuilder.newBuilder().conf(new DistributedLogConfiguration()).uri(new URI("distributedlog-unknown://invalid/scheme/in/uri")).build();
    }

    @Test(timeout=60000L, expected=NullPointerException.class)
    public void testNullStatsLogger() throws Exception {
        NamespaceBuilder.newBuilder().conf(new DistributedLogConfiguration()).uri(new URI("distributedlog-bk://localhost/distributedlog")).statsLogger(null).build();
    }

    @Test(timeout=60000L, expected=NullPointerException.class)
    public void testNullClientId() throws Exception {
        NamespaceBuilder.newBuilder().conf(new DistributedLogConfiguration()).uri(new URI("distributedlog-bk://localhost/distributedlog")).clientId(null).build();
    }

    @Test(timeout=60000L)
    public void testBuildBKDistributedLogNamespace() throws Exception {
        try (Namespace namespace = NamespaceBuilder.newBuilder().conf(new DistributedLogConfiguration()).uri(new URI("distributedlog-bk://" + zkServers + "/messaging/distributedlog" + "/bknamespace")).build();){
            Assert.assertTrue((String)"distributedlog-bk:// should build bookkeeper based distributedlog namespace", (boolean)(namespace instanceof BKDistributedLogNamespace));
        }
    }

    @Test(timeout=60000L)
    public void testBuildWhenMissingBackendInUri() throws Exception {
        try (Namespace namespace = NamespaceBuilder.newBuilder().conf(new DistributedLogConfiguration()).uri(new URI("distributedlog://" + zkServers + "/messaging/distributedlog" + "/defaultnamespace")).build();){
            Assert.assertTrue((String)"distributedlog:// should build bookkeeper based distributedlog namespace", (boolean)(namespace instanceof BKDistributedLogNamespace));
        }
    }
}

