/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.clients.impl.kv;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;
import org.apache.bookkeeper.clients.exceptions.InternalServerException;
import org.apache.bookkeeper.clients.impl.channel.StorageServerChannel;
import org.apache.bookkeeper.clients.impl.container.StorageContainerChannel;
import org.apache.bookkeeper.clients.utils.ListenableFutureRpcProcessor;
import org.apache.bookkeeper.common.util.Backoff;
import org.apache.bookkeeper.stream.proto.kv.rpc.DeleteRangeRequest;
import org.apache.bookkeeper.stream.proto.kv.rpc.DeleteRangeResponse;
import org.apache.bookkeeper.stream.proto.storage.StatusCode;

class DeleteRequestProcessor<RespT>
extends ListenableFutureRpcProcessor<DeleteRangeRequest, DeleteRangeResponse, RespT> {
    private final DeleteRangeRequest request;
    private final Function<DeleteRangeResponse, RespT> responseFunc;

    public static <T> DeleteRequestProcessor<T> of(DeleteRangeRequest request, Function<DeleteRangeResponse, T> responseFunc, StorageContainerChannel channel, ScheduledExecutorService executor, Backoff.Policy backoffPolicy) {
        return new DeleteRequestProcessor<T>(request, responseFunc, channel, executor, backoffPolicy);
    }

    private DeleteRequestProcessor(DeleteRangeRequest request, Function<DeleteRangeResponse, RespT> respFunc, StorageContainerChannel channel, ScheduledExecutorService executor, Backoff.Policy backoffPolicy) {
        super(channel, executor, backoffPolicy);
        this.request = request;
        this.responseFunc = respFunc;
    }

    @Override
    protected DeleteRangeRequest createRequest() {
        return this.request;
    }

    @Override
    protected ListenableFuture<DeleteRangeResponse> sendRPC(StorageServerChannel rsChannel, DeleteRangeRequest request) {
        return rsChannel.getTableService().delete(request);
    }

    @Override
    protected RespT processResponse(DeleteRangeResponse response) throws Exception {
        if (StatusCode.SUCCESS == response.getHeader().getCode()) {
            return this.responseFunc.apply(response);
        }
        throw new InternalServerException("Encountered internal server exception : code = " + (Object)((Object)response.getHeader().getCode()));
    }
}

