/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.delayed.proto;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.pulsar.broker.delayed.proto.DelayedIndex;
import org.apache.pulsar.broker.delayed.proto.LightProtoCodec;

public final class SnapshotSegment {
    private List<DelayedIndex> indexes = null;
    private int _indexesCount = 0;
    private static final int _INDEXES_FIELD_NUMBER = 1;
    private static final int _INDEXES_TAG = 10;
    private static final int _INDEXES_TAG_SIZE = LightProtoCodec.computeVarIntSize(10);
    private int _bitField0;
    private static final int _REQUIRED_FIELDS_MASK0 = 0;
    private int _cachedSize;
    private ByteBuf _parsedBuffer;

    public int getIndexesCount() {
        return this._indexesCount;
    }

    public DelayedIndex getIndexeAt(int idx) {
        if (idx < 0 || idx >= this._indexesCount) {
            throw new IndexOutOfBoundsException("Index " + idx + " is out of the list size (" + this._indexesCount + ") for field 'indexes'");
        }
        return this.indexes.get(idx);
    }

    public List<DelayedIndex> getIndexesList() {
        if (this._indexesCount == 0) {
            return Collections.emptyList();
        }
        return this.indexes.subList(0, this._indexesCount);
    }

    public DelayedIndex addIndexe() {
        if (this.indexes == null) {
            this.indexes = new ArrayList<DelayedIndex>();
        }
        if (this.indexes.size() == this._indexesCount) {
            this.indexes.add(new DelayedIndex());
        }
        this._cachedSize = -1;
        return this.indexes.get(this._indexesCount++);
    }

    public SnapshotSegment addAllIndexes(Iterable<DelayedIndex> indexes) {
        for (DelayedIndex _o : indexes) {
            this.addIndexe().copyFrom(_o);
        }
        return this;
    }

    public SnapshotSegment clearIndexes() {
        for (int i = 0; i < this._indexesCount; ++i) {
            this.indexes.get(i).clear();
        }
        this._indexesCount = 0;
        return this;
    }

    public int writeTo(ByteBuf _b) {
        int _writeIdx = _b.writerIndex();
        for (int i = 0; i < this._indexesCount; ++i) {
            DelayedIndex _item = this.indexes.get(i);
            LightProtoCodec.writeVarInt(_b, 10);
            LightProtoCodec.writeVarInt(_b, _item.getSerializedSize());
            _item.writeTo(_b);
        }
        return _b.writerIndex() - _writeIdx;
    }

    public int getSerializedSize() {
        if (this._cachedSize > -1) {
            return this._cachedSize;
        }
        int _size = 0;
        for (int i = 0; i < this._indexesCount; ++i) {
            DelayedIndex _item = this.indexes.get(i);
            _size += _INDEXES_TAG_SIZE;
            int MsgsizeIndexes = _item.getSerializedSize();
            _size += LightProtoCodec.computeVarIntSize(MsgsizeIndexes) + MsgsizeIndexes;
        }
        this._cachedSize = _size;
        return _size;
    }

    public void parseFrom(ByteBuf _buffer, int _size) {
        this.clear();
        int _endIdx = _buffer.readerIndex() + _size;
        block3: while (_buffer.readerIndex() < _endIdx) {
            int _tag = LightProtoCodec.readVarInt(_buffer);
            switch (_tag) {
                case 10: {
                    int _indexesSize = LightProtoCodec.readVarInt(_buffer);
                    this.addIndexe().parseFrom(_buffer, _indexesSize);
                    continue block3;
                }
            }
            LightProtoCodec.skipUnknownField(_tag, _buffer);
        }
        this._parsedBuffer = _buffer;
    }

    public SnapshotSegment clear() {
        for (int i = 0; i < this._indexesCount; ++i) {
            this.indexes.get(i).clear();
        }
        this._indexesCount = 0;
        this._parsedBuffer = null;
        this._cachedSize = -1;
        this._bitField0 = 0;
        return this;
    }

    public SnapshotSegment copyFrom(SnapshotSegment _other) {
        this._cachedSize = -1;
        for (int i = 0; i < _other.getIndexesCount(); ++i) {
            this.addIndexe().copyFrom(_other.getIndexeAt(i));
        }
        return this;
    }

    public byte[] toByteArray() {
        byte[] a = new byte[this.getSerializedSize()];
        ByteBuf b = Unpooled.wrappedBuffer((byte[])a).writerIndex(0);
        this.writeTo(b);
        return a;
    }

    public void parseFrom(byte[] a) {
        ByteBuf b = Unpooled.wrappedBuffer((byte[])a);
        this.parseFrom(b, b.readableBytes());
    }
}

