/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.unnest;

import com.google.common.base.Preconditions;
import io.trino.operator.unnest.Unnester;
import io.trino.spi.block.Block;
import io.trino.spi.block.ColumnarMap;
import io.trino.spi.type.Type;

class MapUnnester
extends Unnester {
    private ColumnarMap columnarMap;

    public MapUnnester(Type keyType, Type valueType) {
        super(keyType, valueType);
    }

    @Override
    protected void processCurrentPosition(int requiredOutputCount) {
        int mapLength = this.columnarMap.getEntryCount(this.getCurrentPosition());
        int startingOffset = this.columnarMap.getOffset(this.getCurrentPosition());
        this.getBlockBuilder(0).appendRange(startingOffset, mapLength);
        this.getBlockBuilder(1).appendRange(startingOffset, mapLength);
        this.appendNulls(requiredOutputCount - mapLength);
    }

    @Override
    protected void appendNulls(int count) {
        for (int i = 0; i < count; ++i) {
            this.getBlockBuilder(0).appendNull();
            this.getBlockBuilder(1).appendNull();
        }
    }

    @Override
    public int getChannelCount() {
        return 2;
    }

    @Override
    public int getInputEntryCount() {
        if (this.columnarMap == null) {
            return 0;
        }
        return this.columnarMap.getPositionCount();
    }

    @Override
    protected void resetColumnarStructure(Block block) {
        this.columnarMap = ColumnarMap.toColumnarMap((Block)block);
    }

    @Override
    protected Block getElementsBlock(int channel) {
        Preconditions.checkState((channel == 0 || channel == 1 ? 1 : 0) != 0, (Object)"index is not 0 or 1");
        if (channel == 0) {
            return this.columnarMap.getKeysBlock();
        }
        return this.columnarMap.getValuesBlock();
    }

    @Override
    protected int getElementsLength(int index) {
        return this.columnarMap.getEntryCount(index);
    }
}

