/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.spi.function.Description;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlType;
import java.math.RoundingMode;
import java.text.DecimalFormat;

public final class FormatNumberFunction {
    private final DecimalFormat format3Number = new DecimalFormat("#.##");
    private final DecimalFormat format2Number;
    private final DecimalFormat format1Number;

    public FormatNumberFunction() {
        this.format3Number.setRoundingMode(RoundingMode.HALF_UP);
        this.format2Number = new DecimalFormat("#.#");
        this.format2Number.setRoundingMode(RoundingMode.HALF_UP);
        this.format1Number = new DecimalFormat("#");
        this.format1Number.setRoundingMode(RoundingMode.HALF_UP);
    }

    @ScalarFunction
    @Description(value="Formats large number using a unit symbol")
    @SqlType(value="varchar")
    public Slice formatNumber(@SqlType(value="bigint") long value) {
        return Slices.utf8Slice((String)this.format(value));
    }

    @ScalarFunction
    @Description(value="Formats large number using a unit symbol")
    @SqlType(value="varchar")
    public Slice formatNumber(@SqlType(value="double") double value) {
        return Slices.utf8Slice((String)this.format((long)value));
    }

    private String format(long count) {
        double fractional = count;
        String unit = "";
        if (fractional >= 1000.0 || fractional <= -1000.0) {
            fractional /= 1000.0;
            unit = "K";
        }
        if (fractional >= 1000.0 || fractional <= -1000.0) {
            fractional /= 1000.0;
            unit = "M";
        }
        if (fractional >= 1000.0 || fractional <= -1000.0) {
            fractional /= 1000.0;
            unit = "B";
        }
        if (fractional >= 1000.0 || fractional <= -1000.0) {
            fractional /= 1000.0;
            unit = "T";
        }
        if (fractional >= 1000.0 || fractional <= -1000.0) {
            fractional /= 1000.0;
            unit = "Q";
        }
        return this.getFormat(fractional).format(fractional) + unit;
    }

    private DecimalFormat getFormat(double value) {
        if (value < 10.0) {
            return this.format3Number;
        }
        if (value < 100.0) {
            return this.format2Number;
        }
        return this.format1Number;
    }
}

